/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.utils.lock.MapWithLock;

public class ClientNodes {
    private static Logger log = LoggerFactory.getLogger(ClientNodes.class);
    private MapWithLock<String, ChannelContext> mapWithLock = new MapWithLock();

    public static String getKey(ChannelContext channelContext) {
        Node clientNode = channelContext.getClientNode();
        if (clientNode == null) {
            throw new RuntimeException("client node is null");
        }
        String key = ClientNodes.getKey(clientNode.getIp(), clientNode.getPort());
        return key;
    }

    public static String getKey(String ip, int port) {
        String key = ip + ":" + port;
        return key;
    }

    public ChannelContext find(String key) {
        ReentrantReadWriteLock.ReadLock lock = this.mapWithLock.readLock();
        lock.lock();
        try {
            Map m = (Map)this.mapWithLock.getObj();
            ChannelContext channelContext = (ChannelContext)((Object)m.get(key));
            return channelContext;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public ChannelContext find(String ip, int port) {
        String key = ClientNodes.getKey(ip, port);
        return this.find(key);
    }

    public MapWithLock<String, ChannelContext> getObjWithLock() {
        return this.mapWithLock;
    }

    public void put(ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            String key = ClientNodes.getKey(channelContext);
            this.mapWithLock.put((Object)key, (Object)channelContext);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public void remove(ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            String key = ClientNodes.getKey(channelContext);
            this.mapWithLock.remove((Object)key);
        }
        catch (Throwable e) {
            log.error("", e);
        }
    }
}

