/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.lock.MapWithLock;

public class Ids {
    private static Logger log = LoggerFactory.getLogger(Ids.class);
    private MapWithLock<String, ChannelContext> map = new MapWithLock(new HashMap());

    public void bind(ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            String key = channelContext.getId();
            if (StrUtil.isBlank((CharSequence)key)) {
                return;
            }
            this.map.put((Object)key, (Object)channelContext);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public ChannelContext find(TioConfig tioConfig, String id) {
        if (tioConfig.isShortConnection) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)id)) {
            return null;
        }
        return (ChannelContext)((Object)this.map.get((Object)id));
    }

    public MapWithLock<String, ChannelContext> getMap() {
        return this.map;
    }

    public void unbind(ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            String key = channelContext.getId();
            if (StrUtil.isBlank((CharSequence)key)) {
                return;
            }
            this.map.remove((Object)key);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

