/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.clu.client.CluClient;
import org.tio.clu.common.BindType;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.lock.LockUtils;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.SetWithLock;

public class Ips {
    private static Logger log = LoggerFactory.getLogger(Ips.class);
    private MapWithLock<String, SetWithLock<ChannelContext>> ipmap = new MapWithLock(new HashMap());
    private String rwKey = "_tio_ips__";

    public void bind(ChannelContext channelContext) {
        if (channelContext == null) {
            return;
        }
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            String ip = channelContext.getClientNode().getIp();
            if ("$UNKNOWN".equals(ip)) {
                return;
            }
            if (StrUtil.isBlank((CharSequence)ip)) {
                return;
            }
            SetWithLock channelSet = (SetWithLock)this.ipmap.get((Object)ip);
            if (channelSet == null) {
                LockUtils.runWriteOrWaitRead((String)(this.rwKey + ip), (Object)this, () -> {
                    if (this.ipmap.get((Object)ip) == null) {
                        this.ipmap.put((Object)ip, (Object)new SetWithLock(new HashSet()));
                        CluClient.bindXxx(channelContext.getTioConfig(), BindType.Ip, ip);
                    }
                });
                channelSet = (SetWithLock)this.ipmap.get((Object)ip);
            }
            channelSet.add((Object)channelContext);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public SetWithLock<ChannelContext> clients(TioConfig tioConfig, String ip) {
        if (tioConfig.isShortConnection) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)ip)) {
            return null;
        }
        return (SetWithLock)this.ipmap.get((Object)ip);
    }

    public MapWithLock<String, SetWithLock<ChannelContext>> getIpmap() {
        return this.ipmap;
    }

    public void unbind(ChannelContext channelContext) {
        if (channelContext == null) {
            return;
        }
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            String ip = channelContext.getClientNode().getIp();
            if (StrUtil.isBlank((CharSequence)ip)) {
                return;
            }
            if ("$UNKNOWN".equals(ip)) {
                return;
            }
            SetWithLock channelSet = (SetWithLock)this.ipmap.get((Object)ip);
            if (channelSet != null) {
                channelSet.remove((Object)channelContext);
                if (channelSet.size() == 0) {
                    this.ipmap.remove((Object)ip);
                    CluClient.unbindXxx(channelContext.getTioConfig(), BindType.Ip, ip);
                }
            } else {
                log.info("{}, ip\u3010{}\u3011 \u627e\u4e0d\u5230\u5bf9\u5e94\u7684SetWithLock", (Object)channelContext.tioConfig.getName(), (Object)ip);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

