/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl.facade;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ssl.facade.AppendableBuffer;
import org.tio.core.ssl.facade.BufferType;
import org.tio.core.ssl.facade.BufferUtils;

class Buffers {
    private static Logger log = LoggerFactory.getLogger(Buffers.class);
    private ByteBuffer _peerApp;
    private ByteBuffer _myApp;
    private ByteBuffer _peerNet;
    private ByteBuffer _myNet;
    private final AppendableBuffer waitUnwrapBuffer;
    private final SSLSession ssLSession;
    private ChannelContext channelContext;

    public Buffers(SSLSession ssLSession, ChannelContext channelContext) {
        this.channelContext = channelContext;
        this.ssLSession = ssLSession;
        this.allocate();
        this.waitUnwrapBuffer = new AppendableBuffer();
    }

    ByteBuffer get(BufferType t) {
        ByteBuffer result = null;
        switch (t) {
            case IN_PLAIN: {
                result = this._peerApp;
                break;
            }
            case IN_CIPHER: {
                result = this._peerNet;
                break;
            }
            case OUT_PLAIN: {
                result = this._myApp;
                break;
            }
            case OUT_CIPHER: {
                result = this._myNet;
            }
        }
        return result;
    }

    void grow(BufferType t) {
        switch (t) {
            case IN_PLAIN: {
                this.assign(t, this.grow(t, this.ssLSession.getApplicationBufferSize()));
                break;
            }
            case IN_CIPHER: {
                this.assign(t, this.grow(t, this.ssLSession.getPacketBufferSize()));
                break;
            }
            case OUT_PLAIN: {
                break;
            }
            case OUT_CIPHER: {
                this.assign(t, this.grow(t, this.ssLSession.getPacketBufferSize()));
            }
        }
    }

    ByteBuffer grow(BufferType b, int recommendedBufferSize) {
        ByteBuffer originalBuffer = this.get(b);
        ByteBuffer newBuffer = ByteBuffer.allocate(recommendedBufferSize);
        BufferUtils.copy(originalBuffer, newBuffer);
        return newBuffer;
    }

    void prepareForUnwrap(ByteBuffer data) {
        this.clear(BufferType.IN_CIPHER, BufferType.IN_PLAIN);
        if (data != null) {
            try {
                ByteBuffer newBuffer = this.growIfNecessary(BufferType.IN_CIPHER, data.limit());
                newBuffer.put(data);
                newBuffer.flip();
            }
            catch (Exception e) {
                log.error(", data: " + data + ", BufferType.IN_CIPHER:" + this.get(BufferType.IN_CIPHER), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    void prepareForWrap(ByteBuffer plainData) {
        this.clear(BufferType.OUT_PLAIN, BufferType.OUT_CIPHER);
        if (plainData != null) {
            ByteBuffer newBuffer = this.growIfNecessary(BufferType.OUT_PLAIN, plainData.limit());
            newBuffer.put(plainData);
            newBuffer.flip();
        }
    }

    ByteBuffer prependCached(ByteBuffer data) {
        if (data == null) {
            return this.waitUnwrapBuffer.get();
        }
        ByteBuffer result = this.waitUnwrapBuffer.append(data);
        result.rewind();
        return result;
    }

    void cache(ByteBuffer data) {
        if (data != null) {
            this.waitUnwrapBuffer.set(data);
        }
    }

    void clearCache() {
        this.waitUnwrapBuffer.clear();
    }

    boolean isCacheEmpty() {
        return !this.waitUnwrapBuffer.hasRemaining();
    }

    private void allocate() {
        int applicationBufferSize = this.ssLSession.getApplicationBufferSize();
        int packetBufferSize = this.ssLSession.getPacketBufferSize();
        this._peerApp = ByteBuffer.allocate(applicationBufferSize);
        this._myApp = ByteBuffer.allocate(applicationBufferSize);
        this._peerNet = ByteBuffer.allocate(packetBufferSize);
        this._myNet = ByteBuffer.allocate(packetBufferSize);
    }

    private void clear(BufferType source, BufferType destination) {
        this.get(source).clear();
        this.get(destination).clear();
    }

    private void assign(BufferType t, ByteBuffer b) {
        switch (t) {
            case IN_PLAIN: {
                this._peerApp = b;
                break;
            }
            case IN_CIPHER: {
                this._peerNet = b;
                break;
            }
            case OUT_PLAIN: {
                this._myApp = b;
                break;
            }
            case OUT_CIPHER: {
                this._myNet = b;
            }
        }
    }

    private void resetSize(BufferType t, int size) {
        ByteBuffer newBuffer = ByteBuffer.allocate(size);
        BufferUtils.copy(this.get(t), newBuffer);
        this.assign(t, newBuffer);
    }

    private ByteBuffer growIfNecessary(BufferType t, int size) {
        ByteBuffer b = this.get(t);
        if (b.position() + size > b.capacity()) {
            this.resetSize(t, b.limit() + size);
        }
        return this.get(t);
    }
}

