/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.core.stat.ChannelStat;
import org.tio.core.stat.IpStat;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.utils.SystemTimer;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.queue.FullWaitQueue;
import org.tio.utils.queue.TioFullWaitQueue;
import org.tio.utils.thread.pool.AbstractQueueRunnable;

public class DecodeRunnable
extends AbstractQueueRunnable<ByteBuffer> {
    private static final Logger log = LoggerFactory.getLogger(DecodeRunnable.class);
    private ChannelContext channelContext = null;
    private TioConfig tioConfig = null;
    private ByteBuffer lastByteBuffer = null;
    private ByteBuffer newReceivedByteBuffer = null;
    private FullWaitQueue<ByteBuffer> msgQueue = null;

    public void handler(Packet packet, int byteCount) {
        switch (this.tioConfig.packetHandlerMode) {
            case SINGLE_THREAD: {
                this.channelContext.handlerRunnable.handler(packet);
                break;
            }
            case QUEUE: {
                this.channelContext.handlerRunnable.addMsg(packet);
                this.channelContext.handlerRunnable.execute();
                break;
            }
            default: {
                this.channelContext.handlerRunnable.handler(packet);
            }
        }
    }

    public DecodeRunnable(ChannelContext channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
        this.tioConfig = channelContext.tioConfig;
        this.getMsgQueue();
    }

    public void clearMsgQueue() {
        super.clearMsgQueue();
        this.lastByteBuffer = null;
        this.newReceivedByteBuffer = null;
    }

    public void runTask() {
        while ((this.newReceivedByteBuffer = (ByteBuffer)this.msgQueue.poll()) != null) {
            this.decode();
        }
    }

    public void decode() {
        ByteBuffer byteBuffer = this.newReceivedByteBuffer;
        if (this.lastByteBuffer != null) {
            byteBuffer = ByteBufferUtils.composite(this.lastByteBuffer, byteBuffer);
            this.lastByteBuffer = null;
        }
        try {
            while (true) {
                int initPosition = byteBuffer.position();
                int limit = byteBuffer.limit();
                int readableLength = limit - initPosition;
                Packet packet = null;
                if (this.channelContext.packetNeededLength != null) {
                    if (log.isInfoEnabled()) {
                        log.info("{}, \u89e3\u7801\u6240\u9700\u957f\u5ea6:{}", (Object)this.channelContext, (Object)this.channelContext.packetNeededLength);
                    }
                    if (readableLength >= this.channelContext.packetNeededLength) {
                        packet = this.tioConfig.getAioHandler().decode(byteBuffer, limit, initPosition, readableLength, this.channelContext);
                    }
                } else {
                    try {
                        packet = this.tioConfig.getAioHandler().decode(byteBuffer, limit, initPosition, readableLength, this.channelContext);
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        // empty catch block
                    }
                }
                if (packet == null) {
                    if (this.tioConfig.useQueueDecode || byteBuffer != this.newReceivedByteBuffer) {
                        byteBuffer.position(initPosition);
                        byteBuffer.limit(limit);
                        this.lastByteBuffer = byteBuffer;
                    } else {
                        this.lastByteBuffer = ByteBufferUtils.copy(byteBuffer, initPosition, limit);
                    }
                    ChannelStat channelStat = this.channelContext.stat;
                    ++channelStat.decodeFailCount;
                    if (log.isInfoEnabled()) {
                        log.info("{} \u672c\u6b21\u89e3\u7801\u5931\u8d25, \u5df2\u7ecf\u8fde\u7eed{}\u6b21\u89e3\u7801\u5931\u8d25\uff0c\u53c2\u4e0e\u89e3\u7801\u7684\u6570\u636e\u957f\u5ea6\u5171{}\u5b57\u8282", new Object[]{this.channelContext, channelStat.decodeFailCount, readableLength});
                    }
                    if (channelStat.decodeFailCount > 5) {
                        int per;
                        if (this.channelContext.packetNeededLength == null && log.isInfoEnabled()) {
                            log.info("{} \u672c\u6b21\u89e3\u7801\u5931\u8d25, \u5df2\u7ecf\u8fde\u7eed{}\u6b21\u89e3\u7801\u5931\u8d25\uff0c\u53c2\u4e0e\u89e3\u7801\u7684\u6570\u636e\u957f\u5ea6\u5171{}\u5b57\u8282", new Object[]{this.channelContext, channelStat.decodeFailCount, readableLength});
                        }
                        if (channelStat.decodeFailCount > 10 && (per = readableLength / channelStat.decodeFailCount) < Math.min(this.channelContext.getReadBufferSize() / 2, 256)) {
                            String str = "\u8fde\u7eed\u89e3\u7801" + channelStat.decodeFailCount + "\u6b21\u90fd\u4e0d\u6210\u529f\uff0c\u5e76\u4e14\u5e73\u5747\u6bcf\u6b21\u63a5\u6536\u5230\u7684\u6570\u636e\u4e3a" + per + "\u5b57\u8282\uff0c\u6709\u6162\u653b\u51fb\u7684\u5acc\u7591";
                            throw new TioDecodeException(str);
                        }
                    }
                    return;
                }
                this.channelContext.setPacketNeededLength(null);
                this.channelContext.stat.latestTimeOfReceivedPacket = SystemTimer.currTime;
                this.channelContext.stat.decodeFailCount = 0;
                int packetSize = byteBuffer.position() - initPosition;
                packet.setByteCount(packetSize);
                if (this.tioConfig.statOn) {
                    this.tioConfig.groupStat.receivedPackets.incrementAndGet();
                    this.channelContext.stat.receivedPackets.incrementAndGet();
                }
                if (CollUtil.isNotEmpty(this.tioConfig.ipStats.durationList)) {
                    try {
                        for (Long v : this.tioConfig.ipStats.durationList) {
                            IpStat ipStat = this.tioConfig.ipStats.get(v, this.channelContext);
                            ipStat.getReceivedPackets().incrementAndGet();
                            this.tioConfig.getIpStatListener().onAfterDecoded(this.channelContext, packet, packetSize, ipStat);
                        }
                    }
                    catch (Exception e1) {
                        log.error(packet.logstr(), (Throwable)e1);
                    }
                }
                if (this.tioConfig.getAioListener() != null) {
                    try {
                        this.tioConfig.getAioListener().onAfterDecoded(this.channelContext, packet, packetSize);
                    }
                    catch (Throwable e) {
                        log.error("", e);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("{}, \u89e3\u5305\u83b7\u5f97\u4e00\u4e2apacket:{}", (Object)this.channelContext, (Object)packet.logstr());
                }
                this.handler(packet, packetSize);
                if (!byteBuffer.hasRemaining()) break;
                if (!log.isDebugEnabled()) continue;
                log.debug("{},\u7ec4\u5305\u540e\uff0c\u8fd8\u5269\u6709\u6570\u636e:{}", (Object)this.channelContext, (Object)byteBuffer.remaining());
            }
            this.lastByteBuffer = null;
            if (log.isDebugEnabled()) {
                log.debug("{},\u7ec4\u5305\u540e\uff0c\u6570\u636e\u521a\u597d\u7528\u5b8c", (Object)this.channelContext);
            }
            return;
        }
        catch (Throwable e) {
            List<Long> list;
            if (this.channelContext.logWhenDecodeError) {
                log.error("\u89e3\u7801\u65f6\u9047\u5230\u5f02\u5e38", e);
            }
            this.channelContext.setPacketNeededLength(null);
            if (e instanceof TioDecodeException && (list = this.tioConfig.ipStats.durationList) != null && list.size() > 0) {
                try {
                    for (Long v : list) {
                        IpStat ipStat = this.tioConfig.ipStats.get(v, this.channelContext);
                        ipStat.getDecodeErrorCount().incrementAndGet();
                        this.tioConfig.getIpStatListener().onDecodeError(this.channelContext, ipStat);
                    }
                }
                catch (Exception e1) {
                    log.error(e1.toString(), (Throwable)e1);
                }
            }
            Tio.close(this.channelContext, e, "\u89e3\u7801\u5f02\u5e38:" + e.getMessage(), ChannelContext.CloseCode.DECODE_ERROR);
            return;
        }
    }

    public void setNewReceivedByteBuffer(ByteBuffer newReceivedByteBuffer) {
        this.newReceivedByteBuffer = newReceivedByteBuffer;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.channelContext.toString();
    }

    public String logstr() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullWaitQueue<ByteBuffer> getMsgQueue() {
        if (this.tioConfig.useQueueDecode) {
            if (this.msgQueue == null) {
                DecodeRunnable decodeRunnable = this;
                synchronized (decodeRunnable) {
                    if (this.msgQueue == null) {
                        this.msgQueue = new TioFullWaitQueue(Integer.getInteger("tio.fullqueue.capacity", null), true);
                    }
                }
            }
            return this.msgQueue;
        }
        return null;
    }
}

