/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.PacketHandlerMode;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.core.stat.IpStat;
import org.tio.utils.SystemTimer;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.queue.FullWaitQueue;
import org.tio.utils.queue.TioFullWaitQueue;
import org.tio.utils.thread.pool.AbstractQueueRunnable;

public class HandlerRunnable
extends AbstractQueueRunnable<Packet> {
    private static final Logger log = LoggerFactory.getLogger(HandlerRunnable.class);
    private ChannelContext channelContext = null;
    private TioConfig tioConfig = null;
    private AtomicLong synFailCount = new AtomicLong();
    private FullWaitQueue<Packet> msgQueue = null;

    public HandlerRunnable(ChannelContext channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
        this.tioConfig = channelContext.tioConfig;
        this.getMsgQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handler(Packet packet) {
        block30: {
            long start = SystemTimer.currTime;
            try {
                Integer synRespNo = packet.getSynRespNo();
                if (synRespNo != null) {
                    Packet initPacket = (Packet)this.tioConfig.synNoMap.get((Object)synRespNo);
                    if (log.isInfoEnabled()) {
                        log.info("remove synRespNo[{}]", (Object)synRespNo);
                    }
                    if (initPacket != null) {
                        Packet packet2 = initPacket;
                        synchronized (packet2) {
                            this.tioConfig.synNoMap.put((Object)synRespNo, (Object)packet);
                            initPacket.notify();
                            break block30;
                        }
                    }
                    log.error("[{}]\u540c\u6b65\u6d88\u606f\u5931\u8d25, synRespNo is {}, \u4f46\u662f\u540c\u6b65\u96c6\u5408\u4e2d\u6ca1\u6709\u5bf9\u5e94key\u503c,\u540c\u6b65\u96c6\u5408size[{}]", new Object[]{this.synFailCount.incrementAndGet(), synRespNo, this.tioConfig.synNoMap.size()});
                    break block30;
                }
                this.tioConfig.getAioHandler().handler(packet, this.channelContext);
            }
            catch (Throwable e) {
                log.error(packet.logstr(), e);
            }
            finally {
                long end = SystemTimer.currTime;
                long iv = end - start;
                if (this.tioConfig.statOn) {
                    this.channelContext.stat.handledPackets.incrementAndGet();
                    if (packet.getByteCount() != null) {
                        this.channelContext.stat.handledBytes.addAndGet(packet.getByteCount().intValue());
                    }
                    this.channelContext.stat.handledPacketCosts.addAndGet(iv);
                    this.tioConfig.groupStat.handledPackets.incrementAndGet();
                    if (packet.getByteCount() != null) {
                        this.tioConfig.groupStat.handledBytes.addAndGet(packet.getByteCount().intValue());
                    }
                    this.tioConfig.groupStat.handledPacketCosts.addAndGet(iv);
                }
                if (CollUtil.isNotEmpty(this.tioConfig.ipStats.durationList)) {
                    try {
                        for (Long v : this.tioConfig.ipStats.durationList) {
                            IpStat ipStat = this.tioConfig.ipStats.get(v, this.channelContext);
                            ipStat.getHandledPackets().incrementAndGet();
                            if (packet.getByteCount() != null) {
                                ipStat.getHandledBytes().addAndGet(packet.getByteCount().intValue());
                            }
                            ipStat.getHandledPacketCosts().addAndGet(iv);
                            this.tioConfig.getIpStatListener().onAfterHandled(this.channelContext, packet, ipStat, iv);
                        }
                    }
                    catch (Exception e1) {
                        log.error(e1.toString(), (Throwable)e1);
                    }
                }
                if (this.tioConfig.getAioListener() != null) {
                    try {
                        this.tioConfig.getAioListener().onAfterHandled(this.channelContext, packet, iv);
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
            }
        }
    }

    public void runTask() {
        Packet packet = null;
        while ((packet = (Packet)this.msgQueue.poll()) != null) {
            this.handler(packet);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.channelContext.toString();
    }

    public String logstr() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullWaitQueue<Packet> getMsgQueue() {
        if (PacketHandlerMode.QUEUE == this.tioConfig.packetHandlerMode) {
            if (this.msgQueue == null) {
                HandlerRunnable handlerRunnable = this;
                synchronized (handlerRunnable) {
                    if (this.msgQueue == null) {
                        this.msgQueue = new TioFullWaitQueue(Integer.getInteger("tio.fullqueue.capacity", null), true);
                    }
                }
            }
            return this.msgQueue;
        }
        return null;
    }
}

