/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.udp;

import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.core.udp.UdpClientConf;
import org.tio.core.udp.task.UdpSendRunnable;
import org.tio.utils.SystemTimer;
import org.tio.utils.hutool.StrUtil;

public class UdpClient {
    private static Logger log = LoggerFactory.getLogger(UdpClient.class);
    private LinkedBlockingQueue<DatagramPacket> queue = new LinkedBlockingQueue();
    private UdpClientConf udpClientConf = null;
    private InetSocketAddress inetSocketAddress = null;
    private UdpSendRunnable udpSendRunnable = null;

    public static void main(String[] args) {
        UdpClientConf udpClientConf = new UdpClientConf("127.0.0.1", 3000, 5000);
        UdpClient udpClient = new UdpClient(udpClientConf);
        udpClient.start();
        long start = SystemTimer.currTime;
        String x = "[{\"collectTime\":\"2019-06-06 11:24:08\",\"TimeWritten\":\"20190605133513.027808-000\",\"Category\":\"12544\",\"EventIdentifier\":\"4624\",\"TimeGenerated\":\"20190605133513.027808-000\",\"User\":\"\",\"Message\":\"\u5df2\u6210\u529f\u767b\u5f55\u5e10\u6237\u3002\u4e3b\u9898:\\t\u5b89\u5168 ID:\\t\\tS-1-5-18\\t\\t\u5e10\u6237\u540d:\\t\\tLWT7R8I9D0QC0VM$\\t\u5e10\u6237\u57df:\\t\\tWorkGroup\\t\u767b\u5f55 ID:\\t\\t0x3e7\u767b\u5f55\u7c7b\u578b:\\t\\t\\t5\u65b0\u767b\u5f55:\\t\u5b89\u5168 ID:\\t\\tS-1-5-18\\t\u5e10\u6237\u540d:\\t\\tSYSTEM\\t\u5e10\u6237\u57df:\\t\\tNT AUTHORITY\\t\u767b\u5f55 ID:\\t\\t0x3e7\\t\u767b\u5f55 GUID:\\t\\t{00000000-0000-0000-0000-000000000000}\u8fdb\u7a0b\u4fe1\u606f:\\t\u8fdb\u7a0b ID:\\t\\t0x2c8\\t\u8fdb\u7a0b\u540d:\\t\\tC:\\\\Windows\\\\System32\\\\services.exe\u7f51\u7edc\u4fe1\u606f:\\t\u5de5\u4f5c\u7ad9\u540d:\\t\\t\u6e90\u7f51\u7edc\u5730\u5740:\\t-\\t\u6e90\u7aef\u53e3:\\t\\t-\u8be6\u7ec6\u8eab\u4efd\u9a8c\u8bc1\u4fe1\u606f:\\t\u767b\u5f55\u8fdb\u7a0b:\\t\\tAdvapi  \\t\u8eab\u4efd\u9a8c\u8bc1\u6570\u636e\u5305:\\tNegotiate\\t\u4f20\u9012\u670d\u52a1:\\t-\\t\u6570\u636e\u5305\u540d(\u4ec5\u9650 NTLM):\\t-\\t\u5bc6\u94a5\u957f\u5ea6:\\t\\t0\u5728\u521b\u5efa\u767b\u5f55\u4f1a\u8bdd\u540e\u5728\u88ab\u8bbf\u95ee\u7684\u8ba1\u7b97\u673a\u4e0a\u751f\u6210\u6b64\u4e8b\u4ef6\u3002\u201c\u4e3b\u9898\u201d\u5b57\u6bb5\u6307\u660e\u672c\u5730\u7cfb\u7edf\u4e0a\u8bf7\u6c42\u767b\u5f55\u7684\u5e10\u6237\u3002\u8fd9\u901a\u5e38\u662f\u4e00\u4e2a\u670d\u52a1(\u4f8b\u5982 Server \u670d\u52a1)\u6216\u672c\u5730\u8fdb\u7a0b(\u4f8b\u5982 Winlogon.exe \u6216 Services.exe)\u3002\u201c\u767b\u5f55\u7c7b\u578b\u201d\u5b57\u6bb5\u6307\u660e\u53d1\u751f\u7684\u767b\u5f55\u79cd\u7c7b\u3002\u6700\u5e38\u89c1\u7684\u7c7b\u578b\u662f 2 (\u4ea4\u4e92\u5f0f)\u548c 3 (\u7f51\u7edc)\u3002\u201c\u65b0\u767b\u5f55\u201d\u5b57\u6bb5\u4f1a\u6307\u660e\u65b0\u767b\u5f55\u662f\u4e3a\u54ea\u4e2a\u5e10\u6237\u521b\u5efa\u7684\uff0c\u5373\u767b\u5f55\u7684\u5e10\u6237\u3002\u201c\u7f51\u7edc\u201d\u5b57\u6bb5\u6307\u660e\u8fdc\u7a0b\u767b\u5f55\u8bf7\u6c42\u6765\u81ea\u54ea\u91cc\u3002\u201c\u5de5\u4f5c\u7ad9\u540d\u201d\u5e76\u975e\u603b\u662f\u53ef\u7528\uff0c\u800c\u4e14\u5728\u67d0\u4e9b\u60c5\u51b5\u4e0b\u53ef\u80fd\u4f1a\u7559\u4e3a\u7a7a\u767d\u3002\u201c\u8eab\u4efd\u9a8c\u8bc1\u4fe1\u606f\u201d\u5b57\u6bb5\u63d0\u4f9b\u5173\u4e8e\u6b64\u7279\u5b9a\u767b\u5f55\u8bf7\u6c42\u7684\u8be6\u7ec6\u4fe1\u606f\u3002\\t-\u201c\u767b\u5f55 GUID\u201d\u662f\u53ef\u4ee5\u7528\u4e8e\u5c06\u6b64\u4e8b\u4ef6\u4e0e\u4e00\u4e2a KDC \u4e8b\u4ef6\u5173\u8054\u8d77\u6765\u7684\u552f\u4e00\u6807\u8bc6\u7b26\u3002\\t-\u201c\u4f20\u9012\u670d\u52a1\u201d\u6307\u660e\u54ea\u4e9b\u76f4\u63a5\u670d\u52a1\u53c2\u4e0e\u4e86\u6b64\u767b\u5f55\u8bf7\u6c42\u3002\\t- \u201c\u6570\u636e\u5305\u540d\u201d\u6307\u660e\u5728 NTLM \u534f\u8bae\u4e4b\u95f4\u4f7f\u7528\u4e86\u54ea\u4e9b\u5b50\u534f\u8bae\u3002\\t-\u201c\u5bc6\u94a5\u957f\u5ea6\u201d\u6307\u660e\u751f\u6210\u7684\u4f1a\u8bdd\u5bc6\u94a5\u7684\u957f\u5ea6\u3002\u5982\u679c\u6ca1\u6709\u8bf7\u6c42\u4f1a\u8bdd\u5bc6\u94a5\u5219\u6b64\u5b57\u6bb5\u4e3a 0\u3002\",\"EventType\":\"4\",\"dataMessages\":\"\",\"SourceName\":\"Microsoft-Windows-Security-Auditing\",\"Data\":\"\",\"EventCode\":\"4624\",\"dataFeatures\":\"Log\",\"Type\":\"\u767b\u5f55\u6210\u529f\",\"metricCodes\":\"s_001\",\"ComputerName\":\"LWT7R8I9D0QC0VM\",\"InsertionStrings\":\"{\\\"S-1-5-18\\\",\\\"LWT7R8I9D0QC0VM$\\\",\\\"WorkGroup\\\",\\\"0x3e7\\\",\\\"S-1-5-18\\\",\\\"SYSTEM\\\",\\\"NT AUTHORITY\\\",\\\"0x3e7\\\",\\\"5\\\",\\\"Advapi  \\\",\\\"Negotiate\\\",\\\"\\\",\\\"{00000000-0000-0000-0000-000000000000}\\\",\\\"-\\\",\\\"-\\\",\\\"0\\\",\\\"0x2c8\\\",\\\"C:\\\\Windows\\\\System32\\\\services.exe\\\",\\\"-\\\",\\\"-\\\"}\",\"CategoryString\":\"\u767b\u5f55\",\"RecordNumber\":\"2682\",\"Logfile\":\"Security\"}, {\"collectTime\":\"2019-06-06 11:24:08\",\"TimeWritten\":\"20190605122905.563801-000\",\"Category\":\"12544\",\"EventIdentifier\":\"4624\",\"TimeGenerated\":\"20190605122905.563801-000\",\"User\":\"\",\"Message\":\"\u5df2\u6210\u529f\u767b\u5f55\u5e10\u6237\u3002\u4e3b\u9898:\\t\u5b89\u5168 ID:\\t\\tS-1-5-18\\t\\t\u5e10\u6237\u540d:\\t\\tLWT7R8I9D0QC0VM$\\t\u5e10\u6237\u57df:\\t\\tWorkGroup\\t\u767b\u5f55 ID:\\t\\t0x3e7\u767b\u5f55\u7c7b\u578b:\\t\\t\\t5\u65b0\u767b\u5f55:\\t\u5b89\u5168 ID:\\t\\tS-1-5-18\\t\u5e10\u6237\u540d:\\t\\tSYSTEM\\t\u5e10\u6237\u57df:\\t\\tNT AUTHORITY\\t\u767b\u5f55 ID:\\t\\t0x3e7\\t\u767b\u5f55 GUID:\\t\\t{00000000-0000-0000-0000-000000000000}\u8fdb\u7a0b\u4fe1\u606f:\\t\u8fdb\u7a0b ID:\\t\\t0x2c8\\t\u8fdb\u7a0b\u540d:\\t\\tC:\\\\Windows\\\\System32\\\\services.exe\u7f51\u7edc\u4fe1\u606f:\\t\u5de5\u4f5c\u7ad9\u540d:\\t\\t\u6e90\u7f51\u7edc\u5730\u5740:\\t-\\t\u6e90\u7aef\u53e3:\\t\\t-\u8be6\u7ec6\u8eab\u4efd\u9a8c\u8bc1\u4fe1\u606f:\\t\u767b\u5f55\u8fdb\u7a0b:\\t\\tAdvapi  \\t\u8eab\u4efd\u9a8c\u8bc1\u6570\u636e\u5305:\\tNegotiate\\t\u4f20\u9012\u670d\u52a1:\\t-\\t\u6570\u636e\u5305\u540d(\u4ec5\u9650 NTLM):\\t-\\t\u5bc6\u94a5\u957f\u5ea6:\\t\\t0\u5728\u521b\u5efa\u767b\u5f55\u4f1a\u8bdd\u540e\u5728\u88ab\u8bbf\u95ee\u7684\u8ba1\u7b97\u673a\u4e0a\u751f\u6210\u6b64\u4e8b\u4ef6\u3002\u201c\u4e3b\u9898\u201d\u5b57\u6bb5\u6307\u660e\u672c\u5730\u7cfb\u7edf\u4e0a\u8bf7\u6c42\u767b\u5f55\u7684\u5e10\u6237\u3002\u8fd9\u901a\u5e38\u662f\u4e00\u4e2a\u670d\u52a1(\u4f8b\u5982 Server \u670d\u52a1)\u6216\u672c\u5730\u8fdb\u7a0b(\u4f8b\u5982 Winlogon.exe \u6216 Services.exe)\u3002\u201c\u767b\u5f55\u7c7b\u578b\u201d\u5b57\u6bb5\u6307\u660e\u53d1\u751f\u7684\u767b\u5f55\u79cd\u7c7b\u3002\u6700\u5e38\u89c1\u7684\u7c7b\u578b\u662f 2 (\u4ea4\u4e92\u5f0f)\u548c 3 (\u7f51\u7edc)\u3002\u201c\u65b0\u767b\u5f55\u201d\u5b57\u6bb5\u4f1a\u6307\u660e\u65b0\u767b\u5f55\u662f\u4e3a\u54ea\u4e2a\u5e10\u6237\u521b\u5efa\u7684\uff0c\u5373\u767b\u5f55\u7684\u5e10\u6237\u3002\u201c\u7f51\u7edc\u201d\u5b57\u6bb5\u6307\u660e\u8fdc\u7a0b\u767b\u5f55\u8bf7\u6c42\u6765\u81ea\u54ea\u91cc\u3002\u201c\u5de5\u4f5c\u7ad9\u540d\u201d\u5e76\u975e\u603b\u662f\u53ef\u7528\uff0c\u800c\u4e14\u5728\u67d0\u4e9b\u60c5\u51b5\u4e0b\u53ef\u80fd\u4f1a\u7559\u4e3a\u7a7a\u767d\u3002\u201c\u8eab\u4efd\u9a8c\u8bc1\u4fe1\u606f\u201d\u5b57\u6bb5\u63d0\u4f9b\u5173\u4e8e\u6b64\u7279\u5b9a\u767b\u5f55\u8bf7\u6c42\u7684\u8be6\u7ec6\u4fe1\u606f\u3002\\t-\u201c\u767b\u5f55 GUID\u201d\u662f\u53ef\u4ee5\u7528\u4e8e\u5c06\u6b64\u4e8b\u4ef6\u4e0e\u4e00\u4e2a KDC \u4e8b\u4ef6\u5173\u8054\u8d77\u6765\u7684\u552f\u4e00\u6807\u8bc6\u7b26\u3002\\t-\u201c\u4f20\u9012\u670d\u52a1\u201d\u6307\u660e\u54ea\u4e9b\u76f4\u63a5\u670d\u52a1\u53c2\u4e0e\u4e86\u6b64\u767b\u5f55\u8bf7\u6c42\u3002\\t- \u201c\u6570\u636e\u5305\u540d\u201d\u6307\u660e\u5728 NTLM \u534f\u8bae\u4e4b\u95f4\u4f7f\u7528\u4e86\u54ea\u4e9b\u5b50\u534f\u8bae\u3002\\t-\u201c\u5bc6\u94a5\u957f\u5ea6\u201d\u6307\u660e\u751f\u6210\u7684\u4f1a\u8bdd\u5bc6\u94a5\u7684\u957f\u5ea6\u3002\u5982\u679c\u6ca1\u6709\u8bf7\u6c42\u4f1a\u8bdd\u5bc6\u94a5\u5219\u6b64\u5b57\u6bb5\u4e3a 0\u3002\",\"EventType\":\"4\",\"dataMessages\":\"\",\"SourceName\":\"Microsoft-Windows-Security-Auditing\",\"Data\":\"\",\"EventCode\":\"4624\",\"dataFeatures\":\"Log\",\"Type\":\"\u767b\u5f55\u6210\u529f\",\"metricCodes\":\"s_001\",\"ComputerName\":\"LWT7R8I9D0QC0VM\",\"InsertionStrings\":\"{\\\"S-1-5-18\\\",\\\"LWT7R8I9D0QC0VM$\\\",\\\"WorkGroup\\\",\\\"0x3e7\\\",\\\"S-1-5-18\\\",\\\"SYSTEM\\\",\\\"NT AUTHORITY\\\",\\\"0x3e7\\\",\\\"5\\\",\\\"Advapi  \\\",\\\"Negotiate\\\",\\\"\\\",\\\"{00000000-0000-0000-0000-000000000000}\\\",\\\"-\\\",\\\"-\\\",\\\"0\\\",\\\"0x2c8\\\",\\\"C:\\\\Windows\\\\System32\\\\services.exe\\\",\\\"-\\\",\\\"-\\\"}\",\"CategoryString\":\"\u767b\u5f55\",\"RecordNumber\":\"2680\",\"Logfile\":\"Security\"}]";
        for (int i = 0; i < 2; ++i) {
            String str = i + "\u3001" + x;
            udpClient.send(str.getBytes());
        }
        long end = SystemTimer.currTime;
        long iv = end - start;
        System.out.println("\u8017\u65f6:" + iv + "ms");
    }

    public UdpClient(UdpClientConf udpClientConf) {
        this.udpClientConf = udpClientConf;
        Node node = this.udpClientConf.getServerNode();
        this.inetSocketAddress = new InetSocketAddress(node.getIp(), node.getPort());
        this.udpSendRunnable = new UdpSendRunnable(this.queue, udpClientConf, null);
    }

    public void send(byte[] data) {
        DatagramPacket datagramPacket = new DatagramPacket(data, data.length, this.inetSocketAddress);
        this.queue.add(datagramPacket);
    }

    public void send(String str) {
        this.send(str, null);
    }

    public void send(String data, String charset) {
        if (StrUtil.isBlank((CharSequence)data)) {
            return;
        }
        try {
            if (StrUtil.isBlank((CharSequence)charset)) {
                charset = this.udpClientConf.getCharset();
            }
            byte[] bs = data.getBytes(charset);
            this.send(bs);
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
    }

    public void start() {
        Thread thread = new Thread((Runnable)this.udpSendRunnable, "tio-udp-client-send");
        thread.setDaemon(false);
        thread.start();
    }
}

