/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.udp.task;

import java.net.DatagramSocket;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.udp.UdpPacket;
import org.tio.core.udp.intf.UdpHandler;

public class UdpHandlerRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(UdpHandlerRunnable.class);
    private UdpHandler udpHandler;
    private LinkedBlockingQueue<UdpPacket> queue;
    private DatagramSocket datagramSocket;
    private boolean isStopped = false;

    public UdpHandlerRunnable(UdpHandler udpHandler, LinkedBlockingQueue<UdpPacket> queue, DatagramSocket datagramSocket) {
        this.udpHandler = udpHandler;
        this.queue = queue;
        this.datagramSocket = datagramSocket;
    }

    @Override
    public void run() {
        while (!this.isStopped) {
            try {
                UdpPacket udpPacket = this.queue.take();
                if (udpPacket == null) continue;
                this.udpHandler.handler(udpPacket, this.datagramSocket);
            }
            catch (Throwable e) {
                log.error("", e);
            }
        }
    }

    public void stop() {
        this.isStopped = true;
    }
}

