/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.ssl.SslUtils;
import org.tio.core.stat.IpStat;
import org.tio.server.ServerChannelContext;
import org.tio.server.ServerGroupStat;
import org.tio.server.ServerTioConfig;
import org.tio.server.TioServer;
import org.tio.utils.SystemTimer;
import org.tio.utils.hutool.CollUtil;

public class AcceptCompletionHandler
implements CompletionHandler<AsynchronousSocketChannel, TioServer> {
    private static Logger log = LoggerFactory.getLogger(AcceptCompletionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(AsynchronousSocketChannel asynchronousSocketChannel, TioServer tioServer) {
        try {
            ServerTioConfig serverTioConfig = tioServer.getServerTioConfig();
            InetSocketAddress inetSocketAddress = (InetSocketAddress)asynchronousSocketChannel.getRemoteAddress();
            String clientIp = inetSocketAddress.getHostString();
            if (Tio.IpBlacklist.isInBlacklist(serverTioConfig, clientIp)) {
                log.info("{}\u5728\u9ed1\u540d\u5355\u4e2d, {}", (Object)clientIp, (Object)serverTioConfig.getName());
                asynchronousSocketChannel.close();
                return;
            }
            if (serverTioConfig.statOn) {
                ((ServerGroupStat)serverTioConfig.groupStat).accepted.incrementAndGet();
            }
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)65536);
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)65536);
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            ServerChannelContext channelContext = new ServerChannelContext((TioConfig)serverTioConfig, asynchronousSocketChannel);
            channelContext.setClosed(false);
            channelContext.stat.setTimeFirstConnected(SystemTimer.currTime);
            channelContext.setServerNode(tioServer.getServerNode());
            serverTioConfig.ips.bind(channelContext);
            boolean isConnected = true;
            boolean isReconnect = false;
            if (serverTioConfig.getServerAioListener() != null && !SslUtils.isSsl(channelContext.tioConfig)) {
                try {
                    serverTioConfig.getServerAioListener().onAfterConnected(channelContext, isConnected, isReconnect);
                }
                catch (Throwable e) {
                    log.error("", e);
                }
            }
            if (CollUtil.isNotEmpty(serverTioConfig.ipStats.durationList)) {
                try {
                    for (Long v : serverTioConfig.ipStats.durationList) {
                        IpStat ipStat = serverTioConfig.ipStats.get(v, channelContext);
                        ipStat.getRequestCount().incrementAndGet();
                        serverTioConfig.getIpStatListener().onAfterConnected(channelContext, isConnected, isReconnect, ipStat);
                    }
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            if (!tioServer.isWaitingStop()) {
                ReadCompletionHandler readCompletionHandler = channelContext.getReadCompletionHandler();
                ByteBuffer readByteBuffer = readCompletionHandler.getReadByteBuffer();
                readByteBuffer.position(0);
                readByteBuffer.limit(readByteBuffer.capacity());
                asynchronousSocketChannel.read(readByteBuffer, readByteBuffer, readCompletionHandler);
            }
        }
        catch (Throwable e) {
            log.error("", e);
        }
        finally {
            if (tioServer.isWaitingStop()) {
                log.info("{}\u5373\u5c06\u5173\u95ed\u670d\u52a1\u5668\uff0c\u4e0d\u518d\u63a5\u53d7\u65b0\u8bf7\u6c42", (Object)tioServer.getServerNode());
            } else {
                AsynchronousServerSocketChannel serverSocketChannel = tioServer.getServerSocketChannel();
                serverSocketChannel.accept(tioServer, this);
            }
        }
    }

    @Override
    public void failed(Throwable exc, TioServer tioServer) {
        AsynchronousServerSocketChannel serverSocketChannel = tioServer.getServerSocketChannel();
        serverSocketChannel.accept(tioServer, this);
        log.error("[" + tioServer.getServerNode() + "]\u76d1\u542c\u51fa\u73b0\u5f02\u5e38", exc);
    }
}

