/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.URL;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.ServerTioConfig;
import org.tio.utils.IoUtils;
import org.tio.utils.hutool.DateUtil;
import org.tio.utils.hutool.StrUtil;

public class TioServer {
    private static Logger log = LoggerFactory.getLogger(TioServer.class);
    private ServerTioConfig serverTioConfig;
    private AsynchronousServerSocketChannel serverSocketChannel;
    private AsynchronousChannelGroup channelGroup = null;
    private Node serverNode = null;
    private boolean isWaitingStop = false;
    private boolean checkLastVersion = true;

    public TioServer(ServerTioConfig serverTioConfig) {
        this.serverTioConfig = serverTioConfig;
    }

    public ServerTioConfig getServerTioConfig() {
        return this.serverTioConfig;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public AsynchronousServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    public boolean isWaitingStop() {
        return this.isWaitingStop;
    }

    public void setServerTioConfig(ServerTioConfig serverTioConfig) {
        this.serverTioConfig = serverTioConfig;
    }

    public void setWaitingStop(boolean isWaitingStop) {
        this.isWaitingStop = isWaitingStop;
    }

    public void start(String serverIp, int serverPort) throws IOException {
        long start = System.currentTimeMillis();
        this.serverNode = new Node(serverIp, serverPort);
        this.channelGroup = AsynchronousChannelGroup.withThreadPool(this.serverTioConfig.groupExecutor);
        this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.channelGroup);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)65536);
        InetSocketAddress listenAddress = null;
        listenAddress = StrUtil.isBlank((CharSequence)serverIp) ? new InetSocketAddress(serverPort) : new InetSocketAddress(serverIp, serverPort);
        this.serverSocketChannel.bind(listenAddress, 0);
        AcceptCompletionHandler acceptCompletionHandler = this.serverTioConfig.getAcceptCompletionHandler();
        this.serverSocketChannel.accept(this, acceptCompletionHandler);
        this.serverTioConfig.startTime = System.currentTimeMillis();
        String baseStr = "|----------------------------------------------------------------------------------------|";
        int baseLen = baseStr.length();
        StackTraceElement[] ses = Thread.currentThread().getStackTrace();
        StackTraceElement se = ses[ses.length - 1];
        int xxLen = 18;
        int aaLen = baseLen - 3;
        ArrayList<String> infoList = new ArrayList<String>();
        infoList.add(StrUtil.fillAfter((String)"t-io site", (char)' ', (int)xxLen) + "| " + "https://www.tiocloud.com");
        infoList.add(StrUtil.fillAfter((String)"t-io on gitee", (char)' ', (int)xxLen) + "| " + "https://gitee.com/tywo45/t-io");
        infoList.add(StrUtil.fillAfter((String)"t-io on github", (char)' ', (int)xxLen) + "| " + "https://github.com/tywo45/t-io");
        infoList.add(StrUtil.fillAfter((String)"t-io version", (char)' ', (int)xxLen) + "| " + "3.7.0.v20201010-RELEASE");
        infoList.add(StrUtil.fillAfter((String)"-", (char)'-', (int)aaLen));
        infoList.add(StrUtil.fillAfter((String)"TioConfig name", (char)' ', (int)xxLen) + "| " + this.serverTioConfig.getName());
        infoList.add(StrUtil.fillAfter((String)"Started at", (char)' ', (int)xxLen) + "| " + DateUtil.formatDateTime((Date)new Date()));
        infoList.add(StrUtil.fillAfter((String)"Listen on", (char)' ', (int)xxLen) + "| " + this.serverNode);
        infoList.add(StrUtil.fillAfter((String)"Main Class", (char)' ', (int)xxLen) + "| " + se.getClassName());
        try {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            String runtimeName = runtimeMxBean.getName();
            String pid = runtimeName.split("@")[0];
            long startTime = runtimeMxBean.getStartTime();
            long startCost = System.currentTimeMillis() - startTime;
            infoList.add(StrUtil.fillAfter((String)"Jvm start time", (char)' ', (int)xxLen) + "| " + startCost + "ms");
            infoList.add(StrUtil.fillAfter((String)"Tio start time", (char)' ', (int)xxLen) + "| " + (System.currentTimeMillis() - start) + "ms");
            infoList.add(StrUtil.fillAfter((String)"Pid", (char)' ', (int)xxLen) + "| " + pid);
        }
        catch (Exception runtimeMxBean) {
            // empty catch block
        }
        String printStr = "\r\n" + baseStr + "\r\n";
        for (String string : infoList) {
            printStr = printStr + "| " + StrUtil.fillAfter((String)string, (char)' ', (int)aaLen) + "|\r\n";
        }
        printStr = printStr + baseStr + "\r\n";
        if (log.isInfoEnabled()) {
            log.info(printStr);
        } else {
            System.out.println(printStr);
        }
        this.checkLastVersion();
    }

    public boolean stop() {
        this.isWaitingStop = true;
        boolean ret = true;
        try {
            this.channelGroup.shutdownNow();
        }
        catch (Exception e) {
            log.error("channelGroup.shutdownNow()\u65f6\u62a5\u9519", (Throwable)e);
        }
        try {
            this.serverSocketChannel.close();
        }
        catch (Exception e1) {
            log.error("serverSocketChannel.close()\u65f6\u62a5\u9519", (Throwable)e1);
        }
        try {
            this.serverTioConfig.groupExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.toString(), (Throwable)e1);
        }
        try {
            this.serverTioConfig.tioExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.toString(), (Throwable)e1);
        }
        this.serverTioConfig.setStopped(true);
        try {
            ret = ret && this.serverTioConfig.groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            ret = ret && this.serverTioConfig.tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        log.info(this.serverNode + " stopped");
        return ret;
    }

    private void checkLastVersion() {
        if (this.checkLastVersion) {
            this.serverTioConfig.groupExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        URL url = new URL("https://www.tiocloud.com/mytio/open/lastVersion1.tio_x?v=3.7.0.v20201010-RELEASE");
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("GET");
                        connection.setConnectTimeout(10000);
                        connection.connect();
                        int responseCode = connection.getResponseCode();
                        if (responseCode == 200) {
                            InputStream inputStream = connection.getInputStream();
                            String result = IoUtils.streamToString((InputStream)inputStream);
                            connection.disconnect();
                            url = new URL("https://www.tiocloud.com/mytio/open/lastVersion2.tio_x?e=1&id=" + result);
                            connection = (HttpURLConnection)url.openConnection();
                            connection.setRequestMethod("GET");
                            connection.setConnectTimeout(10000);
                            connection.connect();
                            responseCode = connection.getResponseCode();
                            if (responseCode == 200) {
                                inputStream = connection.getInputStream();
                                result = IoUtils.streamToString((InputStream)inputStream);
                                if ("3.7.0.v20201010-RELEASE".equals(result)) {
                                    log.info("The version you are using is the latest");
                                } else {
                                    log.info("t-io latest version:{}\uff0cyour version:{}", (Object)result, (Object)"3.7.0.v20201010-RELEASE");
                                    String myVersionDateStr = "3.7.0.v20201010-RELEASE".substring("3.7.0.v20201010-RELEASE".length() - 16, "3.7.0.v20201010-RELEASE".length() - 8);
                                    String latestVersionDateStr = result.substring(result.length() - 16, result.length() - 8);
                                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                                    Date myVersionDate = format.parse(myVersionDateStr);
                                    Date latestVersionDate = format.parse(latestVersionDateStr);
                                    Integer days = DateUtil.daysBetween((Date)myVersionDate, (Date)latestVersionDate);
                                    log.info("You haven't upgraded in {} days", (Object)days);
                                }
                            }
                            connection.disconnect();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public boolean isCheckLastVersion() {
        return this.checkLastVersion;
    }

    public void setCheckLastVersion(boolean checkLastVersion) {
        log.debug("community edition is no longer supported");
    }

    public static void main(String[] args) {
        System.out.print(StandardCharsets.UTF_8.name());
    }
}

