/*
 * Decompiled with CFR 0.152.
 */
package org.tio.flash.policy.server;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.LengthOverflowException;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.flash.policy.server.FlashPolicyPacket;
import org.tio.server.intf.ServerAioHandler;

public class FlashPolicyServerAioHandler
implements ServerAioHandler {
    private static Logger log = LoggerFactory.getLogger(FlashPolicyServerAioHandler.class);
    public static final String REQUEST_STR = "<policy-file-request/>";
    public static byte[] RESPONSE_BYTES = "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>\u0000".getBytes();

    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        Tio.send((ChannelContext)channelContext, (Packet)FlashPolicyPacket.RESPONSE);
    }

    public FlashPolicyPacket decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws TioDecodeException {
        if (readableLength < 22) {
            return null;
        }
        String line = null;
        try {
            line = ByteBufferUtils.readString((ByteBuffer)buffer, (String)"utf-8", (char)'\u0000', (Integer)256);
        }
        catch (LengthOverflowException e) {
            throw new TioDecodeException((Throwable)e);
        }
        if (line == null) {
            return null;
        }
        log.info("\u6536\u5230\u6d88\u606f:{}", (Object)line);
        if (REQUEST_STR.equalsIgnoreCase(line)) {
            return FlashPolicyPacket.REQUEST;
        }
        throw new TioDecodeException("");
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        ByteBuffer ret = ByteBuffer.wrap(RESPONSE_BYTES);
        return ret;
    }
}

