/*
 * Decompiled with CFR 0.152.
 */
package org.tio.flash.policy.server;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.flash.policy.server.FlashPolicyServerAioHandler;
import org.tio.server.ServerTioConfig;
import org.tio.server.TioServer;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;
import org.tio.utils.SystemTimer;
import org.tio.utils.Threads;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class FlashPolicyServerStarter {
    private static Logger log = LoggerFactory.getLogger(FlashPolicyServerStarter.class);
    public static ServerAioHandler aioHandler = null;
    public static ServerAioListener aioListener = null;
    public static ServerTioConfig serverTioConfig = null;
    public static TioServer tioServer = null;
    public static int count = 1;

    public static void start(String ip, Integer port, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        if (port == null) {
            port = 843;
        }
        aioHandler = new FlashPolicyServerAioHandler();
        serverTioConfig = new ServerTioConfig("tio flash policy server", aioHandler, aioListener, tioExecutor, groupExecutor);
        serverTioConfig.setHeartbeatTimeout(0L);
        tioServer = new TioServer(serverTioConfig);
        try {
            tioServer.start(ip, port.intValue());
        }
        catch (Throwable e) {
            log.error("", e);
            System.exit(1);
        }
        FlashPolicyServerStarter.checkAllChannels();
    }

    public static void start(String ip, Integer port) {
        FlashPolicyServerStarter.start(ip, port, Threads.getTioExecutor(), Threads.getGroupExecutor());
    }

    private static void checkAllChannels() {
        Thread thread = new Thread((Runnable)new CheckRunnable(), "Flash-Policy-Server-" + count++);
        thread.start();
    }

    public static class CheckRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    log.error(e1.toString(), (Throwable)e1);
                }
                SetWithLock setWithLock = FlashPolicyServerStarter.serverTioConfig.connections;
                Set set = null;
                ReentrantReadWriteLock.ReadLock readLock = setWithLock.readLock();
                readLock.lock();
                try {
                    long now = SystemTimer.currTime;
                    set = (Set)setWithLock.getObj();
                    Iterator iterator = set.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block7;
                        ChannelContext channelContext = (ChannelContext)iterator.next();
                        long interval = now - channelContext.stat.timeFirstConnected;
                        if (interval <= 5000L) continue;
                        Tio.remove((ChannelContext)channelContext, (String)("\u5df2\u7ecf\u8fde\u4e0a\u6765\u6709" + interval + "ms\u4e86\uff0c\u8be5\u65ad\u5f00\u5566"));
                    }
                }
                catch (Throwable e) {
                    log.error("", e);
                    continue;
                }
                finally {
                    readLock.unlock();
                    continue;
                }
                break;
            }
        }
    }
}

