/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.mvc;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.mvc.DefaultControllerFactory;
import org.tio.http.server.mvc.PathUnitVo;
import org.tio.http.server.mvc.VariablePathVo;
import org.tio.http.server.mvc.intf.ControllerFactory;
import org.tio.utils.hutool.ArrayUtil;
import org.tio.utils.hutool.ClassScanAnnotationHandler;
import org.tio.utils.hutool.ClassScanHandler;
import org.tio.utils.hutool.ClassUtil;
import org.tio.utils.hutool.FileUtil;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.Json;

public class Routes {
    private static Logger log = LoggerFactory.getLogger(Routes.class);
    public static final String META_PATH_KEY = "TIO_HTTP_META_PATH";
    public final Map<String, Object> PATH_BEAN_MAP = new TreeMap<String, Object>();
    public static final Map<Class<?>, Object> CLASS_BEAN_MAP = new HashMap();
    public static final Map<Object, MethodAccess> BEAN_METHODACCESS_MAP = new HashMap<Object, MethodAccess>();
    public final Map<String, Class<?>> PATH_CLASS_MAP = new TreeMap();
    public static final Map<Class<?>, String> CLASS_PATH_MAP = new HashMap();
    public final Map<String, Method> PATH_METHOD_MAP = new TreeMap<String, Method>();
    public final Map<Method, String[]> METHOD_PARAMNAME_MAP = new HashMap<Method, String[]>();
    public final Map<String, String> PATH_FORWARD_MAP = new HashMap<String, String>();
    public final Map<Method, Class<?>[]> METHOD_PARAMTYPE_MAP = new HashMap<Method, Class<?>[]>();
    public final Map<Method, Object> METHOD_BEAN_MAP = new HashMap<Method, Object>();
    public final Map<String, String> PATH_METHODSTR_MAP = new TreeMap<String, String>();
    public final Map<Integer, VariablePathVo[]> VARIABLE_PATH_MAP = new TreeMap<Integer, VariablePathVo[]>();
    public final Map<String, String> VARIABLEPATH_METHODSTR_MAP = new TreeMap<String, String>();
    private final StringBuilder errorStr = new StringBuilder();

    public Routes(String[] scanPackages) {
        this(scanPackages, null);
    }

    public Routes(String scanPackage) {
        this(scanPackage, null);
    }

    public Routes(String[] scanPackages, ControllerFactory controllerFactory) {
        this.addRoutes(scanPackages, controllerFactory);
    }

    public Routes(String scanPackage, ControllerFactory controllerFactory) {
        this(new String[]{scanPackage}, controllerFactory);
    }

    public Routes(Class<?>[] scanRootClasses) {
        this(Routes.toPackages(scanRootClasses), null);
    }

    public Routes(Class<?> scanRootClasse) {
        this(scanRootClasse.getPackage().getName(), null);
    }

    public Routes(Class<?>[] scanRootClasses, ControllerFactory controllerFactory) {
        this.addRoutes(Routes.toPackages(scanRootClasses), controllerFactory);
    }

    public Routes(Class<?> scanRootClasse, ControllerFactory controllerFactory) {
        this(new String[]{scanRootClasse.getPackage().getName()}, controllerFactory);
    }

    public static String[] toPackages(Class<?>[] scanRootClasses) {
        String[] scanPackages = new String[scanRootClasses.length];
        int i = 0;
        for (Class<?> clazz : scanRootClasses) {
            scanPackages[i++] = clazz.getPackage().getName();
        }
        return scanPackages;
    }

    public void addRoutes(String[] scanPackages) {
        this.addRoutes(scanPackages, null);
    }

    public void addRoutes(String[] scanPackages, ControllerFactory controllerFactory) {
        if (controllerFactory == null) {
            controllerFactory = DefaultControllerFactory.me;
        }
        final ControllerFactory controllerFactory1 = controllerFactory;
        if (scanPackages != null) {
            for (String pkg : scanPackages) {
                try {
                    ClassUtil.scanPackage((String)pkg, (ClassScanHandler)new ClassScanAnnotationHandler(RequestPath.class){

                        public void handlerAnnotation(Class<?> clazz) {
                            try {
                                Method[] methods;
                                Object bean = controllerFactory1.getInstance(clazz);
                                RequestPath classMapping = clazz.getAnnotation(RequestPath.class);
                                String beanPath = classMapping.value();
                                Object obj = Routes.this.PATH_BEAN_MAP.get(beanPath);
                                if (obj != null) {
                                    log.error("mapping[{}] already exists in class [{}]", (Object)beanPath, (Object)obj.getClass().getName());
                                    Routes.this.errorStr.append("mapping[" + beanPath + "] already exists in class [" + obj.getClass().getName() + "]\r\n\r\n");
                                } else {
                                    Routes.this.PATH_BEAN_MAP.put(beanPath, bean);
                                    CLASS_BEAN_MAP.put(clazz, bean);
                                    Routes.this.PATH_CLASS_MAP.put(beanPath, clazz);
                                    CLASS_PATH_MAP.put(clazz, beanPath);
                                    MethodAccess access = MethodAccess.get(clazz);
                                    BEAN_METHODACCESS_MAP.put(bean, access);
                                }
                                for (Method method : methods = clazz.getDeclaredMethods()) {
                                    RequestPath mapping;
                                    int modifiers = method.getModifiers();
                                    if (!Modifier.isPublic(modifiers) || (mapping = method.getAnnotation(RequestPath.class)) == null) continue;
                                    String methodPath = mapping.value();
                                    String completePath = beanPath + methodPath;
                                    Class<?>[] parameterTypes = method.getParameterTypes();
                                    try {
                                        BytecodeReadingParanamer paranamer = new BytecodeReadingParanamer();
                                        String[] parameterNames = paranamer.lookupParameterNames((AccessibleObject)method, false);
                                        Method checkMethod = Routes.this.PATH_METHOD_MAP.get(completePath);
                                        if (checkMethod != null) {
                                            log.error("mapping[{}] already exists in method [{}]", (Object)completePath, (Object)(checkMethod.getDeclaringClass() + "#" + checkMethod.getName()));
                                            Routes.this.errorStr.append("mapping[" + completePath + "] already exists in method [" + checkMethod.getDeclaringClass() + "#" + checkMethod.getName() + "]\r\n\r\n");
                                            continue;
                                        }
                                        Routes.this.PATH_METHOD_MAP.put(completePath, method);
                                        String methodStr = Routes.this.methodToStr(method, parameterNames);
                                        Routes.this.PATH_METHODSTR_MAP.put(completePath, methodStr);
                                        Routes.this.METHOD_PARAMNAME_MAP.put(method, parameterNames);
                                        Routes.this.METHOD_PARAMTYPE_MAP.put(method, parameterTypes);
                                        if (StrUtil.isNotBlank((CharSequence)mapping.forward())) {
                                            Routes.this.PATH_FORWARD_MAP.put(completePath, mapping.forward());
                                            Routes.this.PATH_METHODSTR_MAP.put(mapping.forward(), methodStr);
                                            Routes.this.PATH_METHOD_MAP.put(mapping.forward(), method);
                                        }
                                        Routes.this.METHOD_BEAN_MAP.put(method, bean);
                                    }
                                    catch (Throwable e) {
                                        log.error("", e);
                                    }
                                }
                            }
                            catch (Throwable e) {
                                log.error("", e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            String pathClassMapStr = Json.toFormatedJson(this.PATH_CLASS_MAP);
            log.info("class  mapping\r\n{}", (Object)pathClassMapStr);
            String pathMethodstrMapStr = Json.toFormatedJson(this.PATH_METHODSTR_MAP);
            log.info("method mapping\r\n{}", (Object)pathMethodstrMapStr);
            this.processVariablePath();
            String variablePathMethodstrMapStr = Json.toFormatedJson(this.VARIABLEPATH_METHODSTR_MAP);
            log.info("variable path mapping\r\n{}", (Object)variablePathMethodstrMapStr);
            String writeMappingToFile = System.getProperty("tio.mvc.route.writeMappingToFile", "true");
            if ("true".equalsIgnoreCase(writeMappingToFile)) {
                try {
                    FileUtil.writeString((String)pathClassMapStr, (String)"/tio_mvc_path_class.json", (String)"utf-8");
                    FileUtil.writeString((String)pathMethodstrMapStr, (String)"/tio_mvc_path_method.json", (String)"utf-8");
                    FileUtil.writeString((String)variablePathMethodstrMapStr, (String)"/tio_mvc_variablepath_method.json", (String)"utf-8");
                    if (this.errorStr.length() > 0) {
                        FileUtil.writeString((String)this.errorStr.toString(), (String)"/tio_error_mvc.txt", (String)"utf-8");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void processVariablePath() {
        Set<Map.Entry<String, Method>> set = this.PATH_METHOD_MAP.entrySet();
        for (Map.Entry<String, Method> entry : set) {
            String path = entry.getKey();
            Method method = entry.getValue();
            if (!StrUtil.contains((CharSequence)path, (char)'{') || !StrUtil.contains((CharSequence)path, (char)'}')) continue;
            String[] pathUnits = StrUtil.split((String)path, (String)"/");
            PathUnitVo[] pathUnitVos = new PathUnitVo[pathUnits.length];
            boolean isVarPath = false;
            for (int i = 0; i < pathUnits.length; ++i) {
                PathUnitVo pathUnitVo = new PathUnitVo();
                String pathUnit = pathUnits[i];
                if (StrUtil.contains((CharSequence)pathUnit, (char)'{') || StrUtil.contains((CharSequence)pathUnit, (char)'}')) {
                    if (StrUtil.startWith((CharSequence)pathUnit, (CharSequence)"{") && StrUtil.endWith((CharSequence)pathUnit, (CharSequence)"}")) {
                        String varName;
                        Object[] xx = this.METHOD_PARAMNAME_MAP.get(method);
                        if (ArrayUtil.contains((Object[])xx, (Object)(varName = StrUtil.subBetween((CharSequence)pathUnit, (CharSequence)"{", (CharSequence)"}")))) {
                            isVarPath = true;
                            pathUnitVo.setVar(true);
                            pathUnitVo.setPath(varName);
                        } else {
                            log.error("path:{}, \u5bf9\u5e94\u7684\u65b9\u6cd5\u4e2d\u5e76\u6ca1\u6709\u5305\u542b\u53c2\u6570\u540d\u4e3a{}\u7684\u53c2\u6570", (Object)path, (Object)varName);
                            this.errorStr.append("path:{" + path + "}, \u5bf9\u5e94\u7684\u65b9\u6cd5\u4e2d\u5e76\u6ca1\u6709\u5305\u542b\u53c2\u6570\u540d\u4e3a" + varName + "\u7684\u53c2\u6570\r\n\r\n");
                        }
                    } else {
                        pathUnitVo.setVar(false);
                        pathUnitVo.setPath(pathUnit);
                    }
                } else {
                    pathUnitVo.setVar(false);
                    pathUnitVo.setPath(pathUnit);
                }
                pathUnitVos[i] = pathUnitVo;
            }
            if (!isVarPath) continue;
            VariablePathVo variablePathVo = new VariablePathVo(path, method, pathUnitVos);
            this.addVariablePathVo(pathUnits.length, variablePathVo);
        }
    }

    private VariablePathVo[] getVariablePathVos(Integer pathUnitCount, boolean forceCreate) {
        VariablePathVo[] ret = this.VARIABLE_PATH_MAP.get(pathUnitCount);
        if (forceCreate && ret == null) {
            ret = new VariablePathVo[]{};
            this.VARIABLE_PATH_MAP.put(pathUnitCount, ret);
        }
        return ret;
    }

    public static <T> T getController(Class<T> clazz) {
        return (T)CLASS_BEAN_MAP.get(clazz);
    }

    public static String getRequestPath(Class<?> clazz) {
        return CLASS_PATH_MAP.get(clazz);
    }

    private void addVariablePathVo(Integer pathUnitCount, VariablePathVo variablePathVo) {
        VariablePathVo[] existValue = this.VARIABLE_PATH_MAP.get(pathUnitCount);
        if (existValue == null) {
            existValue = new VariablePathVo[]{variablePathVo};
            this.VARIABLE_PATH_MAP.put(pathUnitCount, existValue);
        } else {
            VariablePathVo[] newExistValue = new VariablePathVo[existValue.length + 1];
            System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
            newExistValue[newExistValue.length - 1] = variablePathVo;
            this.VARIABLE_PATH_MAP.put(pathUnitCount, newExistValue);
        }
        this.VARIABLEPATH_METHODSTR_MAP.put(variablePathVo.getPath(), this.methodToStr(variablePathVo.getMethod(), this.METHOD_PARAMNAME_MAP.get(variablePathVo.getMethod())));
    }

    private String methodToStr(Method method, String[] parameterNames) {
        return method.getDeclaringClass().getName() + "." + method.getName() + "(" + ArrayUtil.join((String[])parameterNames, (String)",") + ")";
    }

    public Method getMethodByPath(String path, HttpRequest request) {
        Method method = this.PATH_METHOD_MAP.get(path);
        if (method == null) {
            String[] pathUnitsOfRequest = StrUtil.split((String)path, (String)"/");
            VariablePathVo[] variablePathVos = this.VARIABLE_PATH_MAP.get(pathUnitsOfRequest.length);
            if (variablePathVos != null) {
                block0: for (VariablePathVo variablePathVo : variablePathVos) {
                    PathUnitVo[] pathUnitVos = variablePathVo.getPathUnits();
                    for (int i = 0; i < pathUnitVos.length; ++i) {
                        PathUnitVo pathUnitVo = pathUnitVos[i];
                        String pathUnitOfRequest = pathUnitsOfRequest[i];
                        if (pathUnitVo.isVar()) {
                            request.addParam(pathUnitVo.getPath(), (Object)pathUnitOfRequest);
                            continue;
                        }
                        if (!StrUtil.equals((CharSequence)pathUnitVo.getPath(), (CharSequence)pathUnitOfRequest)) continue block0;
                    }
                    String metapath = variablePathVo.getPath();
                    String forward = this.PATH_FORWARD_MAP.get(metapath);
                    if (StrUtil.isNotBlank((CharSequence)forward)) {
                        request.requestLine.path = forward;
                    }
                    method = variablePathVo.getMethod();
                    return method;
                }
            }
            return null;
        }
        return method;
    }
}

