/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.auth;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.ConfigUtils;
import org.tio.utils.json.Json;

public class AccessCtrlConfig
extends PropertiesConfiguration {
    private static Logger log = LoggerFactory.getLogger(AccessCtrlConfig.class);
    private Set<String> allRequestMapping = null;
    private boolean skipRepeat = false;
    private String configFile = "";

    public AccessCtrlConfig(String configFile, Set<String> allRequestMapping, boolean skipRepeat) {
        this.skipRepeat = skipRepeat;
        this.allRequestMapping = allRequestMapping == null ? new HashSet<String>() : new HashSet<String>(allRequestMapping);
        this.configFile = configFile;
        try {
            ConfigUtils.initConfig((String)configFile, (String)"utf-8", (PropertiesConfiguration)this);
        }
        catch (FileNotFoundException e) {
            log.error(e.toString(), (Throwable)e);
        }
        Iterator keys = this.getKeys();
        this.step1(keys);
        keys = this.getKeys();
        Map<String, Object> map = this.step2(keys);
        this.step3(map);
    }

    public Object getNeededRolecodes(String path) {
        Object neededRolecodes = this.getProperty(path);
        return neededRolecodes;
    }

    private void step1(Iterator<String> keys) {
        PropertiesConfiguration tem = new PropertiesConfiguration();
        while (keys.hasNext()) {
            String configedServletPath = keys.next();
            Object rolecodes = this.getProperty(configedServletPath);
            if (!configedServletPath.startsWith("/")) {
                configedServletPath = "/" + configedServletPath;
            }
            tem.addProperty(configedServletPath, rolecodes);
            if (StrUtil.containsAny((CharSequence)configedServletPath, (CharSequence[])new CharSequence[]{"*"}) || this.allRequestMapping.contains(configedServletPath)) continue;
            System.out.println(this.configFile + "\u6ca1\u6709\u63d0\u4f9b\uff1a" + configedServletPath);
            this.allRequestMapping.add(configedServletPath);
        }
        this.clear();
        this.append((Configuration)tem);
    }

    private Map<String, Object> step2(Iterator<String> configServletPaths) {
        HashMap<String, Object> asteriskServletPath = new HashMap<String, Object>();
        HashMap notAsteriskServletPath = new HashMap();
        HashSet<String> noMatchServletPath = new HashSet<String>();
        HashMap<String, Object> tem1 = null;
        while (configServletPaths.hasNext()) {
            String configedServletPath;
            String initConfigedServletPath = configedServletPath = configServletPaths.next();
            Object rolecodes = this.getProperty(configedServletPath);
            if (configedServletPath.contains("*")) {
                tem1 = asteriskServletPath;
                configedServletPath = configedServletPath.replaceAll("\\*", ".*");
            } else {
                tem1 = notAsteriskServletPath;
            }
            boolean ismatched = false;
            for (String requestMapping : this.allRequestMapping) {
                Pattern p = Pattern.compile(configedServletPath);
                Matcher m = p.matcher(requestMapping);
                boolean b = m.matches();
                if (!b) continue;
                ismatched = true;
                if (rolecodes instanceof List) {
                    List rolecodeList = (List)rolecodes;
                    for (String rolecode : rolecodeList) {
                        this.addRoleToRequestmapping(requestMapping, rolecode, tem1);
                    }
                    continue;
                }
                this.addRoleToRequestmapping(requestMapping, (String)rolecodes, tem1);
            }
            if (ismatched) continue;
            noMatchServletPath.add(initConfigedServletPath);
        }
        if (noMatchServletPath.size() > 0) {
            log.error("\u6709{}\u4e2a\u914d\u7f6e\u9879\u6ca1\u6709\u627e\u5230\u6620\u5c04\u8def\u5f84\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u6709\u8bef:{}", (Object)noMatchServletPath.size(), (Object)Json.toJson(noMatchServletPath));
        }
        asteriskServletPath.putAll(notAsteriskServletPath);
        this.clear();
        Set set = asteriskServletPath.entrySet();
        for (Map.Entry entry : set) {
            this.addProperty((String)entry.getKey(), entry.getValue());
        }
        return asteriskServletPath;
    }

    private void step3(Map<String, Object> map) {
        try {
            String writeMappingToFile = System.getProperty("tio.mvc.route.writeMappingToFile", "true");
            if ("true".equalsIgnoreCase(writeMappingToFile)) {
                FileUtil.writeString((String)Json.toFormatedJson(map), (File)new File("/" + FileUtil.mainName((String)this.configFile) + ".js"), (String)"utf-8");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addRoleToRequestmapping(String requestMapping, String rolecode, Map<String, Object> map) {
        Object _rcs = map.get(requestMapping);
        if (_rcs == null) {
            map.put(requestMapping, rolecode);
        } else {
            if (!this.skipRepeat) {
                log.error("\u914d\u7f6e\u9879\u91cd\u590d{}", (Object)requestMapping);
            }
            if (_rcs instanceof List) {
                List rclist = (List)_rcs;
                if (!rclist.contains(rolecode)) {
                    rclist.add(rolecode);
                    map.put(requestMapping, rclist);
                }
            } else if (!_rcs.equals(rolecode)) {
                ArrayList<String> rclist = new ArrayList<String>();
                rclist.add(rolecode);
                rclist.add((String)_rcs);
                map.put(requestMapping, rclist);
            }
        }
    }
}

