/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.kit.Ret;
import org.tio.mg.service.model.mg.MgAuth;
import org.tio.mg.service.model.mg.MgUser;
import org.tio.mg.service.service.mg.MgAuthService;
import org.tio.mg.service.utils.RetUtils;
import org.tio.mg.web.server.utils.WebUtils;
import org.tio.utils.resp.Resp;

@RequestPath(value="/mgauth")
public class MgAuthController {
    private static Logger log = LoggerFactory.getLogger(MgAuthController.class);
    private MgAuthService authService = MgAuthService.ME;

    public static void main(String[] args) {
    }

    @RequestPath(value="/authlist")
    public Resp authlist(HttpRequest request, String name, Byte type, Byte status) throws Exception {
        Ret ret = this.authService.authlist(name, status, type);
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u6743\u9650\u5217\u8868\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/menulist")
    public Resp menulist(HttpRequest request) throws Exception {
        Ret ret = this.authService.menulist();
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u83dc\u5355\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/add")
    public Resp add(HttpRequest request, MgAuth auth) throws Exception {
        Ret ret = this.authService.add(auth);
        if (ret.isFail()) {
            log.error("\u4fdd\u5b58\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/update")
    public Resp update(HttpRequest request, MgAuth auth) throws Exception {
        Ret ret = this.authService.update(auth);
        if (ret.isFail()) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/del")
    public Resp del(HttpRequest request, Integer aid) throws Exception {
        Ret ret = this.authService.del(aid);
        if (ret.isFail()) {
            log.error("\u5220\u9664\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/pageAuthList")
    public Resp pageAuthList(HttpRequest request, String path) throws Exception {
        MgUser user = WebUtils.currUser(request);
        Ret ret = this.authService.pageoperlist(user.getId(), path);
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret)).code(RetUtils.getIntCode((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/index")
    public Resp index(HttpRequest request, Integer aid, Integer toaid, Byte topflag) throws Exception {
        Ret ret = this.authService.index(aid, toaid, topflag);
        if (ret.isFail()) {
            log.error("\u8c03\u6574\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/disable")
    public Resp disable(HttpRequest request, Integer aid, Byte status) throws Exception {
        Ret ret = this.authService.disable(aid, status);
        if (ret.isFail()) {
            log.error("\u7981\u7528\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/operlist")
    public Resp operlist(HttpRequest request, Integer aid) throws Exception {
        Ret ret = this.authService.pageoperlist(aid);
        if (ret.isFail()) {
            log.error("\u7981\u7528\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkList((Ret)ret));
    }

    @RequestPath(value="/operadd")
    public Resp operadd(HttpRequest request, MgAuth auth) throws Exception {
        Ret ret = this.authService.operadd(auth);
        if (ret.isFail()) {
            log.error("\u4fdd\u5b58\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/operupdate")
    public Resp operupdate(HttpRequest request, MgAuth auth) throws Exception {
        Ret ret = this.authService.operupdate(auth);
        if (ret.isFail()) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/operdel")
    public Resp operdel(HttpRequest request, Integer aid) throws Exception {
        Ret ret = this.authService.operdel(aid);
        if (ret.isFail()) {
            log.error("\u5220\u9664\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/operdisable")
    public Resp operdisable(HttpRequest request, Integer aid, Byte status) throws Exception {
        Ret ret = this.authService.operdisable(aid, status);
        if (ret.isFail()) {
            log.error("\u7981\u7528\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }
}

