/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller;

import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.kit.Ret;
import org.tio.mg.service.init.RedisInit;
import org.tio.mg.service.model.conf.Conf;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.topic.TopicVo;
import org.tio.utils.resp.Resp;

@RequestPath(value="/mgconf")
public class MgConfController {
    private static Logger log = LoggerFactory.getLogger(MgConfController.class);
    private MgConfService confService = MgConfService.me;

    public static void main(String[] args) {
    }

    @RequestPath(value="/list")
    public Resp list(HttpRequest request, String searchkey, Byte type) throws Exception {
        Ret ret = this.confService.list(searchkey, type);
        if (ret.isFail()) {
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkList((Ret)ret));
    }

    @RequestPath(value="/add")
    public Resp add(HttpRequest request, Conf conf) throws Exception {
        Ret ret = this.confService.add(conf);
        if (ret.isFail()) {
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        RedissonClient redisson = RedisInit.get();
        RTopic topic = redisson.getTopic("COMMON_TOPIC");
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)3));
        topic.publish((Object)topicVo);
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/update")
    public Resp update(HttpRequest request, Conf conf) throws Exception {
        Ret ret = this.confService.update(conf);
        if (ret.isFail()) {
            log.error(RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        RedissonClient redisson = RedisInit.get();
        RTopic topic = redisson.getTopic("COMMON_TOPIC");
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)3));
        topic.publish((Object)topicVo);
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }
}

