/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller;

import cn.hutool.core.util.StrUtil;
import java.util.List;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.kit.Ret;
import org.tio.mg.service.init.RedisInit;
import org.tio.mg.service.model.conf.Dict;
import org.tio.mg.service.service.conf.MgDictService;
import org.tio.mg.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.topic.TopicVo;
import org.tio.utils.resp.Resp;

@RequestPath(value="/mgdict")
public class MgDictController {
    private static Logger log = LoggerFactory.getLogger(MgDictController.class);
    private MgDictService dictService = MgDictService.me;

    public static void main(String[] args) {
    }

    @RequestPath(value="/topList")
    public Resp topList(HttpRequest request, String name) throws Exception {
        List topList = this.dictService.topList(name);
        return Resp.ok((Object)topList);
    }

    @RequestPath(value="/childList")
    public Resp childList(HttpRequest request, String pcode, String name, Byte status) throws Exception {
        if (StrUtil.isBlank((CharSequence)pcode)) {
            log.error("\u83b7\u53d6\u5b50\u8282\u70b9\u6570\u636e\uff1a\u53c2\u6570\u4e3a\u7a7a");
            return Resp.fail((String)"\u65e0\u6548\u53c2\u6570");
        }
        List childList = MgDictService.getChildDictByParentCode((String)pcode, (String)name, (Byte)status);
        return Resp.ok((Object)childList);
    }

    @RequestPath(value="/childdict")
    public Resp childDict(HttpRequest request, String pcode) throws Exception {
        if (StrUtil.isBlank((CharSequence)pcode)) {
            log.error("\u83b7\u53d6\u5b50\u8282\u70b9\u6570\u636e\uff1a\u53c2\u6570\u4e3a\u7a7a");
            return Resp.fail((String)"\u65e0\u6548\u53c2\u6570");
        }
        List childList = MgDictService.getChildDictByParentCode((String)pcode);
        return Resp.ok((Object)childList);
    }

    @RequestPath(value="/index")
    public Resp index(HttpRequest request, Integer did, Integer topdid) throws Exception {
        Ret ret = MgDictService.index((Integer)did, (Integer)topdid);
        if (ret.isFail()) {
            log.error("\u8c03\u6574\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        RedissonClient redisson = RedisInit.get();
        RTopic topic = redisson.getTopic("COMMON_TOPIC");
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)1));
        topic.publish((Object)topicVo);
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/add")
    public Resp add(HttpRequest request, Dict dict) throws Exception {
        Ret ret = this.dictService.add(dict);
        if (ret.isFail()) {
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        RedissonClient redisson = RedisInit.get();
        RTopic topic = redisson.getTopic("COMMON_TOPIC");
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)1));
        topic.publish((Object)topicVo);
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/insert")
    public Resp insert(HttpRequest request, Dict dict) throws Exception {
        Ret ret = this.dictService.insert(dict);
        if (ret.isFail()) {
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        RedissonClient redisson = RedisInit.get();
        RTopic topic = redisson.getTopic("COMMON_TOPIC");
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)1));
        topic.publish((Object)topicVo);
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/update")
    public Resp update(HttpRequest request, Dict dict) throws Exception {
        Ret ret = this.dictService.update(dict);
        if (ret.isFail()) {
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        RedissonClient redisson = RedisInit.get();
        RTopic topic = redisson.getTopic("COMMON_TOPIC");
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)1));
        topic.publish((Object)topicVo);
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/del")
    public Resp del(HttpRequest request, Integer id) throws Exception {
        Ret ret = this.dictService.del(id);
        if (ret.isFail()) {
            log.error("\u5220\u9664\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        RedissonClient redisson = RedisInit.get();
        RTopic topic = redisson.getTopic("COMMON_TOPIC");
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)1));
        topic.publish((Object)topicVo);
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/disable")
    public Resp disable(HttpRequest request, Integer id, Byte status) throws Exception {
        Ret ret = this.dictService.disable(id, status);
        if (ret.isFail()) {
            log.error("\u7981\u7528/\u5f00\u542f\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        RedissonClient redisson = RedisInit.get();
        RTopic topic = redisson.getTopic("COMMON_TOPIC");
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)1));
        topic.publish((Object)topicVo);
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }
}

