/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.kit.Ret;
import org.tio.mg.service.model.mg.MgUser;
import org.tio.mg.service.service.mg.MgUserService;
import org.tio.mg.service.utils.RetUtils;
import org.tio.mg.web.server.utils.WebUtils;
import org.tio.utils.resp.Resp;

@RequestPath(value="/mguser")
public class MgUserController {
    private static Logger log = LoggerFactory.getLogger(MgUserController.class);
    private MgUserService userService = MgUserService.ME;

    public static void main(String[] args) {
    }

    @RequestPath(value="/curr")
    public Resp curr(HttpRequest request) throws Exception {
        MgUser user = WebUtils.currUser(request);
        if (user != null) {
            Resp resp = Resp.ok((Object)user);
            return resp;
        }
        Resp resp = Resp.fail();
        return resp;
    }

    @RequestPath(value="/menu")
    public Resp menu(HttpRequest request) throws Exception {
        MgUser user = WebUtils.currUser(request);
        Ret ret = this.userService.getMenu(user.getId());
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u83dc\u5355\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/list")
    public Resp list(HttpRequest request, String searchkey, Integer rid, Byte status, Integer pageNumber, Integer pageSize) throws Exception {
        Ret ret = this.userService.userList(searchkey, rid, status, pageNumber, pageSize);
        if (ret.isFail()) {
            log.error("\u83b7\u53d6\u7528\u6237\u5217\u8868\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkPage((Ret)ret));
    }

    @RequestPath(value="/resetPwd")
    public Resp resetPwd(HttpRequest request, Integer mguid) throws Exception {
        Ret ret = this.userService.resetPwd(mguid);
        if (ret.isFail()) {
            log.error("\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/updatePwd")
    public Resp resetPwd(HttpRequest request, String pwd, String newpwd) throws Exception {
        MgUser user = WebUtils.currUser(request);
        Ret ret = this.userService.updatePwd(user.getId(), pwd, newpwd);
        if (ret.isFail()) {
            log.error("\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/add")
    public Resp add(HttpRequest request, MgUser user) throws Exception {
        Ret ret = this.userService.add(user);
        if (ret.isFail()) {
            log.error("\u65b0\u589e\u7528\u6237\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/update")
    public Resp update(HttpRequest request, MgUser user) throws Exception {
        Ret ret = this.userService.update(user);
        if (ret.isFail()) {
            log.error("\u65b0\u589e\u7528\u6237\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/del")
    public Resp del(HttpRequest request, Integer mguid) throws Exception {
        Ret ret = this.userService.del(mguid);
        if (ret.isFail()) {
            log.error("\u65b0\u589e\u7528\u6237\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }
}

