/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller.base;

import cn.hutool.core.io.FileUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.UploadFile;
import org.tio.http.server.annotation.RequestPath;
import org.tio.mg.service.model.main.File;
import org.tio.mg.web.server.utils.UploadUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.resp.Resp;

@RequestPath(value="/common")
public class CommonController {
    private static Logger log = LoggerFactory.getLogger(CommonController.class);

    public static void main(String[] args) {
    }

    @RequestPath(value="/file")
    public Resp file(HttpRequest request, UploadFile uploadFile, Byte type) throws Exception {
        try {
            if (uploadFile == null) {
                return Resp.fail((String)"\u4e0a\u4f20\u4fe1\u606f\u4e3a\u7a7a");
            }
            File dbFile = CommonController.innerUploadFile(uploadFile, type);
            return Resp.ok((Object)dbFile);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            return Resp.fail((String)"\u7cfb\u7edf\u9519\u8bef");
        }
    }

    @RequestPath(value="/files")
    public Resp files(HttpRequest request, UploadFile[] uploadFile, Byte type) throws Exception {
        try {
            if (uploadFile == null || uploadFile.length <= 0) {
                return Resp.fail((String)"\u4e0a\u4f20\u4fe1\u606f\u4e3a\u7a7a");
            }
            ArrayList<File> dbFiles = new ArrayList<File>();
            for (UploadFile file : uploadFile) {
                File dbFile = CommonController.innerUploadFile(file, type);
                dbFiles.add(dbFile);
            }
            return Resp.ok(dbFiles);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            return Resp.fail((String)"\u7cfb\u7edf\u9519\u8bef");
        }
    }

    private static File innerUploadFile(UploadFile uploadFile, Byte type) throws Exception {
        byte[] bs = uploadFile.getData();
        String filename = uploadFile.getName();
        String ext = FileUtil.extName((String)filename);
        String urlWithoutExt = UploadUtils.newFile(UploadUtils.mgSubDir(type), -type.byteValue(), filename);
        String url = urlWithoutExt + "." + ext;
        java.io.File file = new java.io.File(Const.RES_ROOT, url);
        FileUtil.writeBytes((byte[])bs, (java.io.File)file);
        File dbFile = new File();
        dbFile.setExt(ext);
        dbFile.setFilename(uploadFile.getName());
        dbFile.setSize(Long.valueOf(bs.length));
        dbFile.setUid(Integer.valueOf(-type.byteValue()));
        dbFile.setUrl(url);
        dbFile.save();
        return dbFile;
    }
}

