/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller.base;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.PageSqlKit;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.mg.MgAuth;
import org.tio.mg.service.model.mg.MgRole;
import org.tio.mg.service.model.mg.MgRoleAuth;
import org.tio.mg.service.service.atom.AbsTxAtom;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.service.utils.OkHttpUtils;
import org.tio.mg.service.vo.SysnMenuVo;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.json.Json;
import org.tio.utils.resp.Resp;

@RequestPath(value="/sys")
public class SysController {
    private static Logger log = LoggerFactory.getLogger(SysController.class);

    public static void main(String[] args) {
    }

    @RequestPath(value="/params")
    public Resp operdisable(HttpRequest request) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("res.server", Const.RES_SERVER);
        param.put("site", Const.SITE);
        param.put("resetpwd", "888888");
        return Resp.ok(param);
    }

    @RequestPath(value="/query")
    public Resp query(HttpRequest request, String sql, String db, Integer pageNumber, Integer pageSize, Byte groupby) throws Exception {
        if (StrUtil.isBlank((CharSequence)sql) || sql.trim().toLowerCase().indexOf("select") != 0) {
            return Resp.fail((String)"\u65e0\u6548\u67e5\u8be2");
        }
        sql = sql.trim().replaceAll(";", "");
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 100;
        }
        if (StrUtil.isBlank((CharSequence)db)) {
            db = "tio_site_main";
        }
        String[] sqls = PageSqlKit.parsePageSql((String)sql);
        Page rePage = null;
        Boolean isGroupBySql = false;
        if (groupby != null && Objects.equals(groupby, (byte)1)) {
            isGroupBySql = true;
        }
        HashMap ret = new HashMap();
        try {
            rePage = Db.use((String)db).paginate(pageNumber.intValue(), pageSize.intValue(), isGroupBySql.booleanValue(), sqls[0], sqls[1], new Object[0]);
            if (rePage != null && CollectionUtil.isNotEmpty((Collection)rePage.getList())) {
                ArrayList<String> couList = new ArrayList<String>();
                Map rsMap = ((Record)rePage.getList().get(0)).getColumns();
                for (String columns : rsMap.keySet()) {
                    couList.add(columns);
                }
                Collections.sort(couList);
                ret.put("columns", couList);
            }
            ret.put("page", rePage);
        }
        catch (Exception e) {
            return Resp.fail((String)"\u67e5\u8be2\u5931\u8d25");
        }
        return Resp.ok(ret);
    }

    @RequestPath(value="/synmenu")
    public Resp synmenu(HttpRequest request) throws Exception {
        List mgAuths = MgAuth.dao.find("select * from mg_auth order by id");
        return Resp.ok((Object)mgAuths);
    }

    @RequestPath(value="/initmenu")
    public Resp initmenu(HttpRequest request, final Integer rid) throws Exception {
        if (rid == null) {
            return Resp.fail((String)"\u89d2\u8272id\u4e3a\u7a7a");
        }
        MgRole role = (MgRole)MgRole.dao.findById((Object)rid);
        if (role == null) {
            return Resp.fail((String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        String site = MgConfService.getString((String)"mg.menu.sysn.site", (String)"http://129.211.52.247:9292");
        Response resp = OkHttpUtils.get((String)(site + Const.API_CONTEXTPATH + "/sys/synmenu" + Const.API_SUFFIX));
        if (resp == null) {
            return Resp.fail((String)"\u540c\u6b65\u5931\u8d25,\u83b7\u53d6\u54cd\u5e94\u4e3a\u7a7a");
        }
        if (resp.isSuccessful()) {
            if (resp.code() != 200) {
                return Resp.fail((String)("\u540c\u6b65\u5931\u8d25,\u72b6\u6001\u7801\uff1a" + resp.code()));
            }
            String body = resp.body().string();
            final SysnMenuVo sysnMenuVo = (SysnMenuVo)Json.toBean((String)body, SysnMenuVo.class);
            if (sysnMenuVo.isOk()) {
                Db.use((String)"tio_mg").update("create table mg_auth_temp select * from mg_auth");
                Db.use((String)"tio_mg").update("truncate table mg_auth");
                Db.use((String)"tio_mg").update("create table mg_role_auth_temp select * from mg_role_auth");
                Db.use((String)"tio_mg").update("truncate table mg_role_auth");
                AbsTxAtom atom = new AbsTxAtom(){

                    public boolean noTxRun() {
                        ArrayList mgAuths = sysnMenuVo.getData();
                        boolean init = true;
                        if (CollectionUtil.isNotEmpty((Collection)mgAuths)) {
                            for (MgAuth mgAuth : mgAuths) {
                                boolean save = mgAuth.save();
                                if (!save) {
                                    init = false;
                                    break;
                                }
                                MgRoleAuth roleAuth = new MgRoleAuth();
                                roleAuth.setRid(rid);
                                roleAuth.setAid(mgAuth.getId());
                                boolean rsave = roleAuth.save();
                                if (rsave) continue;
                                init = false;
                                break;
                            }
                        }
                        return init;
                    }
                };
                boolean tx = Db.use((String)"tio_mg").tx((IAtom)atom);
                if (!tx) {
                    Db.use((String)"tio_mg").update("truncate table mg_auth");
                    Db.use((String)"tio_mg").update("truncate table mg_role_auth");
                    Db.use((String)"tio_mg").update("insert into mg_auth select * from mg_auth_temp");
                    Db.use((String)"tio_mg").update("insert into mg_role_auth select * from mg_role_auth_temp");
                }
                Db.use((String)"tio_mg").update("drop table mg_auth_temp");
                Db.use((String)"tio_mg").update("drop table mg_role_auth_temp");
                Caches.getCache((CacheConfig)CacheConfig.MG_USER_MENU_AUTH).clear();
                if (!tx) {
                    return Resp.ok((Object)"\u540c\u6b65\u5931\u8d25,\u6570\u636e\u5df2\u56de\u6eda");
                }
            }
            return Resp.ok((Object)sysnMenuVo);
        }
        return Resp.fail((String)"\u540c\u6b65\u5931\u8d25,\u54cd\u5e94\u5931\u8d25");
    }
}

