/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller.base.thirdlogin.provider.douyin;

import java.text.MessageFormat;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.mg.service.model.main.UserThird;
import org.tio.mg.web.server.controller.base.thirdlogin.ThirdLoginUtils;
import org.tio.mg.web.server.controller.base.thirdlogin.auth2.AccessTokenResp;
import org.tio.mg.web.server.controller.base.thirdlogin.provider.Auth2Login;
import org.tio.mg.web.server.controller.base.thirdlogin.provider.douyin.DouyinUserinfoWrap;
import org.tio.mg.web.server.init.WebApiInit;
import org.tio.utils.http.HttpUtils;
import org.tio.utils.jfinal.P;
import org.tio.utils.json.Json;

public class DouyinLogin
extends Auth2Login {
    private static Logger log = LoggerFactory.getLogger(DouyinLogin.class);
    public static final String AppID = P.get((String)"third.login.douyin.pc.AppID");
    public static final String AppSecret = P.get((String)"third.login.douyin.pc.AppSecret");
    public static final String OAUTH_CONNECT_URL = "https://open.douyin.com/platform/oauth/connect?client_key=" + AppID + "&response_type=code&scope=user_info&state={0}&redirect_uri={1}";
    public static final String OAUTH_ACCESSTOKEN_URL = "https://open.douyin.com/oauth/access_token/?client_key=" + AppID + "&client_secret=" + AppSecret + "&code={0}&grant_type=authorization_code";
    public static final String OAUTH_USERINFO_URL = "https://open.douyin.com/oauth/userinfo/?access_token={0}&open_id={1}";
    public static DouyinLogin me = new DouyinLogin();

    private DouyinLogin() {
    }

    @Override
    public String loginUrl(HttpRequest request, Integer type, String state) throws Exception {
        String redirect_uri = ThirdLoginUtils.getCallbackUrl(WebApiInit.httpConfig, type);
        String url = MessageFormat.format(OAUTH_CONNECT_URL, state, redirect_uri);
        return url;
    }

    @Override
    public UserThird getUserThird(HttpRequest request, Integer type, String state, String code) throws Exception {
        String url = MessageFormat.format(OAUTH_ACCESSTOKEN_URL, code);
        Response response = HttpUtils.get((String)url);
        String respStr = response.body().string();
        AccessTokenResp accessTokenResp = (AccessTokenResp)Json.toBean((String)respStr, AccessTokenResp.class);
        if ("success".equals(accessTokenResp.getMessage())) {
            AccessTokenResp.Data data = accessTokenResp.getData();
            String url2 = MessageFormat.format(OAUTH_USERINFO_URL, data.getAccess_token(), data.getOpen_id());
            Response response2 = HttpUtils.get((String)url2);
            String respStr2 = response2.body().string();
            DouyinUserinfoWrap douyinUserinfoWrap = (DouyinUserinfoWrap)Json.toBean((String)respStr2, DouyinUserinfoWrap.class);
            if ("success".equals(douyinUserinfoWrap.getMessage())) {
                DouyinUserinfoWrap.DouyinUserinfo douyinUserinfo = douyinUserinfoWrap.getData();
                if (0 == douyinUserinfo.getError_code()) {
                    UserThird userThird = new UserThird();
                    userThird.setOpenid(douyinUserinfo.getOpen_id());
                    userThird.setAvatar(douyinUserinfo.getAvatar());
                    userThird.setNick(douyinUserinfo.getNickname());
                    userThird.setUnionid(douyinUserinfo.getUnion_id());
                    return userThird;
                }
                log.error("\u6296\u97f3\u767b\u5f55\u5931\u8d25\uff0c\u83b7\u53d6userinfo\u54cd\u5e94:{}", (Object)respStr2);
                return null;
            }
            log.error("\u6296\u97f3\u767b\u5f55\u5931\u8d25\uff0c\u83b7\u53d6userinfo\u54cd\u5e94:{}", (Object)respStr2);
            return null;
        }
        return null;
    }
}

