/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.controller.tioim;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.jfinal.kit.Ret;
import org.tio.mg.service.model.conf.EmailServer;
import org.tio.mg.service.service.tioim.TioEmailService;
import org.tio.mg.service.utils.RetUtils;
import org.tio.utils.resp.Resp;

@RequestPath(value="/email")
public class TioEmailController {
    private static Logger log = LoggerFactory.getLogger(TioEmailController.class);
    private TioEmailService emailService = TioEmailService.me;

    public static void main(String[] args) {
    }

    @RequestPath(value="/submit")
    public Resp submit(HttpRequest request, Integer startid, Integer endid, String content, String title) throws Exception {
        Ret ret = this.emailService.sendEmail(startid, endid, title, content);
        if (ret.isFail()) {
            log.error("\u53d1\u9001\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/list")
    public Resp list(HttpRequest request, String searchkey) throws Exception {
        List emailServers = this.emailService.getAll(searchkey);
        return Resp.ok((Object)emailServers);
    }

    @RequestPath(value="/add")
    public Resp add(HttpRequest request, EmailServer email) throws Exception {
        Ret ret = this.emailService.add(email);
        if (ret.isFail()) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/update")
    public Resp update(HttpRequest request, EmailServer email) throws Exception {
        Ret ret = this.emailService.update(email);
        if (ret.isFail()) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }

    @RequestPath(value="/del")
    public Resp del(HttpRequest request, String email) throws Exception {
        Ret ret = this.emailService.del(email);
        if (ret.isFail()) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)RetUtils.getRetMsg((Ret)ret));
            return Resp.fail((String)RetUtils.getRetMsg((Ret)ret));
        }
        return Resp.ok((Object)RetUtils.getOkData((Ret)ret));
    }
}

