/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.http;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.Cookie;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.MimeType;
import org.tio.http.common.RequestLine;
import org.tio.http.common.session.HttpSession;
import org.tio.http.common.utils.HttpGzipUtils;
import org.tio.http.server.intf.HttpServerInterceptor;
import org.tio.http.server.util.Resps;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.conf.Httpcache;
import org.tio.mg.service.model.main.IpInfo;
import org.tio.mg.service.model.main.RechargeItem;
import org.tio.mg.service.model.main.UserAgent;
import org.tio.mg.service.model.mg.MgAuth;
import org.tio.mg.service.model.mg.MgOperLog;
import org.tio.mg.service.model.mg.MgUser;
import org.tio.mg.service.model.stat.ImeiStat;
import org.tio.mg.service.model.stat.TioSlowRequest;
import org.tio.mg.service.service.base.ImeiStatService;
import org.tio.mg.service.service.base.IpInfoService;
import org.tio.mg.service.service.base.UserAgentService;
import org.tio.mg.service.service.conf.HttpcacheService;
import org.tio.mg.service.service.conf.IpWhiteListService;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.service.service.mg.MgAuthService;
import org.tio.mg.service.service.mg.MgUserService;
import org.tio.mg.service.vo.MgAuthVo;
import org.tio.mg.service.vo.MgUserAuthInfoVo;
import org.tio.mg.service.vo.RequestExt;
import org.tio.mg.service.vo.SessionExt;
import org.tio.mg.web.server.auth.AccessCtrlConfig;
import org.tio.mg.web.server.utils.TioIpPullblackUtils;
import org.tio.mg.web.server.utils.WebUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.utils.SystemTimer;
import org.tio.utils.cache.ICache;
import org.tio.utils.jfinal.P;
import org.tio.utils.json.Json;
import org.tio.utils.lock.LockUtils;
import org.tio.utils.resp.Resp;

public class WebApiHttpServerInterceptor
implements HttpServerInterceptor {
    private static Logger log = LoggerFactory.getLogger(WebApiHttpServerInterceptor.class);
    public static final WebApiHttpServerInterceptor ME = new WebApiHttpServerInterceptor();
    private final String httpCacheLockKey = this.getClass().getName() + ".httpCacheLockKey";
    public static final String HEADER_NAME_MOBILE_DEVICEINFO = "tio-deviceinfo";
    public static final String HEADER_NAME_TIO_APPVERSION = "tio-appversion";
    public static final String HEADER_NAME_TIO_CID = "tio-cid";
    public static final String HEADER_NAME_TIO_RESOLUTION = "tio-resolution";
    public static final String HEADER_NAME_TIO_IMEI = "tio-imei";
    public static final String HEADER_NAME_TIO_OPERATOR = "tio-operator";
    public static final String HEADER_NAME_TIO_SIZE = "tio-size";
    public static final String HEADER_NAME_TIO_IDFA = "tio-idfa";
    private static final HeaderName HTTPCACHE_FLAG_HEADER_NAME = HeaderName.from((String)"tio-httpcache-old");
    private static final HeaderName HTTPCACHE_FIRST_HEADER_NAME = HeaderName.from((String)"tio-httpcache-new");
    private static final HeaderName HEADER_NAME_WEBAPI_SERVER = HeaderName.from((String)"tio-webapi-server");
    private static final HeaderValue HEADER_VALUE_WHICH_API = HeaderValue.from((String)Const.MY_IP);
    private static final String PARAM_NAME_IS_FROM_ANDROID = "p_is_android";
    private static final String PARAM_NAME_IS_FROM_IOS = "p_is_ios";
    private static final Object lockForGetLock = new Object();
    private AccessCtrlConfig accessCtrlConfig;
    private static byte[] BODY_BYTES_NEED_ACCESS_TOKEN = null;
    private static Set<String> skipCheckAccessTokenPathSet = new HashSet<String>();
    private static Set<String> neededCheckAccessTokenPathSet = new HashSet<String>();
    private static Set<String> operPathSet = new HashSet<String>();
    private static String[] skipCheckAccessTokenPathprefix = new String[]{"/open/lastVersion1", "/open/lastVersion2", "/recharge/nf/", "/recharge/rt/", "/recharge/qrSubmit/", "/tlogin/cb/p/", "/upload/video", "/upload/img", "/upload/all"};
    final String PAYTYPE_APPLE_APP = RechargeItem.Paytype.APPLE_APP + "";
    private static boolean useHttpcache;

    public static void main(String[] args) {
    }

    private WebApiHttpServerInterceptor() {
    }

    private static boolean needCheckAccessToken(HttpRequest request, String path) {
        if (neededCheckAccessTokenPathSet.contains(path)) {
            return true;
        }
        if (skipCheckAccessTokenPathSet.contains(path)) {
            return false;
        }
        for (String pathPrefix : skipCheckAccessTokenPathprefix) {
            if (!StrUtil.startWith((CharSequence)path, (CharSequence)pathPrefix)) continue;
            return false;
        }
        return true;
    }

    private static ImeiStat createImeiStat(HttpRequest request, RequestExt requestExt) {
        String ip = request.getClientIp();
        IpInfo ipInfo = IpInfoService.ME.save(ip);
        ImeiStat imeiStat = new ImeiStat();
        imeiStat.setAppversion(requestExt.getAppVersion());
        imeiStat.setCid(requestExt.getCid());
        imeiStat.setDeviceinfo(requestExt.getDeviceinfo());
        imeiStat.setImei(requestExt.getImei());
        imeiStat.setIp(ip);
        imeiStat.setIpid(ipInfo.getId());
        imeiStat.setResolution(requestExt.getResolution());
        imeiStat.setSize(requestExt.getSize());
        imeiStat.setTime(new Date());
        imeiStat.setType(Byte.valueOf(requestExt.getDeviceType()));
        imeiStat.setUrl(request.getRequestLine().getPath());
        imeiStat.setIdfa(requestExt.getIdfa());
        return imeiStat;
    }

    public HttpResponse doBeforeHandler(HttpRequest request, RequestLine requestLine, HttpResponse httpResponseFromCache) throws Exception {
        Resp resp;
        String pageSize;
        RequestExt requestExt = new RequestExt();
        request.setAttribute("TIO_SITE_REQUESTEXT", (Serializable)requestExt);
        requestExt.setCanCache(false);
        String path = requestLine.getPath();
        boolean isFromAndroid = "1".equals(request.getParam(PARAM_NAME_IS_FROM_ANDROID));
        boolean isFromIos = "1".equals(request.getParam(PARAM_NAME_IS_FROM_IOS));
        boolean isFromApp = isFromIos || isFromAndroid;
        boolean isFromPc = true;
        String clientTypeName = "Browser";
        if (isFromApp) {
            if (!isFromIos && !isFromAndroid) {
                isFromAndroid = true;
            }
            isFromPc = false;
            clientTypeName = isFromIos ? "IOS" : "Android";
        }
        int accessTokenOn = 2;
        if (isFromPc) {
            accessTokenOn = MgConfService.getInt((String)"use.access.token.pc", (Integer)2);
        } else if (isFromAndroid) {
            accessTokenOn = MgConfService.getInt((String)"use.access.token.android", (Integer)2);
        } else if (isFromIos) {
            accessTokenOn = MgConfService.getInt((String)"use.access.token.ios", (Integer)2);
        }
        if (isFromApp) {
            requestExt.setFromApp(true);
            requestExt.setFromBrowser(false);
            requestExt.setFromBrowserPc(false);
            requestExt.setFromBrowserMobile(false);
            if (isFromIos) {
                requestExt.setFromAppIos(true);
            } else {
                requestExt.setFromAppAndroid(true);
            }
            requestExt.setDeviceType(Devicetype.APP.getValue().byteValue());
        }
        IpInfo ipInfo = IpInfoService.ME.save(request.getClientIp());
        requestExt.setIpInfo(ipInfo);
        if (requestExt.isFromApp()) {
            String appVersion = request.getHeader(HEADER_NAME_TIO_APPVERSION);
            requestExt.setAppVersion(appVersion);
            if (StrUtil.isBlank((CharSequence)appVersion)) {
                log.warn("{} path:{}, \u6ca1\u6709\u63d0\u4f9bApp\u7248\u672c\u53f7\u3010{}\u3011", new Object[]{clientTypeName, path, HEADER_NAME_TIO_APPVERSION});
            }
            String cid = request.getHeader(HEADER_NAME_TIO_CID);
            requestExt.setCid(cid);
            if (StrUtil.isBlank((CharSequence)cid)) {
                log.warn("{} {}, path:{}, \u6ca1\u6709\u63d0\u4f9b\u6e20\u9053\u53f7\u3010{}\u3011", new Object[]{clientTypeName, appVersion, path, HEADER_NAME_TIO_CID});
            }
            String resolution = request.getHeader(HEADER_NAME_TIO_RESOLUTION);
            requestExt.setResolution(resolution);
            if (StrUtil.isBlank((CharSequence)resolution)) {
                log.warn("{} {}, path:{}, \u6ca1\u6709\u63d0\u4f9b\u5206\u8fa8\u7387\u3010{}\u3011", new Object[]{clientTypeName, appVersion, path, HEADER_NAME_TIO_RESOLUTION});
            }
            String imei = request.getHeader(HEADER_NAME_TIO_IMEI);
            requestExt.setImei(imei);
            if (StrUtil.isBlank((CharSequence)imei)) {
                log.warn("{} {}, path:{}, \u6ca1\u6709\u63d0\u4f9bIMEI\u3010{}\u3011", new Object[]{clientTypeName, appVersion, path, HEADER_NAME_TIO_IMEI});
            }
            String operator = request.getHeader(HEADER_NAME_TIO_OPERATOR);
            requestExt.setOperator(operator);
            if (StrUtil.isBlank((CharSequence)operator)) {
                log.warn("{} {}, path:{}, \u6ca1\u6709\u63d0\u4f9b\u8fd0\u8425\u5546\u3010{}\u3011", new Object[]{clientTypeName, appVersion, path, HEADER_NAME_TIO_OPERATOR});
            }
            String deviceinfo = request.getHeader(HEADER_NAME_MOBILE_DEVICEINFO);
            requestExt.setDeviceinfo(deviceinfo);
            if (StrUtil.isBlank((CharSequence)deviceinfo)) {
                log.warn("{} {}, path:{}, \u6ca1\u6709\u63d0\u4f9b\u624b\u673a\u4fe1\u606f\u3010{}\u3011", new Object[]{clientTypeName, appVersion, path, HEADER_NAME_MOBILE_DEVICEINFO});
            }
            String size = request.getHeader(HEADER_NAME_TIO_SIZE);
            requestExt.setSize(size);
            if (StrUtil.isBlank((CharSequence)size)) {
                log.warn("{} {}, path:{}, \u6ca1\u6709\u63d0\u4f9b\u624b\u673a\u5c3a\u5bf8\u3010{}\u3011", new Object[]{clientTypeName, appVersion, path, HEADER_NAME_TIO_SIZE});
            }
            String idfa = null;
            if (isFromIos) {
                idfa = request.getHeader(HEADER_NAME_TIO_IDFA);
                requestExt.setIdfa(idfa);
                if (StrUtil.isBlank((CharSequence)idfa)) {
                    log.warn("{} {}, path:{}, \u6ca1\u6709\u63d0\u4f9bidfa\u3010{}\u3011", new Object[]{clientTypeName, appVersion, path, HEADER_NAME_TIO_IDFA});
                }
            }
            if (StrUtil.isNotBlank((CharSequence)imei)) {
                ImeiStat imeiStat = ImeiStatService.me.getByImei(imei);
                if (imeiStat == null) {
                    imeiStat = WebApiHttpServerInterceptor.createImeiStat(request, requestExt);
                    ImeiStatService.me.save(imeiStat);
                } else {
                    String idfaInDb = imeiStat.getIdfa();
                    if (StrUtil.isBlank((CharSequence)idfaInDb) && StrUtil.isNotBlank((CharSequence)idfa)) {
                        ImeiStat newImeiStat = WebApiHttpServerInterceptor.createImeiStat(request, requestExt);
                        newImeiStat.setId(imeiStat.getId());
                        ImeiStatService.me.update(newImeiStat);
                    }
                }
            }
        } else {
            String userAgentStr = request.getUserAgent();
            UserAgent userAgent = UserAgentService.ME.save(userAgentStr);
            requestExt.setUserAgent(userAgent);
            boolean isMobile = UserAgent.isMobile((UserAgent)userAgent);
            requestExt.setFromBrowser(true);
            requestExt.setFromBrowserPc(!isMobile);
            requestExt.setFromBrowserMobile(isMobile);
            if (isMobile) {
                requestExt.setDeviceType(Devicetype.H5.getValue().byteValue());
            }
        }
        boolean isWhiteIp = IpWhiteListService.isWhiteIp((String)request.getClientIp());
        if (!request.isForward() && !isWhiteIp && accessTokenOn == 1) {
            if (WebApiHttpServerInterceptor.needCheckAccessToken(request, path)) {
                ICache cache2;
                String valueInCache;
                String value;
                Cookie cookie = request.getCookie("tio_mg_access_token");
                boolean needNewAccessToken = true;
                if (cookie != null && !StrUtil.isBlank((CharSequence)(value = cookie.getValue())) && Objects.equals(value, valueInCache = (String)(cache2 = Caches.getCache((CacheConfig)CacheConfig.MG_TIO_ACCESS_TOKEN)).get(request.getHttpSession().getId(), String.class))) {
                    needNewAccessToken = false;
                }
                if (needNewAccessToken) {
                    HttpResponse ret = Resps.bytesWithContentType((HttpRequest)request, (byte[])BODY_BYTES_NEED_ACCESS_TOKEN, (String)MimeType.TEXT_PLAIN_JSON.getType());
                    return ret;
                }
            }
            if (this.needClearAccessToken(path, request)) {
                ICache cache2 = Caches.getCache((CacheConfig)CacheConfig.MG_TIO_ACCESS_TOKEN);
                cache2.remove(request.getHttpSession().getId());
            }
        }
        if (StrUtil.isNotBlank((CharSequence)(pageSize = request.getParam("pageSize")))) {
            String remark = null;
            try {
                int _pageSize = Integer.parseInt(pageSize);
                if (_pageSize > 1000) {
                    remark = "pageSize\u53c2\u6570\u503c[" + _pageSize + "]\u8fc7\u5927\uff0c\u88ab\u8ba4\u4e3a\u662f\u653b\u51fb";
                }
            }
            catch (NumberFormatException e) {
                remark = "pageSize\u53c2\u6570\u503c[" + pageSize + "]\u4e0d\u662f\u6570\u5b57\uff0c\u88ab\u8ba4\u4e3a\u662f\u653b\u51fb";
            }
            if (remark != null) {
                TioIpPullblackUtils.addToBlack(request, request.getClientIp(), remark, (byte)2);
                request.close(remark);
                return null;
            }
        }
        HttpSession session = request.getHttpSession();
        MgUser user = WebUtils.currUser(request);
        Integer userid = null;
        boolean b = false;
        if (user != null) {
            userid = user.getId();
            b = true;
        }
        if (path.equals("/mglogin") || path.equals("/sys/params") || path.equals("/sys/synmenu")) {
            b = true;
        }
        if (!b) {
            if (user != null) {
                resp = Resp.fail((String)"\u6ca1\u6743\u9650\u8bbf\u95ee").code(Integer.valueOf(1004));
                return Resps.json((HttpRequest)request, (Object)resp);
            }
            SessionExt sessionExt = WebUtils.getSessionExt(session);
            MgOperLog loginLog = sessionExt.getKickedInfo();
            if (loginLog != null) {
                String ip = loginLog.getOperip();
                Date time = loginLog.getUpdatetime();
                String deviceinfo = loginLog.getDeviceinfo();
                String msg = "\u5f02\u5730\u767b\u5f55\uff0c\u60a8\u7684\u5e10\u53f7\u4e8e" + DateUtil.formatDateTime((Date)time) + "\u5728" + ip + "\u767b\u5f55\u8fc7";
                if (StrUtil.isNotBlank((CharSequence)deviceinfo)) {
                    msg = msg + "\uff0c\u767b\u5f55\u8bbe\u5907\u3010" + deviceinfo + "\u3011";
                }
                Resp resp2 = Resp.fail((String)msg).code(Integer.valueOf(1003));
                return Resps.json((HttpRequest)request, (Object)resp2);
            }
            Resp resp3 = Resp.fail((String)"\u60a8\u5c1a\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6").code(Integer.valueOf(1001));
            return Resps.json((HttpRequest)request, (Object)resp3);
        }
        if (user != null) {
            if (!WebApiHttpServerInterceptor.checkOperPath(path) && !user.getLoginname().equals("admin")) {
                resp = Resp.fail((String)"\u60a8\u662f\u8bd5\u7528\u8d26\u53f7,\u6ca1\u6709\u64cd\u4f5c\u6743\u9650").code(Integer.valueOf(1011));
                return Resps.json((HttpRequest)request, (Object)resp);
            }
            MgAuth auth = MgAuthService.ME.getAuthByAuthurl(path);
            if (auth != null) {
                boolean grant = true;
                MgUserAuthInfoVo authInfoVo = MgUserService.ME.getMgUserAuth(user.getId());
                if (authInfoVo == null) {
                    grant = false;
                } else {
                    HashMap operAuth = authInfoVo.getOperAuth();
                    if (CollectionUtil.isEmpty((Map)operAuth)) {
                        grant = false;
                    } else {
                        MgAuthVo mAuthVo = (MgAuthVo)operAuth.get(path);
                        if (mAuthVo == null) {
                            grant = false;
                        } else if (Objects.equals(mAuthVo.getOperstatus(), (byte)2)) {
                            grant = false;
                        }
                    }
                }
                if (!grant) {
                    Resp resp4 = Resp.fail((String)"\u6743\u9650\u4e0d\u8db3").code(Integer.valueOf(1004));
                    return Resps.json((HttpRequest)request, (Object)resp4);
                }
            }
        }
        requestExt.setCanCache(true);
        HttpResponse httpResponse = WebApiHttpServerInterceptor.doHttpCacheOnBeforeHandler(request, requestExt, path, this.httpCacheLockKey, useHttpcache);
        return httpResponse;
    }

    public static HttpResponse doHttpCacheOnBeforeHandler(HttpRequest request, RequestExt requestExt, String path, String httpCacheLockKey, boolean useHttpcache) throws Exception {
        Httpcache httpcache;
        ICache cache = null;
        if (useHttpcache) {
            cache = HttpcacheService.getCache((String)path);
        }
        if (useHttpcache && cache != null && (httpcache = HttpcacheService.get((String)path)) != null) {
            String cacheKey = WebApiHttpServerInterceptor.getHttpcacheKey(request, cache, httpcache);
            HttpResponse httpResponse = (HttpResponse)cache.get(cacheKey, HttpResponse.class);
            if (httpResponse != null) {
                return WebApiHttpServerInterceptor.cloneAnd304(request, requestExt, httpResponse);
            }
            ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)cacheKey, (Object)lockForGetLock);
            ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
            boolean tryWrite = writeLock.tryLock();
            if (tryWrite) {
                request.setAttribute(httpCacheLockKey, (Serializable)writeLock);
                httpResponse = (HttpResponse)cache.get(cacheKey, HttpResponse.class);
                if (httpResponse != null) {
                    return WebApiHttpServerInterceptor.cloneAnd304(request, requestExt, httpResponse);
                }
                return null;
            }
            ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
            boolean tryRead = readLock.tryLock(10L, TimeUnit.SECONDS);
            if (tryRead) {
                request.setAttribute(httpCacheLockKey, (Serializable)readLock);
                httpResponse = (HttpResponse)cache.get(cacheKey, HttpResponse.class);
                if (httpResponse != null) {
                    return WebApiHttpServerInterceptor.cloneAnd304(request, requestExt, httpResponse);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private static HttpResponse cloneAnd304(HttpRequest request, RequestExt requestExt, HttpResponse httpResponse) {
        HttpResponse clone = HttpResponse.cloneResponse((HttpRequest)request, (HttpResponse)httpResponse);
        requestExt.setFromCache(true);
        HeaderValue lastModified = clone.getLastModified();
        if (lastModified != null) {
            try {
                long _lastModified = Long.parseLong(lastModified.value);
                HttpResponse r304 = Resps.try304((HttpRequest)request, (long)_lastModified);
                if (r304 != null) {
                    r304.addHeader(HTTPCACHE_FLAG_HEADER_NAME, clone.getHeader(HTTPCACHE_FLAG_HEADER_NAME));
                    return r304;
                }
            }
            catch (NumberFormatException e) {
                return clone;
            }
        }
        return clone;
    }

    private boolean needClearAccessToken(String path, HttpRequest request) {
        String paytype;
        return "/recharge".equals(path) && StrUtil.isNotBlank((CharSequence)(paytype = request.getParam("paytype"))) && this.PAYTYPE_APPLE_APP.equals(paytype);
    }

    public void doAfterHandler(HttpRequest request, RequestLine requestLine, HttpResponse response, long cost) throws Exception {
        RequestExt requestExt = WebUtils.getRequestExt(request);
        response.addHeader(HeaderName.Access_Control_Allow_Credentials, HeaderValue.TRUE);
        WebApiHttpServerInterceptor.doHttpCacheOnAfterHandler(response, request, requestExt, requestLine.path, useHttpcache, this.httpCacheLockKey);
        WebApiHttpServerInterceptor.saveSlowRequest(request, requestLine, response, cost, (byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static HttpResponse doHttpCacheOnAfterHandler(HttpResponse response, HttpRequest request, RequestExt requestExt, String path, boolean useHttpcache, String httpCacheLockKey) {
        block28: {
            String cacheKey;
            block27: {
                Httpcache httpcache;
                block26: {
                    cacheKey = null;
                    if (!requestExt.isFromCache()) break block26;
                    HttpResponse httpResponse = response;
                    try {
                        Lock lock = (Lock)request.getAttribute(httpCacheLockKey);
                        if (lock != null) {
                            if (path == null) {
                                path = request.requestLine.getPath();
                            }
                            log.info("httpcache\u91ca\u653e\u9501\u3010{}\u3011, \u8fd9\u662f\u6b63\u5e38\u65e5\u5fd7. path:\u3010{}\u3011, cacheKey:{}", new Object[]{lock.getClass().getName(), path, cacheKey});
                            lock.unlock();
                        }
                    }
                    catch (Exception e) {
                        log.error(request.requestLine.toString(), (Throwable)e);
                    }
                    return httpResponse;
                }
                ICache cache = null;
                if (useHttpcache) {
                    cache = HttpcacheService.getCache((String)path);
                }
                if (!useHttpcache || cache == null || (httpcache = HttpcacheService.get((String)path)) == null || response == null || response.getStatus() != HttpResponseStatus.C200 || !requestExt.isCanCache()) break block27;
                cacheKey = WebApiHttpServerInterceptor.getHttpcacheKey(request, cache, httpcache);
                HeaderValue headerValueCacheKey = HeaderValue.from((String)cacheKey);
                HeaderValue lastModified = HeaderValue.from((String)(SystemTimer.currTime + ""));
                response.setLastModified(lastModified);
                HttpGzipUtils.gzip((HttpRequest)request, (HttpResponse)response);
                HttpResponse responseForCache = HttpResponse.cloneResponse((HttpRequest)request, (HttpResponse)response);
                responseForCache.addHeader(HTTPCACHE_FLAG_HEADER_NAME, headerValueCacheKey);
                cache.put(cacheKey, (Serializable)responseForCache);
                response.addHeader(HTTPCACHE_FIRST_HEADER_NAME, headerValueCacheKey);
                response.addHeader(HEADER_NAME_WEBAPI_SERVER, HEADER_VALUE_WHICH_API);
                HttpResponse httpResponse = response;
                try {
                    Lock lock = (Lock)request.getAttribute(httpCacheLockKey);
                    if (lock != null) {
                        if (path == null) {
                            path = request.requestLine.getPath();
                        }
                        log.info("httpcache\u91ca\u653e\u9501\u3010{}\u3011, \u8fd9\u662f\u6b63\u5e38\u65e5\u5fd7. path:\u3010{}\u3011, cacheKey:{}", new Object[]{lock.getClass().getName(), path, cacheKey});
                        lock.unlock();
                    }
                }
                catch (Exception e) {
                    log.error(request.requestLine.toString(), (Throwable)e);
                }
                return httpResponse;
            }
            try {
                Lock lock = (Lock)request.getAttribute(httpCacheLockKey);
                if (lock != null) {
                    if (path == null) {
                        path = request.requestLine.getPath();
                    }
                    log.info("httpcache\u91ca\u653e\u9501\u3010{}\u3011, \u8fd9\u662f\u6b63\u5e38\u65e5\u5fd7. path:\u3010{}\u3011, cacheKey:{}", new Object[]{lock.getClass().getName(), path, cacheKey});
                    lock.unlock();
                }
                break block28;
            }
            catch (Exception e) {
                log.error(request.requestLine.toString(), (Throwable)e);
            }
            break block28;
            catch (Exception e) {
                try {
                    log.error(e.toString(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        Lock lock = (Lock)request.getAttribute(httpCacheLockKey);
                        if (lock != null) {
                            if (path == null) {
                                path = request.requestLine.getPath();
                            }
                            log.info("httpcache\u91ca\u653e\u9501\u3010{}\u3011, \u8fd9\u662f\u6b63\u5e38\u65e5\u5fd7. path:\u3010{}\u3011, cacheKey:{}", new Object[]{lock.getClass().getName(), path, cacheKey});
                            lock.unlock();
                        }
                    }
                    catch (Exception e2) {
                        log.error(request.requestLine.toString(), (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    Lock lock = (Lock)request.getAttribute(httpCacheLockKey);
                    if (lock != null) {
                        if (path == null) {
                            path = request.requestLine.getPath();
                        }
                        log.info("httpcache\u91ca\u653e\u9501\u3010{}\u3011, \u8fd9\u662f\u6b63\u5e38\u65e5\u5fd7. path:\u3010{}\u3011, cacheKey:{}", new Object[]{lock.getClass().getName(), path, cacheKey});
                        lock.unlock();
                    }
                }
                catch (Exception e3) {
                    log.error(request.requestLine.toString(), (Throwable)e3);
                }
            }
        }
        return response;
    }

    public static void saveSlowRequest(HttpRequest request, RequestLine requestLine, HttpResponse response, long cost, byte type) {
        int slow_request_cost = MgConfService.getInt((String)"slow_request_cost", (Integer)2000);
        if (cost >= (long)slow_request_cost) {
            try {
                Date endtime = new Date();
                Date starttime = new Date(endtime.getTime() - cost);
                Integer uid = WebUtils.currUserId(request);
                String path = requestLine.getPathAndQuery();
                TioSlowRequest tioSlowRequest = new TioSlowRequest();
                tioSlowRequest.setType(Byte.valueOf(type));
                tioSlowRequest.setCost(Long.valueOf(cost));
                tioSlowRequest.setPath(path);
                if (!Objects.equals("/register/submit", path)) {
                    tioSlowRequest.setBody(StrUtil.subPre((CharSequence)request.getBodyString(), (int)1024));
                }
                tioSlowRequest.setEndtime(endtime);
                tioSlowRequest.setStarttime(starttime);
                tioSlowRequest.setUid(uid);
                tioSlowRequest.setSession(request.getHttpSession().getId());
                tioSlowRequest.save();
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    private static String getHttpcacheKey(HttpRequest request, ICache cache, Httpcache httpcache) {
        Integer currUid = WebUtils.currUserId(request);
        HashMap<String, String> params = null;
        String[] paramArray = httpcache.getParamArray();
        if (paramArray != null && paramArray.length > 0) {
            params = new HashMap<String, String>();
            for (String name : paramArray) {
                String value = request.getParam(name);
                params.put(name, value);
            }
        }
        return WebApiHttpServerInterceptor.getHttpcacheKey(currUid, params, cache, httpcache);
    }

    public static String getHttpcacheKey(Integer currUid, Map<String, Object> params, ICache cache, Httpcache httpcache) {
        String[] paramArray = httpcache.getParamArray();
        boolean isUseUidAsKey = httpcache.isUseUidAsKey();
        boolean isUseLoginedAsKey = httpcache.isUseLoginedAsKey();
        StringBuilder key = new StringBuilder(30);
        if (isUseUidAsKey && currUid != null) {
            key.append("u{").append(currUid).append("}");
        }
        if (isUseLoginedAsKey) {
            if (currUid != null) {
                key.append("l{1}");
            } else {
                key.append("l{0}");
            }
        }
        if (paramArray != null && params != null) {
            key.append("p{");
            for (String name : paramArray) {
                Object value = params.get(name);
                if (value == null) continue;
                key.append(name).append("=").append(value).append("&");
            }
            key.append("}");
        }
        if (key.length() == 0) {
            return "t-io";
        }
        return key.toString();
    }

    public static void removeHttpcache(String path, Map<String, Object> params, Integer currUid) {
        Httpcache httpcache;
        ICache cache = HttpcacheService.getCache((String)path);
        if (cache != null && (httpcache = HttpcacheService.get((String)path)) != null) {
            if (httpcache.isHasPageNumber()) {
                if (params == null) {
                    params = new HashMap<String, Object>();
                }
                for (int i = 0; i < 15; ++i) {
                    params.put("pageNumber", i);
                    String cacheKey = WebApiHttpServerInterceptor.getHttpcacheKey(currUid, params, cache, httpcache);
                    cache.remove(cacheKey);
                }
            } else {
                String cacheKey = WebApiHttpServerInterceptor.getHttpcacheKey(currUid, params, cache, httpcache);
                cache.remove(cacheKey);
            }
        }
    }

    public static void clearHttpcache(String path) {
        ICache cache = HttpcacheService.getCache((String)path);
        if (cache != null) {
            cache.clear();
        }
    }

    public AccessCtrlConfig getAccessCtrlConfig() {
        return this.accessCtrlConfig;
    }

    public void setAccessCtrlConfig(AccessCtrlConfig accessCtrlConfig) {
        this.accessCtrlConfig = accessCtrlConfig;
    }

    public static void initOperSet() {
        boolean allowOper = P.getBoolean((String)"oper.open.flag", (Boolean)true);
        if (!allowOper) {
            operPathSet.add("/common/file");
            operPathSet.add("/mguser/add");
            operPathSet.add("/mguser/update");
            operPathSet.add("/mguser/resetPwd");
            operPathSet.add("/mguser/del");
            operPathSet.add("/mguser/updatePwd");
            operPathSet.add("/topmenu/delfavorite");
            operPathSet.add("/topmenu/index");
            operPathSet.add("/topmenu/addfavorite");
            operPathSet.add("/mgauth/add");
            operPathSet.add("/mgauth/update");
            operPathSet.add("/mgauth/del");
            operPathSet.add("/mgauth/disable");
            operPathSet.add("/mgauth/operadd");
            operPathSet.add("/mgauth/operupdate");
            operPathSet.add("/mgauth/operdel");
            operPathSet.add("/mgauth/operdisable");
            operPathSet.add("/mgauth/index");
            operPathSet.add("/mgrole/add");
            operPathSet.add("/mgrole/update");
            operPathSet.add("/mgrole/grant");
            operPathSet.add("/mgrole/del");
            operPathSet.add("/mgdict/add");
            operPathSet.add("/mgdict/update");
            operPathSet.add("/mgdict/del");
            operPathSet.add("/mgdict/disable");
            operPathSet.add("/mgdict/index");
            operPathSet.add("/mgdict/insert");
            operPathSet.add("/mgconf/add");
            operPathSet.add("/mgconf/update");
            operPathSet.add("/recruit/cmpadd");
            operPathSet.add("/recruit/cmpupdate");
            operPathSet.add("/recruit/cmpdisable");
            operPathSet.add("/recruit/recruitdisable");
            operPathSet.add("/recruit/recruitadd");
            operPathSet.add("/recruit/recruitupdate");
            operPathSet.add("/order/paramupdate");
            operPathSet.add("/order/orderadd");
            operPathSet.add("/order/orderupdate");
            operPathSet.add("/order/salesadd");
            operPathSet.add("/order/salesupdate");
            operPathSet.add("/order/delsales");
            operPathSet.add("/order/delorderuser");
            operPathSet.add("/invoice/develop");
            operPathSet.add("/invoice/updatestatus");
            operPathSet.add("/invoice/batchupdate");
            operPathSet.add("/invoice/add");
            operPathSet.add("/invoice/update");
            operPathSet.add("/tiouser/disable");
            operPathSet.add("/tiouser/resetPwd");
            operPathSet.add("/email/submit");
            operPathSet.add("/email/add");
            operPathSet.add("/email/update");
            operPathSet.add("/email/del");
            operPathSet.add("/wxapp/add");
            operPathSet.add("/wxapp/update");
            operPathSet.add("/wxapp/del");
            operPathSet.add("/sys/initmenu");
            operPathSet.add("/sys/query");
        }
    }

    public static boolean checkOperPath(String path) {
        boolean allowOper = P.getBoolean((String)"oper.open.flag", (Boolean)true);
        if (allowOper) {
            return true;
        }
        return !operPathSet.contains(path);
    }

    static {
        neededCheckAccessTokenPathSet.add("/recharge/nf/" + RechargeItem.Paytype.APPLE_APP);
        skipCheckAccessTokenPathSet.add("/a/x");
        skipCheckAccessTokenPathSet.add("/a/y");
        skipCheckAccessTokenPathSet.add("/sys/synmenu");
        skipCheckAccessTokenPathSet.add("/blog/uploadimg");
        skipCheckAccessTokenPathSet.add("/ad/redirect");
        skipCheckAccessTokenPathSet.add("/blog/save");
        skipCheckAccessTokenPathSet.add("/test/checkStr");
        Resp resp = Resp.fail().code(Integer.valueOf(1006));
        String xx = Json.toJson((Object)resp);
        try {
            BODY_BYTES_NEED_ACCESS_TOKEN = xx.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.toString(), (Throwable)e);
        }
        WebApiHttpServerInterceptor.initOperSet();
        useHttpcache = P.getInt((String)"web.api.use.http.cache", (Integer)1) == 1;
    }
}

