/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.http;

import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.session.HttpSession;
import org.tio.http.server.session.HttpSessionListener;
import org.tio.mg.service.vo.SessionExt;

public class WebApiHttpSessionListener
implements HttpSessionListener {
    private static Logger log = LoggerFactory.getLogger(WebApiHttpSessionListener.class);
    public static final WebApiHttpSessionListener ME = new WebApiHttpSessionListener();

    private WebApiHttpSessionListener() {
    }

    public void doAfterCreated(HttpRequest request, HttpSession session, HttpConfig httpConfig) {
        String newSessionId = WebApiHttpSessionListener.decorateSessionId(request, session.getId());
        session.setId(newSessionId);
        session.setAttribute("SESSION_EXT", (Serializable)new SessionExt(), httpConfig);
    }

    private static String decorateSessionId(HttpRequest request, String initSessionId) {
        StringBuilder sb = new StringBuilder(initSessionId.length() + 5);
        sb.append(StrUtil.sub((CharSequence)initSessionId, (int)0, (int)2)).append("1");
        sb.append(StrUtil.sub((CharSequence)initSessionId, (int)2, (int)4)).append("4");
        sb.append(StrUtil.sub((CharSequence)initSessionId, (int)4, (int)5)).append("7");
        sb.append(StrUtil.sub((CharSequence)initSessionId, (int)5, (int)6)).append("2");
        sb.append(StrUtil.sub((CharSequence)initSessionId, (int)6, (int)8)).append("5");
        sb.append(StrUtil.sub((CharSequence)initSessionId, (int)8, (int)9)).append("8");
        sb.append(StrUtil.sub((CharSequence)initSessionId, (int)9, (int)12)).append("3");
        sb.append(StrUtil.sub((CharSequence)initSessionId, (int)9, (int)initSessionId.length()));
        return sb.toString();
    }

    public static boolean isValidSessionId(String s) {
        if (s.length() < 13) {
            return false;
        }
        int i = 0;
        return s.charAt(2 + i++) == '1' && s.charAt(4 + i++) == '4' && s.charAt(5 + i++) == '7' && s.charAt(6 + i++) == '2' && s.charAt(8 + i++) == '5' && s.charAt(9 + i++) == '8' && s.charAt(12 + i++) == '3';
    }
}

