/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.recharge.provider.apple;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Objects;
import okhttp3.Response;
import org.slf4j.Logger;
import org.tio.http.common.HttpRequest;
import org.tio.mg.service.model.main.RechargeItem;
import org.tio.mg.service.utils.LogUtils;
import org.tio.mg.web.server.recharge.provider.apple.vo.In_app;
import org.tio.mg.web.server.recharge.provider.apple.vo.Receipt;
import org.tio.mg.web.server.recharge.provider.apple.vo.ReceiptResult;
import org.tio.utils.http.HttpUtils;
import org.tio.utils.jfinal.P;
import org.tio.utils.json.Json;

public class IosVerify {
    private static Logger log = LogUtils.getCoinLog();
    private static final String URL_SANDBOX = "https://sandbox.itunes.apple.com/verifyReceipt";
    private static final String URL_ONLINE = "https://buy.itunes.apple.com/verifyReceipt";

    public static ReceiptResult verifyReceipt(HttpRequest request, String receipt, RechargeItem rechargeItem) throws Exception {
        String url = URL_ONLINE;
        return IosVerify.verifyReceipt(request, url, receipt, true, rechargeItem);
    }

    public static ReceiptResult verifyReceipt(HttpRequest request, String url, String receipt, boolean switchWhenFail, RechargeItem rechargeItem) throws Exception {
        JSONObject data = new JSONObject();
        data.put("receipt-data", (Object)receipt);
        String bodyString = data.toJSONString();
        Response response = HttpUtils.post((String)url, null, (String)bodyString);
        String resultStr = response.body().string();
        ReceiptResult receiptResult = (ReceiptResult)Json.toBean((String)resultStr, ReceiptResult.class);
        Receipt receipt1 = receiptResult.getReceipt();
        String mybundleid = P.get((String)"recharge.ios.bundleid");
        String bundleid = receipt1.getBundle_id();
        if (!Objects.equals(bundleid, mybundleid)) {
            throw new Exception("verifyReceipt fail\uff0c bundleid is " + bundleid + ", expected value is " + P.get((String)"recharge.ios.bundleid"));
        }
        List<In_app> list = receipt1.getIn_app();
        if (CollUtil.isEmpty(list)) {
            throw new Exception("verifyReceipt fail\uff0cin_app \u662f\u7a7a\u7684");
        }
        In_app in_app = list.get(0);
        if (!StrUtil.startWith((CharSequence)in_app.getProduct_id(), (CharSequence)mybundleid)) {
            throw new Exception("verifyReceipt fail\uff0c product_id is not " + mybundleid);
        }
        Integer status = receiptResult.getStatus();
        rechargeItem.setRemark(url);
        if (Objects.equals(status, 0)) {
            log.info("\u82f9\u679c\u5145\u503c\u6210\u529f\uff0cresultStr:{}", (Object)resultStr);
        } else {
            log.error("\u82f9\u679c\u5145\u503c\u4e0d\u6210\u529f\uff0cresultStr:{}", (Object)resultStr);
            if (switchWhenFail) {
                if (Objects.equals(status, 21007) && Objects.equals(URL_ONLINE, url)) {
                    return IosVerify.verifyReceipt(request, URL_SANDBOX, receipt, false, rechargeItem);
                }
                if (Objects.equals(status, 21008) && Objects.equals(URL_SANDBOX, url)) {
                    return IosVerify.verifyReceipt(request, URL_ONLINE, receipt, false, rechargeItem);
                }
            }
        }
        return receiptResult;
    }
}

