/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.recharge.provider.weixin;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.qrcode.QrCodeUtil;
import com.github.wxpay.sdk.WXPay;
import com.github.wxpay.sdk.WXPayConfig;
import com.github.wxpay.sdk.WXPayConstants;
import com.github.wxpay.sdk.WXPayUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.server.mvc.Routes;
import org.tio.http.server.util.Resps;
import org.tio.mg.service.model.main.RechargeItem;
import org.tio.mg.service.service.recharge.RechargeItemService;
import org.tio.mg.service.utils.LogUtils;
import org.tio.mg.web.server.controller.base.QrCodeController;
import org.tio.mg.web.server.recharge.IRechargeProvider;
import org.tio.mg.web.server.recharge.RechargeUtils;
import org.tio.mg.web.server.recharge.provider.weixin.TradeType;
import org.tio.mg.web.server.recharge.provider.weixin.WXPayConfigImpl;
import org.tio.mg.web.server.utils.SessionCacheUtils;
import org.tio.utils.json.Json;
import org.tio.websocket.common.util.BASE64Util;

public class WxPayScan2RechargeProvider
implements IRechargeProvider {
    private static Logger log = LogUtils.getCoinLog();
    public static final WxPayScan2RechargeProvider me = new WxPayScan2RechargeProvider();
    protected WXPay wxpay;
    protected WXPayConfig config = this.getWXPayConfig();

    protected WxPayScan2RechargeProvider() {
        this.wxpay = new WXPay(this.config);
    }

    public WXPayConfig getWXPayConfig() {
        return WXPayConfigImpl.getInstance();
    }

    @Override
    public HttpResponse toThirdRechargePage(HttpRequest request, RechargeItem rechargeItem, int callbackType) throws Exception {
        Integer paytype = rechargeItem.getPaytype();
        String _subject = rechargeItem.getGoods();
        if (StrUtil.isBlank((CharSequence)_subject)) {
            _subject = "\u5145\u503c";
        }
        String total_fee = String.valueOf((int)NumberUtil.mul((double)rechargeItem.getAmount(), (float)100.0f));
        String tradeno = rechargeItem.getTradeno();
        String ip = request.getClientIp();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("body", _subject);
        data.put("out_trade_no", tradeno);
        data.put("device_info", "");
        data.put("fee_type", "CNY");
        data.put("total_fee", total_fee);
        data.put("spbill_create_ip", ip);
        data.put("notify_url", RechargeUtils.getNotifyUrl(paytype, request));
        data.put("trade_type", TradeType.NATIVE.getValue());
        data.put("product_id", tradeno);
        try {
            Map r = this.wxpay.unifiedOrder(data);
            String returnCode = (String)r.get("return_code");
            if ("SUCCESS".equals(returnCode)) {
                String result_code = (String)r.get("result_code");
                if ("SUCCESS".equals(result_code)) {
                    String prepay_id = (String)r.get("prepay_id");
                    if (StrUtil.isNotBlank((CharSequence)prepay_id)) {
                        rechargeItem.setThirdtradeno(prepay_id);
                        RechargeItemService.me.update(rechargeItem);
                        String code_url = (String)r.get("code_url");
                        Integer recharge_only_qr = (Integer)request.getAttribute("recharge_only_qr");
                        Integer width = (Integer)request.getAttribute("recharge_only_qr_width");
                        Integer height = (Integer)request.getAttribute("recharge_only_qr_height");
                        if (Objects.equals(recharge_only_qr, 1)) {
                            QrCodeController qrCodeController = (QrCodeController)Routes.getController(QrCodeController.class);
                            return qrCodeController.index(width, height, null, null, code_url, request);
                        }
                        HashMap<String, String> retData = new HashMap<String, String>();
                        retData.put("code_url", code_url);
                        BufferedImage bufferedImage = QrCodeUtil.generate((String)code_url, (int)190, (int)190);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)bufferedImage, "png", out);
                        byte[] bs = out.toByteArray();
                        String ss = BASE64Util.byteArrayToBase64((byte[])bs);
                        SessionCacheUtils.put(request, "WX_PAY_QR_BASE64", (Serializable)((Object)ss));
                        SessionCacheUtils.put(request, "WX_PAY_AMOUNT", rechargeItem.getAmount());
                        SessionCacheUtils.put(request, "WX_PAY_SUBJECT", (Serializable)((Object)_subject));
                        SessionCacheUtils.put(request, "WX_PAY_TRADENO", (Serializable)((Object)tradeno));
                        return Resps.redirect((HttpRequest)request, (String)"/recharge/wechatPay.html");
                    }
                } else {
                    log.error("\u5fae\u4fe1\u626b\u7801\u5145\u503c\uff0c\u63d0\u4ea4\u5931\u8d25:{}", (Object)Json.toJson((Object)r));
                }
            } else {
                log.error("\u5fae\u4fe1\u626b\u7801\u5145\u503c\uff0c\u63d0\u4ea4\u5931\u8d25:{}", (Object)Json.toJson((Object)r));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return null;
    }

    protected static Map<String, String> toMap(HttpRequest request) throws Exception {
        String arrName = "wxPay_params";
        HashMap ret = (HashMap)request.getAttribute(arrName);
        if (ret != null) {
            return ret;
        }
        String bodyString = request.getBodyString();
        ret = (HashMap)WXPayUtil.xmlToMap((String)bodyString);
        request.setAttribute(arrName, (Serializable)ret);
        return ret;
    }

    @Override
    public boolean isValidCallback(HttpRequest request, int callbackType) throws Exception {
        Map<String, String> params = WxPayScan2RechargeProvider.toMap(request);
        String sign_type = params.get("sign_type");
        boolean verify_result = false;
        verify_result = StrUtil.isNotBlank((CharSequence)sign_type) ? ("MD5".equalsIgnoreCase(sign_type) ? WXPayUtil.isSignatureValid(params, (String)this.config.getKey(), (WXPayConstants.SignType)WXPayConstants.SignType.MD5) : ("HMAC-SHA256".equalsIgnoreCase(sign_type) ? WXPayUtil.isSignatureValid(params, (String)this.config.getKey(), (WXPayConstants.SignType)WXPayConstants.SignType.HMACSHA256) : WXPayUtil.isSignatureValid(params, (String)this.config.getKey()))) : WXPayUtil.isSignatureValid(params, (String)this.config.getKey());
        return verify_result;
    }

    @Override
    public String getTradeno(HttpRequest request, int callbackType) {
        Map<String, String> params = null;
        try {
            params = WxPayScan2RechargeProvider.toMap(request);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            return null;
        }
        String out_trade_no = params.get("out_trade_no");
        return out_trade_no;
    }

    @Override
    public void fillOnNotify(HttpRequest request, RechargeItem rechargeItem, int callbackType) {
        Map<String, String> params = null;
        try {
            params = WxPayScan2RechargeProvider.toMap(request);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            return;
        }
        String return_code = params.get("return_code");
        String transaction_id = params.get("transaction_id");
        String result_code = params.get("result_code");
        String bank_type = params.get("bank_type");
        String total_fee = params.get("total_fee");
        Integer totalfee1 = Integer.parseInt(total_fee);
        double totalfee = totalfee1 / 100;
        String time_end = params.get("time_end");
        String nonce_str = params.get("nonce_str");
        rechargeItem.setThirdtradeno(transaction_id);
        rechargeItem.setThirdstatus(result_code);
        rechargeItem.setThirdaccount(bank_type);
        rechargeItem.setThirdamount(Double.valueOf(totalfee));
        rechargeItem.setThirdnotifyid(nonce_str);
        try {
            rechargeItem.setThirdtradetime(new SimpleDateFormat("yyyyMMddHHmmss").parse(time_end));
        }
        catch (Exception e) {
            LogUtils.getCoinLog().error(time_end + "\u8fdb\u884c\u65e5\u671f\u8f6c\u6362\u51fa\u9519\u4e86", (Throwable)e);
        }
        if ("SUCCESS".equals(return_code) && "SUCCESS".equals(result_code)) {
            rechargeItem.setStatus(Integer.valueOf(2));
        } else if ("FAIL".equals(result_code)) {
            rechargeItem.setStatus(Integer.valueOf(3));
        } else {
            rechargeItem.setStatus(Integer.valueOf(99));
        }
        rechargeItem.setRemark(StringUtils.left((String)(request.getHeaderString() + request.getBodyString()), (int)2048));
    }

    @Override
    public HttpResponse notifySuccess(HttpRequest request, RechargeItem rechargeItem, int callbackType) throws Exception {
        return Resps.html((HttpRequest)request, (String)"<xml><return_code>SUCCESS</return_code><return_msg>OK</return_msg></xml>");
    }

    @Override
    public HttpResponse notifyFail(HttpRequest request, RechargeItem rechargeItem, int callbackType) throws Exception {
        return Resps.html((HttpRequest)request, (String)"<xml><return_code>FAIL</return_code><return_msg>fail</return_msg></xml>");
    }

    public static void main(String[] args) {
        double xx = NumberUtil.mul((double)2.07, (float)100.0f);
        System.out.println(xx);
    }
}

