/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.utils;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import net.coobird.thumbnailator.Thumbnails;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.UploadFile;
import org.tio.mg.service.model.main.Img;
import org.tio.mg.web.server.utils.UploadUtils;
import org.tio.sitexxx.service.vo.Const;

public class ImgUtils {
    private static Logger log = LoggerFactory.getLogger(ImgUtils.class);
    static long c = 0L;

    public static void scale(String srcImg, String desImg, double scale) {
        Mat src = Imgcodecs.imread((String)srcImg);
        Mat dst = src.clone();
        Imgproc.resize((Mat)src, (Mat)dst, (Size)new Size((double)src.width() * scale, (double)src.height() * scale));
        Imgcodecs.imwrite((String)desImg, (Mat)dst);
    }

    public static void scale(String srcImg, String desImg, double scale, double quality) throws Exception {
        Thumbnails.of((String[])new String[]{srcImg}).scale(scale).outputQuality(quality).toFile(desImg);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String rootPath = "F:\\work\\tio-site\\some\\\u6280\u672f\u767d\u76ae\u4e66";
        List files = FileUtil.loopFiles((String)rootPath, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String ext = FileUtil.extName((File)pathname);
                if (ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("jpg")) {
                    return !pathname.getName().startsWith("scaled_");
                }
                return false;
            }
        });
        int size = 1080;
        for (File file : files) {
            try {
                byte[] imageBytes = FileUtil.readBytes((File)file);
                BufferedImage bi = ImgUtil.toImage((byte[])imageBytes);
                if (bi.getWidth() <= size) continue;
                float scale = ImgUtils.calcScaleWithWidth(size, bi);
                String imgFilePath = file.getCanonicalPath();
                File desFile = new File(file.getParent(), "scaled_" + scale + "_" + file.getName());
                String smImgFilePath = desFile.getCanonicalPath();
                Thumbnails.of((String[])new String[]{imgFilePath}).scale((double)scale).outputQuality(0.8f).toFile(smImgFilePath);
            }
            catch (Exception e) {
                try {
                    log.error(file.getCanonicalPath(), (Throwable)e);
                }
                catch (IOException e1) {
                    log.error(e1.toString(), (Throwable)e1);
                }
            }
        }
    }

    public static float calcScaleWithWidth(int maxWidth, BufferedImage initBufferedImage) {
        int initWidth = initBufferedImage.getWidth();
        int newWidth = Math.min(maxWidth, initWidth);
        return (float)newWidth / (float)initWidth;
    }

    public static float calcScaleWithHeight(int maxHeight, BufferedImage initBufferedImage) {
        int initHeight = initBufferedImage.getHeight();
        int newHeight = Math.min(maxHeight, initHeight);
        return (float)newHeight / (float)initHeight;
    }

    public static Img processImg(String subDir, Integer uid, UploadFile uploadFile, float scale) throws Exception {
        String ext = FileUtil.extName((String)uploadFile.getName());
        if (StrUtil.isBlank((CharSequence)ext)) {
            ext = "gif";
        }
        boolean needScale = !"gif".equals(ext);
        String imgUrlWithoutExt = UploadUtils.newFile(subDir, uid, uploadFile.getName());
        String imgUrl = imgUrlWithoutExt + "." + ext;
        String smImgUrl = null;
        byte[] imgBytes = uploadFile.getData();
        smImgUrl = needScale ? imgUrlWithoutExt + "_sm." + ext : imgUrl;
        String imgFilePath = Const.RES_ROOT + imgUrl;
        String smImgFilePath = Const.RES_ROOT + smImgUrl;
        File imgFile = new File(imgFilePath);
        FileUtil.mkParentDirs((String)imgFilePath);
        File smImgFile = null;
        if (needScale) {
            smImgFile = new File(smImgFilePath);
            FileUtil.mkParentDirs((File)smImgFile);
        } else {
            smImgFile = imgFile;
        }
        BufferedImage bi = ImgUtil.toImage((byte[])imgBytes);
        Img img = new Img();
        if (needScale) {
            double quality = 0.5;
            Thumbnails.of((BufferedImage[])new BufferedImage[]{bi}).scale(1.0).outputQuality(quality).toFile(imgFilePath);
            if (scale < 1.0f) {
                Thumbnails.of((BufferedImage[])new BufferedImage[]{bi}).scale((double)scale).outputQuality(quality).toFile(smImgFilePath);
            } else {
                FileUtil.copy((String)imgFilePath, (String)smImgFilePath, (boolean)true);
            }
        } else {
            FileUtil.writeBytes((byte[])imgBytes, (File)imgFile);
        }
        BufferedImage smBi = ImgUtil.read((File)smImgFile);
        img.setCoverheight(Integer.valueOf(smBi.getHeight()));
        img.setCoversize(Integer.valueOf((int)FileUtil.size((File)smImgFile)));
        img.setCoverwidth(Integer.valueOf(smBi.getWidth()));
        img.setCoverurl(smImgUrl);
        img.setUrl(imgUrl);
        img.setUid(uid);
        String filename = uploadFile.getName();
        img.setFilename(filename);
        img.setHeight(Integer.valueOf(bi.getHeight()));
        img.setWidth(Integer.valueOf(bi.getWidth()));
        img.setSize(Long.valueOf(FileUtil.size((File)imgFile)));
        img.setTitle(filename);
        return img;
    }

    public static Img processImg(String subDir, UploadFile uploadFile) throws Exception {
        String ext = FileUtil.extName((String)uploadFile.getName());
        if (StrUtil.isBlank((CharSequence)ext)) {
            ext = "gif";
        }
        String imgUrlWithoutExt = UploadUtils.dateFile(subDir);
        String imgUrl = imgUrlWithoutExt + "." + ext;
        byte[] imgBytes = uploadFile.getData();
        String imgFilePath = Const.RES_ROOT + imgUrl;
        File imgFile = new File(imgFilePath);
        FileUtil.mkParentDirs((String)imgFilePath);
        BufferedImage bi = ImgUtil.toImage((byte[])imgBytes);
        Img img = new Img();
        FileUtil.writeBytes((byte[])imgBytes, (File)imgFile);
        img.setCoverheight(Integer.valueOf(bi.getHeight()));
        img.setCoversize(Integer.valueOf((int)FileUtil.size((File)imgFile)));
        img.setCoverwidth(Integer.valueOf(bi.getWidth()));
        img.setCoverurl(imgUrl);
        img.setUrl(imgUrl);
        img.setUid(null);
        String filename = uploadFile.getName();
        img.setFilename(filename);
        img.setHeight(Integer.valueOf(bi.getHeight()));
        img.setWidth(Integer.valueOf(bi.getWidth()));
        img.setSize(Long.valueOf(FileUtil.size((File)imgFile)));
        img.setTitle(filename);
        return img;
    }
}

