/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.utils;

import cn.hutool.core.io.FileUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.model.main.Video;
import org.tio.utils.hutool.BetweenFormater;

public class VideoUtils {
    private static Logger log = LoggerFactory.getLogger(VideoUtils.class);

    public static void main(String[] args) {
    }

    public static Video processVideo(String videoFilePath, String coverFilePath, int coverWidth, String coverExt) throws Exception {
        long start = System.currentTimeMillis();
        File coverFile = new File(coverFilePath);
        if (!coverFile.exists()) {
            FileUtil.mkParentDirs((File)coverFile);
        }
        FFmpegFrameGrabber ff = new FFmpegFrameGrabber(videoFilePath);
        ff.start();
        int frameCount = ff.getLengthInFrames();
        Frame f = null;
        for (int i = 0; i < frameCount; ++i) {
            f = ff.grabImage();
            if (i > 5 && f.image != null) break;
        }
        Java2DFrameConverter converter = new Java2DFrameConverter();
        BufferedImage bufferedImage = converter.getBufferedImage(f);
        int initWidth = bufferedImage.getWidth();
        int initHeight = bufferedImage.getHeight();
        BufferedImage newBufferedImage = null;
        int newWidth = Math.min(coverWidth, initWidth);
        if (newWidth != initWidth) {
            int newHeight = initHeight;
            newHeight = (int)((double)newWidth / (double)initWidth * (double)initHeight);
            newBufferedImage = new BufferedImage(newWidth, newHeight, 5);
            Image img = bufferedImage.getScaledInstance(newWidth, newHeight, 1);
            newBufferedImage.getGraphics().drawImage(img, 0, 0, null);
            ImageIO.write((RenderedImage)newBufferedImage, coverExt, coverFile);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, coverExt, coverFile);
            newBufferedImage = bufferedImage;
        }
        long millseconds = ff.getLengthInTime() / 1000L;
        long seconds = millseconds / 1000L;
        double fps = ff.getFrameRate();
        ff.stop();
        File videoFile = new File(videoFilePath);
        Video video = new Video();
        video.setFps(Double.valueOf(fps));
        video.setFramecount(Integer.valueOf(frameCount));
        video.setSeconds(Integer.valueOf((int)seconds));
        BetweenFormater betweenFormater = new BetweenFormater(millseconds, BetweenFormater.Level.SECOND);
        betweenFormater.format();
        video.setFormatedseconds(betweenFormater.format());
        video.setCoverheight(Integer.valueOf(newBufferedImage.getHeight()));
        video.setCoverwidth(Integer.valueOf(newBufferedImage.getWidth()));
        video.setCoversize(Integer.valueOf((int)FileUtil.size((File)coverFile)));
        video.setHeight(Integer.valueOf(initHeight));
        video.setWidth(Integer.valueOf(initWidth));
        video.setSize(Long.valueOf(FileUtil.size((File)videoFile)));
        log.error("\u751f\u6210\u5c01\u9762\u56fe\u8017\u65f6:{}ms, \u89c6\u9891[{}]\uff0c\u7f29\u7565\u56fe:[{}]", new Object[]{System.currentTimeMillis() - start, videoFilePath, coverFilePath});
        return video;
    }
}

