/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.utils;

import cn.hutool.core.util.StrUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.session.HttpSession;
import org.tio.mg.service.model.main.IpInfo;
import org.tio.mg.service.model.main.UserAgent;
import org.tio.mg.service.model.main.UserToken;
import org.tio.mg.service.model.mg.MgUser;
import org.tio.mg.service.service.base.IpInfoService;
import org.tio.mg.service.service.base.UserAgentService;
import org.tio.mg.service.service.base.UserTokenService;
import org.tio.mg.service.service.mg.MgUserService;
import org.tio.mg.service.topic.Topics;
import org.tio.mg.service.vo.RequestExt;
import org.tio.mg.service.vo.SessionExt;
import org.tio.mg.web.server.init.WebApiInit;
import org.tio.sitexxx.service.vo.Const;

public class WebUtils {
    private static Logger log = LoggerFactory.getLogger(WebUtils.class);
    private static MgUserService userService = MgUserService.ME;

    public static void logout(Integer uid) {
        List list = UserTokenService.me.find(uid.intValue());
        if (list != null && list.size() > 0) {
            for (UserToken userToken : list) {
                SessionExt sessionExt;
                HttpSession session;
                String token = userToken.getToken();
                if (!StrUtil.isNotBlank((CharSequence)token) || (session = (HttpSession)WebApiInit.httpConfig.getSessionStore().get(token)) == null || (sessionExt = (SessionExt)session.getAttribute("SESSION_EXT", SessionExt.class, null, WebApiInit.httpConfig)) == null || sessionExt.getUid() == null) continue;
                sessionExt.setUid(null);
                session.update(WebApiInit.httpConfig);
            }
            UserTokenService.me.delete(uid.intValue());
        }
    }

    public static void removeHttpcache(String path, Map<String, Object> params, Integer currUid) {
        Topics.notifyRemoveHttpCache((String)path, (Integer)currUid, params, (int)1);
    }

    public static void clearHttpcache(String path) {
        Topics.notifyRemoveHttpCache((String)path, null, null, (int)2);
    }

    public static String path(String path) {
        String contextpath = Const.API_CONTEXTPATH;
        String suffix = Const.API_SUFFIX;
        int x = StringUtils.indexOf((CharSequence)path, (CharSequence)"?");
        if (x == -1) {
            return contextpath + path + suffix;
        }
        String path1 = path.substring(0, x);
        String queryStr = path.substring(x + 1, path.length());
        return contextpath + path1 + suffix + "?" + queryStr;
    }

    public static MgUser currUser(HttpRequest request) {
        Integer userid = WebUtils.currUserId(request);
        if (userid != null) {
            MgUser user = userService.getById(userid);
            return user;
        }
        return null;
    }

    public static Integer currUserId(HttpRequest request) {
        HttpSession session = request.getHttpSession();
        SessionExt sessionExt = WebUtils.getSessionExt(session);
        Integer userid = sessionExt.getUid();
        return userid;
    }

    public static SessionExt getSessionExt(HttpRequest request) {
        SessionExt sessionExt = WebUtils.getSessionExt(request.getHttpSession());
        return sessionExt;
    }

    public static SessionExt getSessionExt(HttpSession session) {
        SessionExt sessionExt = (SessionExt)session.getAttribute("SESSION_EXT", SessionExt.class);
        return sessionExt;
    }

    public static Integer getUserIdBySession(HttpSession session) {
        if (session == null) {
            return null;
        }
        SessionExt sessionExt = WebUtils.getSessionExt(session);
        Integer userid = sessionExt.getUid();
        return userid;
    }

    public static RequestExt getRequestExt(HttpRequest request) {
        return (RequestExt)request.getAttribute("TIO_SITE_REQUESTEXT");
    }

    public static int getImServerPort(HttpRequest request) {
        RequestExt requestExt = WebUtils.getRequestExt(request);
        if (requestExt.isFromBrowser()) {
            return Const.ImPort.WS;
        }
        return Const.ImPort.APP;
    }

    public static Map<String, Object> getMapParams(HttpRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (request.getParams() != null) {
            Map paramArray = request.getParams();
            for (String key : paramArray.keySet()) {
                Object[] param = (Object[])paramArray.get(key);
                if (param == null || param.length < 1) continue;
                params.put(key, param[0]);
            }
        }
        return params;
    }

    public static IpInfo getIpInfo(HttpRequest request) {
        String ip = request.getClientIp();
        return IpInfoService.ME.save(ip);
    }

    public static UserAgent getUserAgent(HttpRequest request) {
        String userAgentStr = request.getUserAgent();
        return UserAgentService.ME.save(userAgentStr);
    }

    public static String resUrl(String path) {
        if (StrUtil.startWithIgnoreCase((CharSequence)path, (CharSequence)"http://") || StrUtil.startWithIgnoreCase((CharSequence)path, (CharSequence)"https://") || StrUtil.startWithIgnoreCase((CharSequence)path, (CharSequence)"//")) {
            return path;
        }
        return Const.RES_SERVER + path;
    }
}

