/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.web.server.vo;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpResponse;
import org.tio.mg.service.model.main.User;

public class LoginResult {
    private static Logger log = LoggerFactory.getLogger(LoginResult.class);
    private Code code;
    private ErrorCode errorCode;
    private User user = null;
    private HttpResponse httpResponse = null;

    public static LoginResult fail(ErrorCode errorCode, HttpResponse httpResponse) {
        LoginResult ret = new LoginResult(Code.FAIL, null, httpResponse);
        ret.setErrorCode(errorCode);
        return ret;
    }

    public static void main(String[] args) {
        log.info("");
    }

    public static LoginResult success(User user, HttpResponse httpResponse) {
        LoginResult ret = new LoginResult(Code.SUCCESS, user, httpResponse);
        return ret;
    }

    private LoginResult(Code code, User user, HttpResponse httpResponse) {
        this.code = code;
        this.user = user;
        this.setHttpResponse(httpResponse);
    }

    public Code getCode() {
        return this.code;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public User getUser() {
        return this.user;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public static enum ErrorCode {
        USER_OR_PWD_ERROR_PWD(1, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e"),
        USER_OR_PWD_ERROR_SMS(1, "\u7528\u6237\u540d\u6216\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e"),
        USER_INBLACK_ERROR(4, "\u7528\u6237\u5df2\u5c01\u505c"),
        USER_STATUS_ERROR(3, "\u65e0\u6548\u72b6\u6001\u7528\u6237");

        public Integer code;
        public String value;

        public static ErrorCode from(String code) {
            ErrorCode[] values;
            for (ErrorCode v : values = ErrorCode.values()) {
                if (!Objects.equals(v.value, code)) continue;
                return v;
            }
            return USER_OR_PWD_ERROR_PWD;
        }

        private ErrorCode(Integer code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum Code {
        SUCCESS(1),
        FAIL(2);

        Integer value;

        public static Code from(Integer code) {
            Code[] values;
            for (Code v : values = Code.values()) {
                if (!Objects.equals(v.value, code)) continue;
                return v;
            }
            return SUCCESS;
        }

        private Code(Integer value) {
            this.value = value;
        }
    }
}

