/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.im.common;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.im.common.Command;
import org.tio.utils.lock.LockUtils;
import org.tio.utils.lock.ReadWriteLockHandler;

public class CommandStat {
    private static Logger log = LoggerFactory.getLogger(CommandStat.class);
    public static final Map<Command, CommandStat> COMMAND_STAT_MAP = new HashMap<Command, CommandStat>();
    public final AtomicLong received = new AtomicLong();
    public final AtomicLong handled = new AtomicLong();
    public final AtomicLong sent = new AtomicLong();

    public static CommandStat getCommandStat(final Command command) {
        if (command == null) {
            return null;
        }
        CommandStat ret = COMMAND_STAT_MAP.get((Object)command);
        if (ret != null) {
            return ret;
        }
        try {
            LockUtils.runWriteOrWaitRead((String)CommandStat.class.getName(), CommandStat.class, (ReadWriteLockHandler)new ReadWriteLockHandler(){

                public void write() throws Exception {
                    CommandStat ret = COMMAND_STAT_MAP.get((Object)command);
                    if (ret == null) {
                        ret = new CommandStat();
                        COMMAND_STAT_MAP.put(command, ret);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        ret = COMMAND_STAT_MAP.get((Object)command);
        return ret;
    }

    public static void main(String[] args) {
    }

    public AtomicLong getHandled() {
        return this.handled;
    }

    public AtomicLong getReceived() {
        return this.received;
    }

    public AtomicLong getSent() {
        return this.sent;
    }
}

