/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.im.common.utils;

import cn.hutool.core.util.StrUtil;
import java.util.HashSet;
import java.util.Set;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.session.HttpSession;
import org.tio.mg.im.common.ImSessionContext;
import org.tio.mg.im.common.bs.HandshakeReq;
import org.tio.mg.im.common.converter.SimpleUserConverter;
import org.tio.mg.service.init.RedisInit;
import org.tio.mg.service.model.main.IpInfo;
import org.tio.mg.service.model.main.User;
import org.tio.mg.service.model.main.UserAgent;
import org.tio.mg.service.service.base.IpInfoService;
import org.tio.mg.service.service.base.UserAgentService;
import org.tio.mg.service.service.base.UserRoleService;
import org.tio.mg.service.service.base.UserService;
import org.tio.mg.service.vo.SessionExt;
import org.tio.mg.service.vo.SimpleUser;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.MobileInfo;
import org.tio.utils.cache.caffeineredis.CaffeineRedisCache;
import org.tio.utils.convert.Converter;
import org.tio.utils.jfinal.P;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.page.Page;

public class ImUtils {
    private static Logger log = LoggerFactory.getLogger(ImUtils.class);
    private static final String CHANNEL_KEY_HANDSHAKE_USER = "TIO_SITE_HANDSHAKE_USER";
    private static final String TIO_SITE_HANDSHAKE_SIMPLEUSERVO = "TIO_SITE_HANDSHAKE_SIMPLEUSERVO";
    private static final long httpSessionTimeout = P.getLong((String)"http.session.timeout", (Long)1800L);
    private static final CaffeineRedisCache httpSessionCache = CaffeineRedisCache.register((RedissonClient)RedisInit.get(), (String)P.get((String)"http.session.cache.name", (String)"tio-h-s"), null, (Long)httpSessionTimeout);
    private static UserService userService = UserService.ME;

    public static SimpleUser setHandshakeUser(ChannelContext channelContext, User user) {
        return ImUtils.setHandshakeUser(channelContext, user, null);
    }

    public static SimpleUser setHandshakeUser(ChannelContext channelContext, User user, SimpleUser may) {
        if (user != null) {
            // empty if block
        }
        channelContext.setAttribute(CHANNEL_KEY_HANDSHAKE_USER, (Object)user);
        SimpleUser simpleUser = ImUtils.setHandshakeSimpleUser(channelContext, user, may);
        return simpleUser;
    }

    public static User getHandshakeUser(ChannelContext channelContext) {
        return (User)channelContext.getAttribute(CHANNEL_KEY_HANDSHAKE_USER);
    }

    public static SimpleUser setHandshakeSimpleUser(ChannelContext channelContext, User user) {
        return ImUtils.setHandshakeSimpleUser(channelContext, user, null);
    }

    public static SimpleUser setHandshakeSimpleUser(ChannelContext channelContext, User user, SimpleUser may) {
        SimpleUser simpleUser = ImUtils.getSimpleUser(user, channelContext, true);
        simpleUser.setMay(may);
        channelContext.setAttribute(TIO_SITE_HANDSHAKE_SIMPLEUSERVO, (Object)simpleUser);
        return simpleUser;
    }

    public static SimpleUser getHandshakeSimpleUser(ChannelContext channelContext) {
        return (SimpleUser)channelContext.getAttribute(TIO_SITE_HANDSHAKE_SIMPLEUSERVO);
    }

    protected ImUtils() {
    }

    public static Integer getUseridByToken(String token) {
        if (StrUtil.isBlank((CharSequence)token)) {
            return null;
        }
        HttpSession session = (HttpSession)httpSessionCache.get(token);
        if (session != null) {
            SessionExt sessionExt = (SessionExt)session.getAttribute("SESSION_EXT", SessionExt.class);
            Integer userid = sessionExt.getUid();
            if (userid != null) {
                return userid;
            }
            log.info("session\u4e2d\u5e76\u672a\u7ed1\u5b9auserid, token:{}", (Object)token);
            return null;
        }
        log.info("\u4e0d\u80fd\u6839\u636etoken[{}]\u627e\u5230session\u5bf9\u8c61", (Object)token);
        return null;
    }

    public static String getToken(ChannelContext channelContext) {
        ImSessionContext imSessionContext = ImUtils.getImSessionContext(channelContext);
        if (imSessionContext == null) {
            return null;
        }
        HandshakeReq handshakeReq = imSessionContext.getHandshakeReq();
        if (handshakeReq == null) {
            return null;
        }
        String token = handshakeReq.getToken();
        return token;
    }

    public static User getUser(ChannelContext channelContext) {
        if (channelContext.isVirtual) {
            return ImUtils.getHandshakeUser(channelContext);
        }
        String token = ImUtils.getToken(channelContext);
        User user = ImUtils.getUser(token);
        if (user == null && StrUtil.isNotBlank((CharSequence)channelContext.userid)) {
            Tio.unbindUser((ChannelContext)channelContext);
        }
        return user;
    }

    public static Integer getUid(ChannelContext channelContext) {
        User user = ImUtils.getUser(channelContext);
        if (user == null) {
            return null;
        }
        return user.getId();
    }

    public static User getUser(String token) {
        if (StrUtil.isBlank((CharSequence)token)) {
            return null;
        }
        Integer userid = ImUtils.getUseridByToken(token);
        User user = userService.getById(userid);
        return user;
    }

    public static SimpleUser getSimpleUser(ChannelContext channelContext) {
        return ImUtils.getSimpleUser(channelContext, false);
    }

    public static SimpleUser getSimpleUser(ChannelContext channelContext, boolean force) {
        User user = ImUtils.getUser(channelContext);
        return ImUtils.getSimpleUser(user, channelContext, force);
    }

    public static SimpleUser getSimpleUser(User user, ChannelContext channelContext, boolean force) {
        if (!UserRoleService.checkUserStatus((User)user) && !force) {
            return null;
        }
        SimpleUser simpleUser = null;
        if (user != null) {
            simpleUser = SimpleUser.fromUser((User)user);
            ImUtils.completeSimpleUser(simpleUser, channelContext);
        } else {
            simpleUser = ImUtils.createTourist(channelContext);
        }
        return simpleUser;
    }

    public static SimpleUser createTourist(ChannelContext channelContext) {
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setN("\u6e38\u5ba2" + channelContext.getId());
        ImUtils.completeSimpleUser(simpleUser, channelContext);
        return simpleUser;
    }

    public static void completeSimpleUser(SimpleUser simpleUser, ChannelContext channelContext) {
        ImSessionContext imSessionContext = ImUtils.getImSessionContext(channelContext);
        if (imSessionContext.isWebsocket()) {
            HttpRequest httpRequest = ImUtils.getHandshakeRequest(channelContext);
            String userAgentStr = httpRequest.getUserAgent();
            UserAgent userAgent = UserAgentService.ME.save(userAgentStr);
            simpleUser.setUserAgent(userAgent);
        } else {
            simpleUser.setMobileInfo(ImUtils.getMobileInfo(channelContext));
        }
        String ip = channelContext.getClientNode().getIp();
        IpInfo ipInfo = IpInfoService.ME.save(ip);
        simpleUser.setCid(channelContext.getId());
        simpleUser.setTimeCreated(channelContext.stat.timeCreated);
        simpleUser.setIpInfo(ipInfo);
        simpleUser.setGroupid(imSessionContext.getGroupid());
    }

    public static ImSessionContext getImSessionContext(ChannelContext channelContext) {
        ImSessionContext imSessionContext = (ImSessionContext)channelContext.getAttribute("im_session_key");
        return imSessionContext;
    }

    public static HandshakeReq getHandshakeReq(ChannelContext channelContext) {
        ImSessionContext imSessionContext = ImUtils.getImSessionContext(channelContext);
        HandshakeReq handshakeReq = imSessionContext.getHandshakeReq();
        return handshakeReq;
    }

    public static Devicetype getDevicetype(ChannelContext channelContext) {
        ImSessionContext imSessionContext = ImUtils.getImSessionContext(channelContext);
        if (imSessionContext.isWebsocket()) {
            return Devicetype.PC;
        }
        HandshakeReq handshakeReq = ImUtils.getHandshakeReq(channelContext);
        return Devicetype.from((Byte)handshakeReq.getMobileInfo().getDevicetype());
    }

    public static boolean isIos(ChannelContext channelContext) {
        ImSessionContext imSessionContext = ImUtils.getImSessionContext(channelContext);
        return imSessionContext.isIos();
    }

    public static boolean isAndroid(ChannelContext channelContext) {
        ImSessionContext imSessionContext = ImUtils.getImSessionContext(channelContext);
        return imSessionContext.isAndroid();
    }

    public static MobileInfo getMobileInfo(ChannelContext channelContext) {
        ImSessionContext imSessionContext = ImUtils.getImSessionContext(channelContext);
        if (imSessionContext.isWebsocket()) {
            return null;
        }
        HandshakeReq handshakeReq = ImUtils.getHandshakeReq(channelContext);
        return handshakeReq.getMobileInfo();
    }

    public static HttpRequest getHandshakeRequest(ChannelContext channelContext) {
        ImSessionContext imSessionContext = ImUtils.getImSessionContext(channelContext);
        if (imSessionContext.isWebsocket()) {
            return imSessionContext.getWsSessionContext().getHandshakeRequest();
        }
        return null;
    }

    public static Page<SimpleUser> getPageOfGroup(TioConfig tioConfig, ChannelContext channelContext, String group, Integer pageNumber, Integer pageSize) {
        SimpleUserConverter simpleUserConverter = null;
        ImSessionContext imSessionContext = ImUtils.getImSessionContext(channelContext);
        simpleUserConverter = imSessionContext.isSuper() ? SimpleUserConverter.supper : SimpleUserConverter.me;
        Page x = Tio.getPageOfGroup((TioConfig)tioConfig, (String)group, (Integer)pageNumber, (Integer)pageSize, (Converter)simpleUserConverter);
        return x;
    }

    public static void rebindGroups(ChannelContext channelContext) {
        boolean isModifiedUser = false;
        TioConfig tioConfig = channelContext.tioConfig;
        User user = ImUtils.getUser(channelContext);
        SetWithLock setWithLock = channelContext.getGroups();
        if (setWithLock != null) {
            Set groups = (Set)setWithLock.getObj();
            if (groups != null && groups.size() > 0) {
                HashSet groupsbak = new HashSet(groups.size());
                groupsbak.addAll(groups);
                for (String groupid : groupsbak) {
                    try {
                        tioConfig.groups.unbind(groupid, channelContext, true, false);
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                }
                ImUtils.setHandshakeUser(channelContext, user);
                isModifiedUser = true;
                for (String groupid : groupsbak) {
                    try {
                        tioConfig.groups.bind(groupid, channelContext, false);
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                }
            }
        }
        if (!isModifiedUser) {
            ImUtils.setHandshakeUser(channelContext, user);
        }
    }
}

