/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.cache;

import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.CacheType;
import org.tio.mg.service.init.RedisInit;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.cache.caffeineredis.CaffeineRedisCache;
import org.tio.utils.cache.redis.RedisCache;

public class Caches {
    private static Logger log = LoggerFactory.getLogger(Caches.class);
    private static final String CACHE_PREFIX = "chat_mg_01";
    public static final String SINGLE_KEY = "y";

    public static ICache getCache(CacheConfig cacheConfig) {
        String cacheName = CACHE_PREFIX + cacheConfig.getCacheName();
        CacheType cacheType = cacheConfig.getCacheType();
        RedisCache ret = null;
        if (cacheType == CacheType.REDIS) {
            ret = RedisCache.getCache((String)cacheName);
        } else if (cacheType == CacheType.CAFFEINE_REDIS) {
            ret = CaffeineRedisCache.getCache((String)cacheName);
        } else if (cacheType == CacheType.CAFFEINE) {
            ret = CaffeineCache.getCache((String)cacheName);
        }
        if (ret == null) {
            log.error("cacheName[{}]\u8fd8\u6ca1\u6ce8\u518c", (Object)cacheName);
        }
        return ret;
    }

    public static void init() {
        CacheConfig[] values;
        for (CacheConfig cacheConfig : values = CacheConfig.values()) {
            String cacheName = CACHE_PREFIX + cacheConfig.getCacheName();
            Long timeToLiveSeconds = cacheConfig.getTimeToLiveSeconds();
            Long timeToIdleSeconds = cacheConfig.getTimeToIdleSeconds();
            CacheType cacheType = cacheConfig.getCacheType();
            if (cacheType == CacheType.REDIS) {
                RedisCache.register((RedissonClient)RedisInit.get(), (String)cacheName, (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
                continue;
            }
            if (cacheType == CacheType.CAFFEINE_REDIS) {
                CaffeineRedisCache.register((RedissonClient)RedisInit.get(), (String)cacheName, (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
                continue;
            }
            if (cacheType != CacheType.CAFFEINE) continue;
            CaffeineCache.register((String)cacheName, (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
        }
    }
}

