/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.init;

import cn.hutool.core.util.StrUtil;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.codec.Codec;
import org.redisson.codec.FstCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.ReadMode;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.balancer.LoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.service.MyRandomLoadBalancer;
import org.tio.mg.service.topic.TopicCommonListener;
import org.tio.sitexxx.service.vo.topic.TopicVo;
import org.tio.utils.jfinal.P;

public class RedisInit {
    private static Logger log = LoggerFactory.getLogger(RedisInit.class);
    private static RedissonClient redisson;

    public static void init() {
        RedisInit.init(true);
    }

    public static void init(boolean isFrontend) {
        boolean clusterFlag = isFrontend ? P.getBoolean((String)"redis.cluster.flag", (Boolean)false) : false;
        Config config = new Config();
        if (clusterFlag) {
            String[] clusterAddress = P.get((String)"redis.cluster.address").split(",");
            ClusterServersConfig clusterServersConfig = (ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().setScanInterval(5000).addNodeAddress(clusterAddress).setLoadBalancer((LoadBalancer)new MyRandomLoadBalancer())).setReadMode(ReadMode.MASTER_SLAVE);
            String pwd = P.get((String)"redis.password");
            if (StrUtil.isNotBlank((CharSequence)pwd)) {
                clusterServersConfig.setPassword(pwd);
            }
        } else {
            String address = "redis://" + P.get((String)"redis.ip") + ":" + P.get((String)"redis.port");
            SingleServerConfig singleServerConfig = config.useSingleServer().setAddress(address).setConnectionPoolSize(32).setConnectionMinimumIdleSize(16);
            String pwd = P.get((String)"redis.password");
            if (StrUtil.isNotBlank((CharSequence)pwd)) {
                singleServerConfig.setPassword(pwd);
            }
        }
        config.setCodec((Codec)new FstCodec());
        config.setLockWatchdogTimeout(30000L);
        config.setNettyThreads(0);
        config.setThreads(0);
        redisson = Redisson.create((Config)config);
        if (isFrontend) {
            RTopic topic = redisson.getTopic("COMMON_TOPIC");
            topic.addListener(TopicVo.class, (MessageListener)TopicCommonListener.ME);
        }
    }

    public static RedissonClient get() {
        return redisson;
    }
}

