/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.model.mg.MgInvoice;
import org.tio.mg.service.model.mg.MgInvoiceReimbursement;
import org.tio.mg.service.model.mg.MgReimburseCode;
import org.tio.mg.service.model.mg.MgUser;
import org.tio.mg.service.service.atom.AbsTxAtom;
import org.tio.mg.service.utils.PeriodUtils;
import org.tio.mg.service.utils.RetUtils;
import org.tio.mg.service.vo.InvoiceVo;
import org.tio.mg.service.vo.MgConst;
import org.tio.sitexxx.service.utils.ChineseYuanUtil;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.hutool.ResourceUtil;

public class InvoiceService {
    private static Logger log = LoggerFactory.getLogger(InvoiceService.class);
    public static final InvoiceService me = new InvoiceService();

    public Ret invoiceList(Integer pageNumber, Integer pageSize, Integer mguid, Byte status, Byte paytype, Byte type, Byte developstatus) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.create();
        if (status != null) {
            params.set((Object)"status", (Object)status);
        }
        if (mguid != null) {
            params.set((Object)"mguid", (Object)mguid);
        }
        if (paytype != null) {
            params.set((Object)"paytype", (Object)paytype);
        }
        if (type != null) {
            params.set((Object)"type", (Object)type);
        }
        if (developstatus != null) {
            params.set((Object)"developstatus", (Object)developstatus);
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("invoice.invoicelist", (Map)params);
        Page records = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret userInvoiceList(Integer pageNumber, Integer pageSize, Integer mguid, Byte paytype, Byte type) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.by((Object)"mguid", (Object)mguid);
        if (paytype != null) {
            params.set((Object)"paytype", (Object)paytype);
        }
        if (type != null) {
            params.set((Object)"type", (Object)type);
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("invoice.userinvoicelist", (Map)params);
        Page records = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret total(Integer mguid, Byte status, Byte paytype, Byte type, Byte developstatus) {
        Kv params = Kv.create();
        if (status != null) {
            params.set((Object)"status", (Object)status);
        }
        if (mguid != null) {
            params.set((Object)"mguid", (Object)mguid);
        }
        if (paytype != null) {
            params.set((Object)"paytype", (Object)paytype);
        }
        if (type != null) {
            params.set((Object)"type", (Object)type);
        }
        if (developstatus != null) {
            params.set((Object)"developstatus", (Object)developstatus);
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("invoice.total", (Map)params);
        Double total = Db.use((String)"tio_mg").queryDouble(sqlPara.getSql(), sqlPara.getPara());
        if (total == null || total < 0.0) {
            total = 0.0;
        }
        return RetUtils.okData(total);
    }

    public Ret userTotal(Integer mguid, Byte paytype, Byte type) {
        Kv params = Kv.by((Object)"mguid", (Object)mguid);
        if (paytype != null) {
            params.set((Object)"paytype", (Object)paytype);
        }
        if (type != null) {
            params.set((Object)"type", (Object)type);
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("invoice.usertotal", (Map)params);
        Double total = Db.use((String)"tio_mg").queryDouble(sqlPara.getSql(), sqlPara.getPara());
        if (total == null || total < 0.0) {
            total = 0.0;
        }
        return RetUtils.okData(total);
    }

    public Ret users() {
        String sql = "select iuser.mguid,u.nick from (select DISTINCT mguid from mg_invoice ) as iuser INNER JOIN mg_user u on iuser.mguid = u.id";
        return RetUtils.okList(Db.use((String)"tio_mg").find(sql));
    }

    public Ret add(MgInvoice invoice) {
        return RetUtils.saveRet(invoice);
    }

    public Ret addReimburse(final MgInvoiceReimbursement reimbursement, String ids) {
        if (reimbursement == null) {
            return RetUtils.invalidParam();
        }
        boolean onlyAdd = false;
        List invoices = null;
        if (StrUtil.isBlank((CharSequence)ids)) {
            onlyAdd = true;
        } else {
            invoices = MgInvoice.dao.find("select * from mg_invoice where id in (" + ids + ")");
            if (CollectionUtil.isEmpty((Collection)invoices)) {
                onlyAdd = true;
            }
        }
        if (onlyAdd) {
            if (StrUtil.isBlank((CharSequence)reimbursement.getCode())) {
                MgReimburseCode code = this.getCode(false);
                if (code == null) {
                    return RetUtils.sysError();
                }
                if (Objects.equals(code.getStatus(), (byte)1)) {
                    reimbursement.setCode(code.getCode());
                    return RetUtils.saveRet(reimbursement);
                }
                reimbursement.setCodeid(code.getId());
            }
            if (reimbursement.getCodeid() == null) {
                return RetUtils.failMsg("\u5206\u914d\u7684codeid\u4e0d\u5b58\u5728");
            }
            MgReimburseCode codeVo = (MgReimburseCode)MgReimburseCode.dao.findById(reimbursement.getCodeid());
            if (codeVo == null) {
                return RetUtils.failMsg("\u5206\u914dcodevo\u4e0d\u5b58\u5728");
            }
            AbsTxAtom onlyTx = new AbsTxAtom(){

                @Override
                public boolean noTxRun() {
                    boolean save = reimbursement.save();
                    if (!save) {
                        return this.failRet("\u62a5\u9500\u5355\u4fdd\u5b58\u5931\u8d25");
                    }
                    MgReimburseCode updateCode = new MgReimburseCode();
                    updateCode.setId(reimbursement.getCodeid());
                    updateCode.setStatus((byte)1);
                    if (!updateCode.update()) {
                        return this.failRet("code\u5206\u914d\u4fee\u6539\u5f02\u5e38");
                    }
                    return true;
                }
            };
            boolean tx = Db.use((String)"tio_mg").tx((IAtom)onlyTx);
            if (!tx) {
                return onlyTx.getRetObj();
            }
            return RetUtils.okOper();
        }
        final List finalinvoices = invoices;
        AbsTxAtom absTxAtom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                if (StrUtil.isBlank((CharSequence)reimbursement.getCode())) {
                    MgReimburseCode code = InvoiceService.this.getCode(false);
                    if (code == null) {
                        return this.failRet("\u53d1\u7968\u62a5\u9500\u53f7\u751f\u6210\u5931\u8d25");
                    }
                    reimbursement.setCode(code.getCode());
                } else {
                    if (reimbursement.getCodeid() == null) {
                        return this.failRet("\u5206\u914d\u7684codeid\u4e0d\u5b58\u5728");
                    }
                    MgReimburseCode codeVo = (MgReimburseCode)MgReimburseCode.dao.findById(reimbursement.getCodeid());
                    if (codeVo == null) {
                        return this.failRet("\u5206\u914dcodevo\u4e0d\u5b58\u5728");
                    }
                    MgReimburseCode updateCode = new MgReimburseCode();
                    updateCode.setId(reimbursement.getCodeid());
                    updateCode.setStatus((byte)1);
                    if (!updateCode.update()) {
                        return this.failRet("code\u5206\u914d\u4fee\u6539\u5f02\u5e38");
                    }
                }
                double amount = 0.0;
                short num = 0;
                for (MgInvoice invoice : finalinvoices) {
                    if (StrUtil.isNotBlank((CharSequence)invoice.getRcode())) {
                        log.error("\u9009\u62e9\u7684\u53d1\u7968\u5df2\u8fdb\u884c\u62a5\u9500\u5904\u7406");
                        return this.failRet("\u9009\u62e9\u7684\u53d1\u7968\u5df2\u8fdb\u884c\u62a5\u9500\u5904\u7406");
                    }
                    amount += invoice.getAmount().doubleValue();
                    num = (short)(num + 1);
                    MgInvoice update = new MgInvoice();
                    update.setId(invoice.getId());
                    update.setRcode(reimbursement.getCode());
                    if (update.update()) continue;
                    return this.failRet("\u53d1\u7968\u62a5\u9500\u53f7\u6dfb\u52a0\u5931\u8d25");
                }
                reimbursement.setAmount(amount);
                reimbursement.setNum(num);
                if (!reimbursement.save()) {
                    return this.failRet("\u62a5\u9500\u5355\u4fdd\u5b58\u5931\u8d25");
                }
                return true;
            }
        };
        boolean tx = Db.use((String)"tio_mg").tx((IAtom)absTxAtom);
        if (!tx) {
            return absTxAtom.getRetObj();
        }
        return RetUtils.okOper();
    }

    public Ret updateReimburse(final MgInvoiceReimbursement reimbursement, String ids, Integer mguid) {
        if (reimbursement == null || reimbursement.getId() == null) {
            return RetUtils.invalidParam();
        }
        final MgInvoiceReimbursement oldReimbursement = (MgInvoiceReimbursement)MgInvoiceReimbursement.dao.findById(reimbursement.getId());
        if (oldReimbursement == null || Objects.equals(oldReimbursement.getStatus(), (byte)3)) {
            return RetUtils.failMsg("\u62a5\u9500\u5355\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(oldReimbursement.getUploadstatus(), (byte)1) && StrUtil.isNotBlank((CharSequence)ids)) {
            return RetUtils.failMsg("\u62a5\u9500\u5355\u5df2\u4e0b\u8f7d\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c");
        }
        boolean onlyUpdate = false;
        List mgInvoices = null;
        if (StrUtil.isBlank((CharSequence)ids)) {
            onlyUpdate = true;
        } else {
            mgInvoices = MgInvoice.dao.find("select * from mg_invoice where id in (" + ids + ")");
            if (CollectionUtil.isEmpty((Collection)mgInvoices)) {
                onlyUpdate = true;
            }
        }
        if (onlyUpdate) {
            return RetUtils.upateRet(reimbursement);
        }
        final List invoices = mgInvoices;
        final List<MgInvoice> exist = this.invoiceReimburseList(oldReimbursement.getCode());
        AbsTxAtom absTxAtom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                HashMap<String, Integer> existInvoice = new HashMap<String, Integer>();
                double amount = 0.0;
                short num = 0;
                for (MgInvoice invoice : exist) {
                    amount += invoice.getAmount().doubleValue();
                    num = (short)(num + 1);
                    existInvoice.put(invoice.getId() + "", invoice.getId());
                }
                for (MgInvoice invoice : invoices) {
                    if (StrUtil.isNotBlank((CharSequence)invoice.getRcode())) {
                        log.error("\u9009\u62e9\u7684\u53d1\u7968\u5df2\u8fdb\u884c\u62a5\u9500\u5904\u7406");
                        return this.failRet("\u9009\u62e9\u7684\u53d1\u7968\u5df2\u8fdb\u884c\u62a5\u9500\u5904\u7406");
                    }
                    if (existInvoice.get(invoice.getId() + "") != null) {
                        return this.failRet("\u53d1\u7968:" + invoice.getId() + "\u5df2\u518d\u62a5\u9500\u5355\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u9009\u62e9");
                    }
                    amount += invoice.getAmount().doubleValue();
                    num = (short)(num + 1);
                    MgInvoice update = new MgInvoice();
                    update.setId(invoice.getId());
                    update.setRcode(oldReimbursement.getCode());
                    if (update.update()) continue;
                    return this.failRet("\u53d1\u7968\u62a5\u9500\u53f7\u6dfb\u52a0\u5931\u8d25");
                }
                reimbursement.setAmount(amount);
                reimbursement.setNum(num);
                if (!reimbursement.update()) {
                    return this.failRet("\u62a5\u9500\u5355\u4fee\u6539\u5931\u8d25");
                }
                return true;
            }
        };
        boolean tx = Db.use((String)"tio_mg").tx((IAtom)absTxAtom);
        if (!tx) {
            return absTxAtom.getRetObj();
        }
        return RetUtils.okOper();
    }

    public Ret upload(Integer rid, Integer operuid) {
        if (rid == null) {
            return RetUtils.invalidParam();
        }
        MgInvoiceReimbursement reimbursement = (MgInvoiceReimbursement)MgInvoiceReimbursement.dao.findById(rid);
        if (reimbursement == null) {
            return RetUtils.failMsg("\u62a5\u9500\u5355\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(reimbursement.getUploadstatus(), (byte)1)) {
            return RetUtils.failMsg("\u62a5\u9500\u5355\u5df2\u4e0b\u8f7d\uff0c\u65e0\u6cd5\u8fdb\u884c\u91cd\u65b0\u751f\u6210\u903b\u8f91");
        }
        List<MgInvoice> invoices = this.invoiceReimburseList(reimbursement.getCode());
        if (CollectionUtil.isEmpty(invoices)) {
            return RetUtils.failMsg("\u62a5\u9500\u53d1\u7968\u5217\u8868\u4e3a\u7a7a");
        }
        MgUser user = (MgUser)MgUser.dao.findById(reimbursement.getMguid());
        if (user == null) {
            return RetUtils.failMsg("\u62a5\u9500\u4eba\u4e3a\u7a7a");
        }
        double amount = 0.0;
        ArrayList<File> zipFiles = new ArrayList<File>();
        String filename = "\u62a5\u9500\u5355" + reimbursement.getCode() + "_" + user.getNick() + reimbursement.getAmount() + "\u5143.xlsx";
        String resRootDir = Const.RES_ROOT;
        String path = "mg/reimbursement/" + user.getNick() + "/";
        File dir = new File(resRootDir, path);
        FileUtil.mkdir((File)dir);
        String copyPath = path + "/copy/";
        File copydir = new File(resRootDir, copyPath);
        FileUtil.mkdir((File)copydir);
        FileUtil.clean((File)copydir);
        String fullExcleName = resRootDir + "/" + path + filename;
        FileUtil.del((String)fullExcleName);
        ArrayList<InvoiceVo> rows = new ArrayList<InvoiceVo>();
        HashMap<String, String> nameExist = new HashMap<String, String>();
        for (MgInvoice invoice : invoices) {
            amount += invoice.getAmount().doubleValue();
            String name = invoice.getName();
            boolean isExist = false;
            if (nameExist.get(name) != null) {
                name = name + "_" + invoice.getId();
                isExist = true;
            } else {
                nameExist.put(name, name);
            }
            InvoiceVo invoiceVo = new InvoiceVo();
            invoiceVo.setPeriod(DateUtil.format((Date)invoice.getTime(), (String)"yyyy.MM.dd"));
            invoiceVo.setName(name);
            invoiceVo.setNum(1);
            invoiceVo.setAmount(invoice.getAmount());
            invoiceVo.setRemark(invoice.getCosttype());
            invoiceVo.setNick("");
            if (isExist) {
                String existPath = path + "/copy/" + invoice.getId() + "/";
                File existDir = new File(resRootDir, existPath);
                FileUtil.mkdir((File)existDir);
                FileUtil.clean((File)existDir);
                zipFiles.add(FileUtil.copy((String)(resRootDir + "/" + invoice.getFileurl()), (String)(resRootDir + "/" + existPath + "/" + reimbursement.getCode() + "_" + name + "." + FileUtil.extName((String)invoice.getFileurl())), (boolean)false));
            } else {
                zipFiles.add(FileUtil.copy((String)(resRootDir + "/" + invoice.getFileurl()), (String)(resRootDir + "/" + copyPath + "/" + reimbursement.getCode() + "_" + name + "." + FileUtil.extName((String)invoice.getFileurl())), (boolean)false));
            }
            rows.add(invoiceVo);
        }
        File excleFile = FileUtil.file((String)fullExcleName);
        this.uploadExcel(rows, reimbursement.getAmount(), user.getNick(), excleFile, reimbursement.getCode() + "\u62a5\u9500\u5355");
        zipFiles.add(excleFile);
        String zipPath = path + "/zip/";
        File zipdir = new File(resRootDir, zipPath);
        FileUtil.mkdir((File)zipdir);
        String zipFileName = "\u62a5\u9500\u5355_" + reimbursement.getCode() + "_" + user.getNick() + "\uffe5" + reimbursement.getAmount();
        zipFileName = zipFileName + ".zip";
        String zipUrl = zipPath + zipFileName;
        FileUtil.del((String)(resRootDir + "/" + zipUrl));
        File file = FileUtil.file((String)resRootDir, (String)zipUrl);
        File[] files = new File[zipFiles.size()];
        zipFiles.toArray(files);
        ZipUtil.zip((File)file, (boolean)false, (File[])files);
        org.tio.mg.service.model.main.File dbFile = new org.tio.mg.service.model.main.File();
        dbFile.setExt("zip");
        dbFile.setFilename(zipFileName);
        dbFile.setSize(file.length());
        dbFile.setUid(operuid);
        dbFile.setUrl(zipUrl);
        dbFile.save();
        MgInvoiceReimbursement update = new MgInvoiceReimbursement();
        update.setId(rid);
        update.setUploadstatus((byte)1);
        update.setFileurl(dbFile.getUrl());
        update.update();
        return RetUtils.okData((Object)dbFile);
    }

    public Ret delreimburseinvoice(final Integer id, final Integer rid) {
        if (rid == null || id == null) {
            return RetUtils.invalidParam();
        }
        MgInvoiceReimbursement old = (MgInvoiceReimbursement)MgInvoiceReimbursement.dao.findById(rid);
        if (old == null || Objects.equals(old.getStatus(), (byte)3)) {
            return RetUtils.failMsg("\u62a5\u9500\u5355\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(old.getUploadstatus(), (byte)1)) {
            return RetUtils.failMsg("\u62a5\u9500\u5355\u5df2\u4e0b\u8f7d\uff0c\u65e0\u6548\u5220\u9664\u53d1\u7968");
        }
        final MgInvoice invoice = (MgInvoice)MgInvoice.dao.findById(id);
        if (invoice == null) {
            return RetUtils.failMsg("\u53d1\u7968\u4e0d\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)invoice.getRcode())) {
            return RetUtils.failMsg("\u53d1\u7968\u672a\u5173\u8054\u62a5\u9500\u5355");
        }
        AbsTxAtom absTxAtom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                MgInvoice invoiceUpdate = new MgInvoice();
                invoiceUpdate.setRcode("");
                invoiceUpdate.setId(id);
                if (!invoiceUpdate.update()) {
                    return this.failRet("\u91ca\u653e\u53d1\u7968\u5931\u8d25");
                }
                int count = Db.use((String)"tio_mg").update("update mg_invoice_reimbursement set amount = amount - ?,num = num - 1 where id = ?", new Object[]{invoice.getAmount(), rid});
                if (count <= 0) {
                    return this.failRet("\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
                }
                return true;
            }
        };
        boolean tx = Db.use((String)"tio_mg").tx((IAtom)absTxAtom);
        if (!tx) {
            return absTxAtom.getRetObj();
        }
        return RetUtils.okOper();
    }

    public Ret delreimburse(final Integer rid, Integer operuid) {
        if (rid == null) {
            return RetUtils.invalidParam();
        }
        final MgInvoiceReimbursement old = (MgInvoiceReimbursement)MgInvoiceReimbursement.dao.findById(rid);
        if (old == null || Objects.equals(old.getStatus(), (byte)3)) {
            return RetUtils.failMsg("\u62a5\u9500\u5355\u4e0d\u5b58\u5728");
        }
        AbsTxAtom absTxAtom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                Db.use((String)"tio_mg").update("update mg_invoice set rcode = '' where rcode = ?", new Object[]{old.getCode()});
                MgInvoiceReimbursement update = new MgInvoiceReimbursement();
                update.setStatus((byte)3);
                update.setId(rid);
                if (!update.update()) {
                    return this.failRet("\u5220\u9664\u62a5\u9500\u5355\u5931\u8d25");
                }
                return true;
            }
        };
        boolean tx = Db.use((String)"tio_mg").tx((IAtom)absTxAtom);
        if (!tx) {
            return absTxAtom.getRetObj();
        }
        return RetUtils.okOper();
    }

    public Ret reimburseInfo(String code) {
        if (StrUtil.isBlank((CharSequence)code)) {
            return RetUtils.invalidParam();
        }
        Kv params = Kv.by((Object)"code", (Object)code);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("invoice.reimburseInfo", (Map)params);
        Record record = Db.use((String)"tio_mg").findFirst(sqlPara);
        if (record == null) {
            return RetUtils.noExistParam();
        }
        return RetUtils.okData(record);
    }

    public MgReimburseCode getCode(boolean isinit) {
        String period = PeriodUtils.dateToPeriodByType(new Date(), (byte)1);
        Db.use((String)"tio_mg").update("delete from mg_reimburse_code where `code` < ?", new Object[]{period});
        MgReimburseCode code = (MgReimburseCode)MgReimburseCode.dao.findFirst("select * from mg_reimburse_code order by id desc");
        if (code != null && Objects.equals(code.getStatus(), (byte)2)) {
            return code;
        }
        if (code == null) {
            code = new MgReimburseCode();
            code.setCode(period + "01");
            code.setIndex(1);
            if (isinit) {
                code.setStatus((byte)2);
            } else {
                code.setStatus((byte)1);
            }
            code.save();
            return code;
        }
        MgReimburseCode newcode = new MgReimburseCode();
        int index = code.getIndex() + 1;
        if (index > 9) {
            newcode.setCode(period + index);
        } else {
            newcode.setCode(period + "0" + index);
        }
        newcode.setIndex(index);
        if (isinit) {
            newcode.setStatus((byte)2);
        } else {
            newcode.setStatus((byte)1);
        }
        newcode.save();
        return newcode;
    }

    public Ret setCode(Integer id) {
        if (id == null) {
            return RetUtils.noExistParam();
        }
        MgReimburseCode code = (MgReimburseCode)MgReimburseCode.dao.findById(id);
        if (code == null || Objects.equals(code.getStatus(), (byte)1)) {
            return RetUtils.failMsg("\u53d1\u7968\u5355\u53f7\u5f02\u5e38");
        }
        MgReimburseCode update = new MgReimburseCode();
        update.setId(id);
        update.setStatus((byte)1);
        return RetUtils.upateRet(update);
    }

    public Ret reimburseList(Integer pageNumber, Integer pageSize, String code) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.by((Object)"status", (Object)3);
        if (StrUtil.isNotBlank((CharSequence)code)) {
            params.set((Object)"code", (Object)("%" + code + "%"));
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("invoice.reimburseList", (Map)params);
        Page records = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret invoiceOutReimburseList(Integer pageNumber, Integer pageSize, Integer mguid, String starttime, String endtime) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.by((Object)"developstatus", (Object)2);
        if (mguid != null) {
            params.set((Object)"mguid", (Object)mguid);
        }
        if (StrUtil.isNotBlank((CharSequence)starttime)) {
            params.set((Object)"starttime", (Object)starttime);
        }
        if (StrUtil.isNotBlank((CharSequence)endtime)) {
            params.set((Object)"endtime", (Object)endtime);
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("invoice.invoiceOutReimburseList", (Map)params);
        Page records = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public List<MgInvoice> invoiceReimburseList(String code) {
        Kv params = Kv.by((Object)"code", (Object)code);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("invoice.invoiceReimburseList", (Map)params);
        List mgInvoices = MgInvoice.dao.find(sqlPara);
        return mgInvoices;
    }

    public List<Record> reimburseDict() {
        List mgInvoices = Db.use((String)"tio_mg").find("select mir.id,mir.code,u.nick,u.id mguid from mg_invoice_reimbursement mir inner join mg_user u on u.id = mir.mguid where mir.uploadstatus = ? and mir.status != 3", new Object[]{(byte)2});
        return mgInvoices;
    }

    public Ret invoiceReimburseList(Integer pageNumber, Integer pageSize, String code) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.by((Object)"code", (Object)code);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("invoice.invoiceReimburseList", (Map)params);
        Page records = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret update(MgInvoice invoice) {
        if (invoice.getId() == null) {
            return RetUtils.invalidParam();
        }
        MgInvoice old = (MgInvoice)MgInvoice.dao.findById(invoice.getId());
        if (old == null) {
            return RetUtils.failMsg("\u8be5\u53d1\u7968\u4e0d\u5b58\u5728\u65e0\u6cd5\u66f4\u6539");
        }
        if (Objects.equals(old.getStatus(), (byte)1)) {
            return RetUtils.failMsg("\u8be5\u53d1\u7968\u5df2\u6807\u8bb0\uff0c\u65e0\u6cd5\u66f4\u6539");
        }
        return RetUtils.upateRet(invoice);
    }

    public Ret updateRemark(MgInvoice invoice) {
        if (invoice.getId() == null) {
            return RetUtils.invalidParam();
        }
        MgInvoice old = (MgInvoice)MgInvoice.dao.findById(invoice.getId());
        if (old == null) {
            return RetUtils.failMsg("\u8be5\u53d1\u7968\u4e0d\u5b58\u5728\u65e0\u6cd5\u66f4\u6539");
        }
        if (StrUtil.isBlank((CharSequence)invoice.getRemark())) {
            invoice.setRemark("");
        }
        return RetUtils.upateRet(invoice);
    }

    public Ret update(Integer id, Byte status, Byte develop, String devlopcode) {
        if (id == null) {
            return RetUtils.invalidParam();
        }
        MgInvoice invoice = (MgInvoice)MgInvoice.dao.findById(id);
        if (invoice == null) {
            return RetUtils.failMsg("\u53d1\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MgInvoice update = new MgInvoice();
        update.setId(id);
        if (status != null) {
            update.setStatus(status);
        }
        if (develop != null) {
            update.setDevelopstatus(develop);
            if (StrUtil.isNotBlank((CharSequence)devlopcode)) {
                update.setDevelopcode(devlopcode);
            } else {
                update.setDevelopcode("");
            }
        }
        return RetUtils.upateRet(update);
    }

    public Ret batchupdate(String ids, Byte status) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return RetUtils.invalidParam();
        }
        int count = Db.use((String)"tio_mg").update("update mg_invoice set `status` = ? where id in (" + ids + ") ", new Object[]{status});
        return RetUtils.okData(count);
    }

    public Ret uploadExcel(List<InvoiceVo> invoices, double total, String nick, File destFile, String sheetname) {
        File excelTemplate = new File(ResourceUtil.getAbsolutePath((String)MgConst.INVOICE_EXCEL_TEMPLATE));
        ExcelReader reader = ExcelUtil.getReader((File)excelTemplate);
        ExcelWriter writer = reader.getWriter();
        Workbook wrok = reader.getWorkbook();
        XSSFSheet sheet = (XSSFSheet)wrok.cloneSheet(0);
        wrok.setSheetName(1, sheetname);
        int insert = invoices.size() - 1;
        int next = 4 + insert;
        XSSFRow row = null;
        if (insert > 0) {
            sheet.shiftRows(4, 4 + invoices.size(), insert, true, false);
            row = sheet.getRow(next);
            for (int i = 0; i < insert; ++i) {
                XSSFRow creRow = sheet.createRow(4 + i);
                InvoiceService.setcell(creRow, row, 0, invoices.get(i).getPeriod());
                InvoiceService.setcell(creRow, row, 1, invoices.get(i).getRemark());
                InvoiceService.setcell(creRow, row, 2, invoices.get(i).getName());
                InvoiceService.setcell(creRow, row, 3, 1.0);
                InvoiceService.setcell(creRow, row, 4, invoices.get(i).getAmount());
            }
        } else {
            row = sheet.getRow(next);
        }
        row.getCell(0).setCellValue(invoices.get(invoices.size() - 1).getPeriod());
        row.getCell(1).setCellValue(invoices.get(invoices.size() - 1).getRemark());
        row.getCell(2).setCellValue(invoices.get(invoices.size() - 1).getName());
        row.getCell(3).setCellValue(1.0);
        row.getCell(4).setCellValue(invoices.get(invoices.size() - 1).getAmount().doubleValue());
        XSSFRow update = sheet.getRow(invoices.size() + 4);
        update.getCell(0).setCellValue("\u603b\u91d1\u989d\uff08\u5927\u5199\uff09\uff1a\u4eba\u6c11\u5e01" + ChineseYuanUtil.convert((String)(total + "")) + "\u6574");
        update.getCell(4).setCellValue(total);
        XSSFRow userRow = sheet.getRow(invoices.size() + 4 + 1);
        userRow.getCell(0).setCellValue("\u62a5\u9500\u4eba\uff1a" + nick);
        wrok.removeSheetAt(0);
        writer.flush(destFile);
        return RetUtils.okOper();
    }

    private static void setcell(XSSFRow creRow, XSSFRow row, int index, String value) {
        XSSFCell cell = row.getCell(index);
        CellType type = cell.getCellType();
        XSSFCell cell1 = creRow.createCell(index, type);
        cell1.setCellStyle((CellStyle)cell.getCellStyle());
        cell1.setCellValue(value);
    }

    private static void setcell(XSSFRow creRow, XSSFRow row, int index, double value) {
        XSSFCell cell = row.getCell(index);
        CellType type = cell.getCellType();
        XSSFCell cell1 = creRow.createCell(index, type);
        cell1.setCellStyle((CellStyle)cell.getCellStyle());
        cell1.setCellValue(value);
    }
}

