/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.atom;

import cn.hutool.core.util.NumberUtil;
import java.sql.SQLException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.model.main.RechargeItem;
import org.tio.mg.service.model.main.UserCoinItem;
import org.tio.mg.service.service.UserCoinService;
import org.tio.mg.service.service.atom.AbsAtom;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.service.service.recharge.RechargeItemService;

public class RechargeAtom
extends AbsAtom {
    private static Logger log = LoggerFactory.getLogger(RechargeAtom.class);
    private RechargeItem rechargeItem;

    public RechargeAtom(RechargeItem rechargeItem) {
        this.rechargeItem = rechargeItem;
    }

    public boolean run() throws SQLException {
        Double amount = this.rechargeItem.getAmount();
        Integer uid = this.rechargeItem.getUserid();
        Double addCoin = 0.0;
        addCoin = Objects.equals(this.rechargeItem.getPaytype(), RechargeItem.Paytype.APPLE_APP) ? new Double(NumberUtil.mul((double)amount, (float)MgConfService.getFloat("cny.to.coin.time.ios", Float.valueOf(70.0f)).floatValue())) : new Double(NumberUtil.mul((double)amount, (float)MgConfService.getFloat("cny.to.coin.time.pc", Float.valueOf(100.0f)).floatValue()));
        boolean isupdate = UserCoinService.me.addCoin(uid, addCoin);
        if (!isupdate) {
            this.msg = "\u66f4\u65b0\u5145\u503c\u6e05\u5355\u5f02\u5e38-\u5145\u503c";
            log.error("\u66f4\u65b0\u5145\u503c\u6e05\u5355\u5f02\u5e38-\u5145\u503c\uff01uid:{},rechargeId:{}", (Object)uid, (Object)this.rechargeItem.getId());
            return false;
        }
        RechargeItemService.me.update(this.rechargeItem);
        UserCoinItem userCoinItem = new UserCoinItem();
        userCoinItem.setCoin(addCoin);
        userCoinItem.setBizid(this.rechargeItem.getId());
        userCoinItem.setCoinmode((byte)1);
        userCoinItem.setUid(uid);
        userCoinItem.setRemark("\u5145\u503c");
        if (Objects.equals(this.rechargeItem.getPaytype(), RechargeItem.Paytype.APPLE_APP)) {
            userCoinItem.setAddexp(new Double(NumberUtil.mul((double)amount, (float)MgConfService.getFloat("cny.to.coin.exp.time.ios", Float.valueOf(50.0f)).floatValue())));
        } else {
            userCoinItem.setAddexp(new Double(NumberUtil.mul((double)amount, (float)MgConfService.getFloat("cny.to.coin.exp.time.st", Float.valueOf(50.0f)).floatValue())));
        }
        userCoinItem.setCoinflag((byte)1);
        userCoinItem.setType((byte)1);
        boolean isAdd = userCoinItem.save();
        if (!isAdd) {
            this.msg = "\u65b0\u589e\u7528\u6237\u5145\u503c\u8bb0\u5f55\u5931\u8d25-\u5145\u503c";
            log.error("\u65b0\u589e\u7528\u6237\u5145\u503c\u8bb0\u5f55\u5931\u8d25-\u5145\u503c\uff01uid:{},rechargeId:{}", (Object)uid, (Object)this.rechargeItem.getId());
            return false;
        }
        return isAdd;
    }
}

