/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.base;

import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.kit.StrKit;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.conf.EmailServer;
import org.tio.mg.service.model.main.EmailSendLog;
import org.tio.mg.service.model.main.User;
import org.tio.mg.service.model.main.UserBase;
import org.tio.mg.service.model.main.UserCoin;
import org.tio.mg.service.model.main.UserRole;
import org.tio.mg.service.service.atom.RegisterAtom;
import org.tio.mg.service.service.base.UserService;
import org.tio.mg.service.service.chat.FriendService;
import org.tio.mg.service.service.conf.AvatarService;
import org.tio.mg.service.service.conf.EmailServerService;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.service.utils.CommonUtils;
import org.tio.mg.service.utils.EmailKit;
import org.tio.mg.service.utils.RetUtils;
import org.tio.mg.service.vo.RequestExt;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.cache.ICache;
import org.tio.utils.resp.Resp;

public class RegisterService {
    private static Logger log = LoggerFactory.getLogger(RegisterService.class);
    public static final RegisterService me = new RegisterService();
    public static final UserService userService = UserService.ME;
    final User userDao = (User)new User().dao();
    public ICache emailAuthCodeCache = Caches.getCache(CacheConfig.EMAIL_AUTHCODE);

    private RegisterService() {
    }

    public boolean isNickExists(String nick) {
        nick = nick.toLowerCase().trim();
        return Db.use((String)"tio_site_main").queryInt("select id from user where nick = ? limit 1", new Object[]{nick}) != null;
    }

    public Resp innerEmailRegister(User user, boolean needCheck) throws Exception {
        Resp resp = null;
        if (needCheck) {
            user.setAgreement("true");
            resp = this.regCheckAndSet(user, 1);
        } else {
            resp = Resp.ok();
        }
        if (resp.isOk()) {
            RegisterAtom registerUserAtom = new RegisterAtom(user);
            boolean relsut = Db.tx((IAtom)registerUserAtom);
            if (relsut) {
                userService.notifyClearCache(user.getId());
                return Resp.ok((Object)registerUserAtom.getMsg()).data((Object)Kv.by((Object)"loginname", (Object)user.getLoginname()).set((Object)"id", (Object)user.getId()).set((Object)"user", (Object)user));
            }
            return Resp.fail((String)registerUserAtom.getMsg());
        }
        return resp;
    }

    public Resp activate(String authCode) throws Exception {
        User user = (User)((Object)this.emailAuthCodeCache.get(authCode));
        if (user != null) {
            this.emailAuthCodeCache.remove(authCode);
            return this.innerEmailRegister(user, false);
        }
        return Resp.fail((String)"\u6fc0\u6d3b\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u5931\u6548\u6216\u5df2\u7ecf\u6fc0\u6d3b\u8fc7\u4e86");
    }

    public boolean isLoginnameExists(String loginname) {
        User user = userService.getByLoginname(loginname = loginname.trim(), null);
        return user != null;
    }

    public Resp retrievePwd(String loginname, String clientIp, String sessionid, RequestExt requestExt) throws Exception {
        User user = UserService.ME.getByLoginname(loginname, (byte)1);
        if (user == null) {
            return Resp.fail((String)"\u5e10\u53f7\u4e0d\u5b58\u5728");
        }
        String authCode = StrKit.getRandomUUID();
        this.emailAuthCodeCache.put(authCode, (Serializable)((Object)loginname));
        String title = "t-io\u5b98\u7f51\u5bc6\u7801\u627e\u56de";
        String url = Const.SITE + "/user/forget/setNewPwd.html?authCode=" + URLEncoder.encode(authCode, "utf-8") + "&loginname=" + URLEncoder.encode(loginname, "utf-8");
        String content = "\u70b9\u51fb\u8bbe\u7f6e\u65b0\u5bc6\u7801\uff1a<a href='" + url + "'>" + url + "</a>";
        boolean f = this.sendAuthEmail((byte)2, title, content, authCode, loginname, clientIp, sessionid, requestExt);
        if (f) {
            return Resp.ok().msg("\u91cd\u7f6e\u5bc6\u7801\u94fe\u63a5\u5df2\u7ecf\u53d1\u5230\u90ae\u7bb1" + loginname + "\uff0c\u6709\u6548\u65f6\u95f4\u4e3a" + this.emailAuthCodeCache.getTimeToLiveSeconds() / 60L + "\u5206\u949f\uff08\u90ae\u4ef6\u53ef\u80fd\u5728\u60a8\u7684\u5783\u573e\u90ae\u7bb1\uff09");
        }
        this.emailAuthCodeCache.remove(authCode);
        return Resp.fail((String)"\u90ae\u4ef6\u53d1\u9001\u4e0d\u6210\u529f");
    }

    public Resp setNewPwd(String authCode, String newpwd) {
        String loginname = (String)((Object)this.emailAuthCodeCache.get(authCode));
        if (StrUtil.isBlank((CharSequence)loginname)) {
            return Resp.fail((String)"\u4fee\u6539\u5bc6\u7801\u7684\u6388\u6743\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u5931\u6548");
        }
        this.emailAuthCodeCache.remove(authCode);
        String encodedPwd = newpwd;
        String sql = "update user set pwd=? where loginname = ?";
        int r = Db.use((String)"tio_site_main").update(sql, new Object[]{encodedPwd, loginname});
        if (r == 1) {
            User user = UserService.ME.getByLoginname(loginname, (byte)1);
            if (user != null) {
                UserService.ME.notifyClearCache(user.getId());
                Kv kv = Kv.by((Object)"loginname", (Object)loginname).set((Object)"pwd", (Object)newpwd);
                return Resp.ok((Object)kv);
            }
            return Resp.fail((String)"\u5bc6\u7801\u4fee\u6539\u5931\u8d25\uff08\u627e\u4e0d\u5230\u7528\u6237\uff09");
        }
        return Resp.fail((String)"\u5bc6\u7801\u4fee\u6539\u5931\u8d25");
    }

    public Resp emailRegister(User user, String clientIp, String sessionid, RequestExt requestExt) throws Exception {
        Resp resp = this.regCheckAndSet(user, 1);
        if (resp.isOk()) {
            String authCode = StrKit.getRandomUUID();
            this.emailAuthCodeCache.put(authCode, (Serializable)((Object)user));
            String title = "t-io\u793e\u533a\u7528\u6237[" + user.getNick() + "]\u6fc0\u6d3b\u90ae\u4ef6";
            String url = Const.SITE + "/email/index.html?authCode=" + URLEncoder.encode(authCode, "utf-8");
            String content = "<div>\u4eb2\u7231\u7684" + user.getNick() + "\uff0c\u6b22\u8fce\u6210\u4e3at-io\u5bb6\u5ead\u7b2c<span style='color:#FF5722;font-weight: bold; padding: 2px 5px;'>" + (UserService.ME.getUserCount() + 1) + "</span>\u4f4d\u6210\u5458\uff1a";
            content = content + "<span style='color:#FF5722; font-weight: bold; font-size:16px;'><a style='text-decoration:none' href='" + url + "' target='_blank'>\u70b9\u51fb\u6fc0\u6d3b</a></span></div>";
            boolean f = this.sendAuthEmail((byte)1, title, content, authCode, user.getLoginname(), clientIp, sessionid, requestExt);
            if (f) {
                return Resp.ok().msg("\u6ce8\u518c\u7533\u8bf7\u6210\u529f\uff0c\u6fc0\u6d3b\u94fe\u63a5\u5df2\u53d1\u9001\u5230\u60a8\u7684\u6ce8\u518c\u90ae\u7bb1" + user.getLoginname() + "\uff0c\u6709\u6548\u65f6\u95f4\u4e3a" + this.emailAuthCodeCache.getTimeToLiveSeconds() / 60L + "\u5206\u949f\uff08\u90ae\u4ef6\u53ef\u80fd\u5728\u60a8\u7684\u5783\u573e\u90ae\u7bb1\uff09");
            }
            this.emailAuthCodeCache.remove(authCode);
            return Resp.fail((String)"\u6fc0\u6d3b\u90ae\u4ef6\u53d1\u9001\u4e0d\u6210\u529f\uff0c\u6ce8\u518c\u5931\u8d25");
        }
        return resp;
    }

    public Resp regCheckAndSet(User user, int regType) throws Exception {
        String loginname = StrUtil.trim((CharSequence)user.getLoginname());
        String pwd = StrUtil.trim((CharSequence)user.getPwd());
        String nick = StrUtil.trim((CharSequence)user.getNick());
        if (StrKit.isBlank((String)user.getAgreement())) {
            return Resp.fail((String)"\u60a8\u5fc5\u987b [\u540c\u610f\u7528\u6237\u670d\u52a1\u6761\u6b3e] \u624d\u80fd\u6ce8\u518c");
        }
        if (StrKit.isBlank((String)pwd)) {
            return Resp.fail((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Resp resp = CommonUtils.checkGroupName(nick, "\u6635\u79f0");
        if (!resp.isOk()) {
            return resp;
        }
        if (regType == 1) {
            if (loginname.length() > 48) {
                return Resp.fail((String)"\u90ae\u7bb1\u8fc7\u957f");
            }
            if (!Validator.isEmail((CharSequence)loginname)) {
                return Resp.fail((String)"\u4e0d\u662f\u5408\u6cd5\u7684\u90ae\u7bb1");
            }
        } else if (!Validator.isMobile((CharSequence)loginname)) {
            return Resp.fail((String)"\u4e0d\u662f\u5408\u6cd5\u7684\u624b\u673a\u53f7\u7801");
        }
        if (StrKit.isBlank((String)nick)) {
            return Resp.fail((String)"\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.isNickExists(nick)) {
            return Resp.fail((String)"\u6635\u79f0\u5df2\u88ab\u6ce8\u518c\uff0c\u8bf7\u6362\u4e00\u4e2a\u6635\u79f0");
        }
        if (this.isLoginnameExists(loginname)) {
            return Resp.fail((String)"\u8be5\u8d26\u53f7\u5df2\u6ce8\u518c\uff0c\u5982\u5fd8\u8bb0\u5bc6\u7801\uff0c\u8bf7\u627e\u56de");
        }
        user.setLoginname(loginname);
        user.setNick(nick);
        user.setStatus((byte)1);
        user.setCreatetime(new Date());
        user.setThirdstatus((byte)1);
        if (StrUtil.isBlank((CharSequence)user.getAvatar())) {
            String avatar = AvatarService.nextAvatar();
            user.setAvatar(avatar);
            user.setAvatarbig(avatar);
        }
        return Resp.ok();
    }

    public boolean initRole(User user) {
        UserRole userRoleRel = new UserRole();
        userRoleRel.setUid(user.getId());
        userRoleRel.setRid((byte)2);
        userRoleRel.setStatus((byte)1);
        boolean roleResult = userRoleRel.save();
        return roleResult;
    }

    public boolean initCoinInfo(User user) {
        UserCoin coinInfo = new UserCoin();
        coinInfo.setUid(user.getId());
        boolean coinResult = coinInfo.save();
        return coinResult;
    }

    public boolean initBaseInfo(User user) {
        UserBase baseInfo = new UserBase();
        baseInfo.setUid(user.getId());
        if (user.getUserThird() != null) {
            baseInfo.setPhone("");
        } else {
            baseInfo.setEmail(user.getLoginname());
        }
        boolean baseResult = baseInfo.save();
        return baseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendAuthEmail(byte type, String title, String content, String authCode, String email, String clientIp, String sessionid, RequestExt requestExt) throws Exception {
        Class<RegisterService> clazz = RegisterService.class;
        synchronized (RegisterService.class) {
            Integer n;
            Integer e22;
            ICache cache = Caches.getCache(CacheConfig.EMAIL_SENT_COUNT_PERIP_PERDAY);
            Integer count = (Integer)cache.get(clientIp, Integer.class);
            if (count != null && count >= MgConfService.getInt("email.reg.maxcount.perip.perday", 10)) {
                log.warn("\u8be5IP[{}]\u90ae\u4ef6\u53d1\u9001\u6b21\u6570\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650", (Object)clientIp);
                // ** MonitorExit[clazz] (shouldn't be in output)
                return false;
            }
            ICache cache2 = Caches.getCache(CacheConfig.EMAIL_SENT_COUNT_PERDAY);
            Integer count2 = (Integer)cache2.get("x", Integer.class);
            if (count2 != null && count2 >= MgConfService.getInt("email.reg.maxcount.perday", 100)) {
                log.warn("\u90ae\u4ef6\u53d1\u9001\u6b21\u6570\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650{}", (Object)count2);
                // ** MonitorExit[clazz] (shouldn't be in output)
                return false;
            }
            EmailSendLog emailSendLog = new EmailSendLog();
            emailSendLog.setAuthcode(authCode);
            emailSendLog.setEmailto(email);
            emailSendLog.setIp(clientIp);
            emailSendLog.setIpid(requestExt.getIpInfo().getId());
            emailSendLog.setSession(sessionid);
            if (requestExt.getUserAgent() != null) {
                emailSendLog.setUaid(requestExt.getUserAgent().getId());
            }
            emailSendLog.setCreatetime(new Date());
            try {
                EmailServer emailServer = EmailServerService.me.next();
                String server = emailServer.getServer();
                String fromEmail = emailServer.getEmail();
                String emailPass = EmailKit.getEmailUserPwd(emailServer.getPwd());
                String toEmail = email;
                emailSendLog.setContent(content);
                emailSendLog.setTitle(title);
                emailSendLog.setType(type);
                emailSendLog.setEmailfrom(emailServer.getEmail());
                emailSendLog.setEmailpwd(emailServer.getPwd());
                emailSendLog.setEmailserver(emailServer.getServer());
                EmailKit.sendEmail(server, fromEmail, emailPass, toEmail, title, content);
                emailSendLog.setStatus((byte)1);
            }
            catch (Throwable e3) {
                try {
                    log.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25", e3);
                    emailSendLog.setStatus((byte)2);
                    boolean bl = false;
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return bl;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Integer n2;
                    Integer n3;
                    try {
                        emailSendLog.save();
                    }
                    catch (Exception e5) {
                        log.error(e5.toString(), (Throwable)e5);
                    }
                    count = (Integer)cache.get(clientIp, Integer.class);
                    if (count == null) {
                        count = 1;
                    } else if (count < MgConfService.getInt("email.reg.maxcount.perip.perday", 10)) {
                        n3 = count;
                        n2 = count = Integer.valueOf(count + 1);
                    }
                    cache.put(clientIp, (Serializable)count);
                    count2 = (Integer)cache2.get("x", Integer.class);
                    if (count2 == null) {
                        count2 = 1;
                    } else if (count2 < MgConfService.getInt("email.reg.maxcount.perday", 100)) {
                        n3 = count2;
                        n2 = count2 = Integer.valueOf(count2 + 1);
                    }
                    cache2.put("x", (Serializable)count2);
                }
            }
            try {
                emailSendLog.save();
            }
            catch (Exception e22) {
                log.error(e22.toString(), (Throwable)e22);
            }
            count = (Integer)cache.get(clientIp, Integer.class);
            if (count == null) {
                count = 1;
            } else if (count < MgConfService.getInt("email.reg.maxcount.perip.perday", 10)) {
                e22 = count;
                n = count = Integer.valueOf(count + 1);
            }
            cache.put(clientIp, (Serializable)count);
            count2 = (Integer)cache2.get("x", Integer.class);
            if (count2 == null) {
                count2 = 1;
            } else if (count2 < MgConfService.getInt("email.reg.maxcount.perday", 100)) {
                e22 = count2;
                n = count2 = Integer.valueOf(count2 + 1);
            }
            cache2.put("x", (Serializable)count2);
            // ** MonitorExit[clazz] (shouldn't be in output)
            return true;
        }
    }

    public boolean initWx(User user) {
        Ret ret;
        Byte isFriend;
        Ret checkRet;
        User ai = UserService.ME.getAi();
        User ai2 = UserService.ME.getAi2();
        try {
            checkRet = FriendService.me.isFriend(user, user.getId());
            isFriend = (Byte)RetUtils.getOkTData(checkRet);
            if (Objects.equals(isFriend, (byte)2) && (ret = FriendService.me.addSelfFriend(user)).isFail()) {
                return false;
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        if (ai != null) {
            try {
                checkRet = FriendService.me.isFriend(ai, user.getId());
                isFriend = (Byte)RetUtils.getOkTData(checkRet);
                if (Objects.equals(isFriend, (byte)2) && (ret = FriendService.me.addFriend(ai, user.getId())).isFail()) {
                    return false;
                }
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
        if (ai2 != null && !Objects.equals(ai2.getId(), ai.getId())) {
            try {
                checkRet = FriendService.me.isFriend(ai2, user.getId());
                isFriend = (Byte)RetUtils.getOkTData(checkRet);
                if (Objects.equals(isFriend, (byte)2) && (ret = FriendService.me.addApply(ai2, user.getId(), "\u6211\u662f11111" + ai2.getNick())).isFail()) {
                    return false;
                }
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
        return true;
    }
}

