/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.base;

import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.init.RedisInit;
import org.tio.mg.service.model.stat.TioIpPullblackLog;
import org.tio.mg.service.service.conf.IpBlackListService;
import org.tio.mg.service.service.conf.IpWhiteListService;
import org.tio.sitexxx.service.vo.topic.PullIpToBlackVo;

public class TioIpPullblackLogService {
    private static Logger log = LoggerFactory.getLogger(TioIpPullblackLogService.class);
    public static final TioIpPullblackLogService ME = new TioIpPullblackLogService();

    private boolean save(TioIpPullblackLog tioIpPullblackLog) {
        if (tioIpPullblackLog != null) {
            boolean ret = tioIpPullblackLog.save();
            return ret;
        }
        return false;
    }

    public void addToBlack(TioIpPullblackLog tioIpPullblackLog) {
        String ip = tioIpPullblackLog.getIp();
        int serverport = tioIpPullblackLog.getServerport();
        String remark = tioIpPullblackLog.getRemark();
        boolean isWhiteIp = IpWhiteListService.isWhiteIp(ip);
        if (isWhiteIp) {
            log.warn("ip:[{}]\u662f\u767d\u540d\u5355\uff0c\u4e0d\u5141\u8bb8\u62c9\u9ed1\u3002\u672c\u6b21\u62c9\u9ed1serverport:{}, \u539f\u56e0:{}", new Object[]{ip, serverport, remark});
            return;
        }
        log.warn("ip:{}\u5c06\u88ab\u62c9\u9ed1", (Object)ip);
        PullIpToBlackVo pullIpToBlackVo = new PullIpToBlackVo();
        pullIpToBlackVo.setIp(ip);
        pullIpToBlackVo.setRemark(remark);
        RTopic pullIpToBlackTopic = RedisInit.get().getTopic("PULL_IP_TO_BLACK");
        pullIpToBlackTopic.publish((Object)pullIpToBlackVo);
        ME.save(tioIpPullblackLog);
    }

    public void deleteFromBlack(String ip, int serverport, String remark) {
        log.warn("ip:{}\u4ece\u9ed1\u540d\u5355\u4e2d\u5220\u9664", (Object)ip);
        PullIpToBlackVo pullIpToBlackVo = new PullIpToBlackVo();
        pullIpToBlackVo.setIp(ip);
        pullIpToBlackVo.setRemark(remark);
        pullIpToBlackVo.setType(PullIpToBlackVo.Type.DELETE_IP_FROM_BLACK);
        RTopic pullIpToBlackTopic = RedisInit.get().getTopic("PULL_IP_TO_BLACK");
        pullIpToBlackTopic.publish((Object)pullIpToBlackVo);
        IpBlackListService.me.delete(ip, remark);
    }
}

