/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.base;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.main.UserAgent;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;
import org.tio.utils.hutool.StrUtil;

public class UserAgentService {
    private static Logger log = LoggerFactory.getLogger(UserAgentService.class);
    public static final UserAgentService ME = new UserAgentService();
    public static final UserAgent BLANK_USERAGENT = UserAgent.from("");

    public UserAgent save(final String userAgentStr) {
        if (StrUtil.isBlank((CharSequence)userAgentStr)) {
            return BLANK_USERAGENT;
        }
        ICache cache = Caches.getCache(CacheConfig.USER_AGENT);
        UserAgent userAgentInDb = (UserAgent)((Object)CacheUtils.get((ICache)cache, (String)userAgentStr, (FirsthandCreater)new FirsthandCreater<UserAgent>(){

            public UserAgent create() {
                return (UserAgent)UserAgent.dao.findFirst("select * from user_agent where userAgent=? limit 1", new Object[]{userAgentStr});
            }
        }));
        if (userAgentInDb != null) {
            return userAgentInDb;
        }
        UserAgent userAgent = UserAgent.from(userAgentStr);
        if (userAgent.isSyntaxError()) {
            cache.putTemporary(userAgentStr, (Serializable)((Object)userAgent));
        } else {
            userAgent.save();
            cache.put(userAgentStr, (Serializable)((Object)userAgent));
        }
        return userAgent;
    }
}

