/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.conf;

import cn.hutool.core.util.RandomUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.mg.service.model.conf.Avatar;
import org.tio.utils.lock.LockUtils;

public class AvatarService {
    private static Logger log = LoggerFactory.getLogger(AvatarService.class);
    public static final AvatarService me = new AvatarService();
    static final Avatar dao = (Avatar)new Avatar().dao();
    private static Map<Integer, Avatar> cacheMap = null;
    private static List<Avatar> cacheList = null;
    private static List<Avatar> maleList = null;
    private static List<Avatar> femalelist = null;
    private static List<Avatar> secretlist = null;
    public static final String male = "1";
    public static final String female = "2";
    public static final String secret = "3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Class<AvatarService> clazz = AvatarService.class;
        synchronized (AvatarService.class) {
            cacheMap = null;
            cacheList = null;
            maleList = null;
            femalelist = null;
            secretlist = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public boolean save(Avatar avatar) {
        return avatar.save();
    }

    public static void loadData() {
        AvatarService.clearCache();
        HashMap<Integer, Avatar> tempCache = new HashMap<Integer, Avatar>();
        ArrayList list = null;
        maleList = new ArrayList<Avatar>();
        femalelist = new ArrayList<Avatar>();
        secretlist = new ArrayList<Avatar>();
        try {
            int total = Db.use((String)"tio_site_conf").queryInt("select count(*) from avatar");
            int count = 1000;
            int start = 0;
            if (total > count) {
                start = RandomUtil.randomInt((int)0, (int)(total - count));
            }
            if ((list = dao.find("select * from avatar limit " + start + ", " + count)) == null) {
                list = new ArrayList();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (list == null || list.size() == 0) {
            return;
        }
        for (Avatar avatar : list) {
            tempCache.put(avatar.getId(), avatar);
            if (Objects.equals(avatar.getType(), male)) {
                maleList.add(avatar);
            }
            if (Objects.equals(avatar.getType(), female)) {
                femalelist.add(avatar);
            }
            if (!Objects.equals(avatar.getType(), secret)) continue;
            secretlist.add(avatar);
        }
        cacheList = list;
        cacheMap = tempCache;
    }

    public static String nextAvatar() {
        try {
            int index = RandomUtil.randomInt((int)0, (int)cacheList.size());
            return cacheList.get(index).getPath();
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            return "/img/tio.jpg";
        }
    }

    public static String nextAvatar(String type) {
        try {
            switch (type) {
                case "1": {
                    int index1 = RandomUtil.randomInt((int)0, (int)maleList.size());
                    return maleList.get(index1).getPath();
                }
                case "2": {
                    int index2 = RandomUtil.randomInt((int)0, (int)femalelist.size());
                    return femalelist.get(index2).getPath();
                }
                case "3": {
                    int index3 = RandomUtil.randomInt((int)0, (int)secretlist.size());
                    return secretlist.get(index3).getPath();
                }
            }
            int index4 = RandomUtil.randomInt((int)0, (int)cacheList.size());
            return cacheList.get(index4).getPath();
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            return "/img/tio.jpg";
        }
    }

    public static Avatar get(Integer id) {
        if (cacheMap == null) {
            try {
                LockUtils.runWriteOrWaitRead((String)AvatarService.class.getName(), AvatarService.class, () -> {
                    if (cacheMap == null) {
                        AvatarService.loadData();
                    }
                });
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
        Avatar value = cacheMap.get(id);
        return value;
    }
}

