/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.conf;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.model.conf.Dict;
import org.tio.mg.service.service.atom.AbsTxAtom;
import org.tio.mg.service.utils.PyUtils;
import org.tio.mg.service.utils.RetUtils;

public class MgDictService {
    private static Logger log = LoggerFactory.getLogger(MgDictService.class);
    public static final MgDictService me = new MgDictService();
    static final Dict dictDao = (Dict)new Dict().dao();
    private static String CHILD_DICT_PRE = "child_list_";
    private static Map<String, Object> cacheData = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDict() {
        Class<Dict> clazz = Dict.class;
        synchronized (Dict.class) {
            cacheData = new HashMap<String, Object>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Dict> getChildDictByParentCode(String pcode) {
        String key = CHILD_DICT_PRE + pcode;
        Object childDictList = cacheData.get(key);
        if (childDictList != null) return childDictList != null ? (List)childDictList : new ArrayList();
        Class<Dict> clazz = Dict.class;
        synchronized (Dict.class) {
            if (childDictList != null || (childDictList = dictDao.find("select d.id,d.name,d.code,d.pcode,d.attribute,pd.name pname,d.orderby,d.status from dict d left join dict pd on pd.code = d.pcode where d.pcode = ? order by d.orderby,d.id", new Object[]{pcode})) == null) return childDictList != null ? (List)childDictList : new ArrayList();
            cacheData.put(key, childDictList);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return childDictList != null ? (List)childDictList : new ArrayList();
        }
    }

    public static List<Dict> getChildDictByParentCode(String pcode, String name, Byte status) {
        if (StrUtil.isBlank((CharSequence)name) && status == null) {
            return MgDictService.getChildDictByParentCode(pcode);
        }
        Kv params = Kv.by((Object)"pcode", (Object)pcode);
        if (status != null) {
            params.set((Object)"status", (Object)status);
        }
        if (StrUtil.isNotBlank((CharSequence)name)) {
            params.set((Object)"name", (Object)name);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_conf").getSqlPara("sys.dictQuery", (Map)params);
        return dictDao.find(sqlPara);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ret index(Integer did, Integer topdid) {
        final Dict dict = (Dict)dictDao.findById(did);
        if (dict == null) {
            return RetUtils.noExistParam();
        }
        if (topdid == null) {
            if (Objects.equals(dict.getOrderby(), 1)) {
                return RetUtils.failMsg("\u5df2\u5728\u6700\u9876\u7aef,\u4e0d\u9700\u8981\u8fdb\u884c\u8c03\u6574");
            }
            AbsTxAtom atom = new AbsTxAtom(){

                @Override
                public boolean noTxRun() {
                    int index = 1;
                    Dict newdict = new Dict();
                    newdict.setId(dict.getId());
                    newdict.setOrderby(index);
                    boolean comit = newdict.update();
                    if (!comit) {
                        return this.failRet("\u4fee\u6539\u5931\u8d25");
                    }
                    List<Dict> childs = MgDictService.getChildDictByParentCode(dict.getPcode());
                    if (CollectionUtil.isEmpty(childs)) {
                        return this.failRet("\u7cfb\u7edf\u9519\u8bef");
                    }
                    for (Dict query : childs) {
                        if (Objects.equals(query.getId(), dict.getId())) continue;
                        Dict rep = new Dict();
                        rep.setId(query.getId());
                        rep.setOrderby(++index);
                        boolean update = rep.update();
                        if (update) continue;
                        return this.failRet("\u8c03\u6574\u5931\u8d25");
                    }
                    return true;
                }
            };
            boolean commit = Db.use((String)"tio_site_conf").tx((IAtom)atom);
            if (!commit) {
                return atom.getRetObj();
            }
        } else {
            final Dict brother = (Dict)dictDao.findById(topdid);
            if (brother == null) {
                return RetUtils.failMsg("\u5144\u5f1f\u8282\u70b9\u4e0d\u5b58\u5728");
            }
            AbsTxAtom atom = new AbsTxAtom(){

                @Override
                public boolean noTxRun() {
                    int index = brother.getOrderby() + 1;
                    Dict newdict = new Dict();
                    newdict.setId(dict.getId());
                    newdict.setOrderby(index);
                    boolean comit = newdict.update();
                    if (!comit) {
                        return this.failRet("\u4fee\u6539\u5931\u8d25");
                    }
                    List<Dict> childs = MgDictService.getChildDictByParentCode(dict.getPcode());
                    if (CollectionUtil.isEmpty(childs)) {
                        return this.failRet("\u7cfb\u7edf\u9519\u8bef");
                    }
                    boolean start = false;
                    for (Dict query : childs) {
                        if (Objects.equals(query.getId(), brother.getId())) {
                            start = true;
                            continue;
                        }
                        if (!start || Objects.equals(query.getId(), dict.getId())) continue;
                        Dict rep = new Dict();
                        rep.setId(query.getId());
                        rep.setOrderby(++index);
                        boolean update = rep.update();
                        if (update) continue;
                        return this.failRet("\u8c03\u6574\u5931\u8d25");
                    }
                    return true;
                }
            };
            boolean commit = Db.use((String)"tio_site_conf").tx((IAtom)atom);
            if (!commit) {
                return atom.getRetObj();
            }
        }
        if (StrUtil.isNotBlank((CharSequence)dict.getPcode())) {
            MgDictService.clearChildDictByParent(dict.getPcode());
        }
        Class<Dict> clazz = Dict.class;
        synchronized (Dict.class) {
            cacheData.remove(dict.getCode());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return RetUtils.okOper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearChildDictByParent(String pcode) {
        Class<Dict> clazz = Dict.class;
        synchronized (Dict.class) {
            cacheData.remove(CHILD_DICT_PRE + pcode);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDictByCode(String code, String pcode) {
        Class<Dict> clazz = Dict.class;
        synchronized (Dict.class) {
            cacheData.remove(code);
            cacheData.remove(CHILD_DICT_PRE + pcode);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Dict getDictByCode(String code) {
        Object dict = cacheData.get(code);
        if (dict == null) {
            Class<Dict> clazz = Dict.class;
            // MONITORENTER : org.tio.mg.service.model.conf.Dict.class
            if (dict == null && (dict = dictDao.findFirst("select d.id,d.name,d.code,d.pcode,d.attribute,pd.name pname from dict d left join dict pd on pd.code = d.pcode where d.code = ? order by d.orderby,d.id", new Object[]{code})) != null) {
                cacheData.put(code, dict);
            }
            // MONITOREXIT : clazz
        }
        if (dict == null) return null;
        Dict dict2 = (Dict)((Object)dict);
        return dict2;
    }

    public Dict existDictOfName(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return null;
        }
        return (Dict)dictDao.findFirst("select id,name,code,pcode from dict where name = ?", new Object[]{name});
    }

    public Dict existDictOfCode(String code) {
        if (StrUtil.isBlank((CharSequence)code)) {
            return null;
        }
        return (Dict)dictDao.findFirst("select id,name,code,pcode,depth from dict where code = ?", new Object[]{code});
    }

    public List<Dict> topList(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return dictDao.find("select id,name,code,pcode,depth,status,orderby,attribute from dict where pcode = '-1' order by charindex,id");
        }
        return dictDao.find("select id,name,code,pcode,depth,status,orderby,attribute from dict where pcode = '-1' and name like ? order by charindex,id", new Object[]{"%" + name + "%"});
    }

    public Ret add(Dict dict) {
        if (StrUtil.isBlank((CharSequence)dict.getName())) {
            return RetUtils.failMsg("\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)dict.getCode())) {
            return RetUtils.failMsg("\u7f16\u7801\u4e3a\u7a7a");
        }
        if (Objects.equals(dict.getCode(), "-1")) {
            return RetUtils.failMsg("\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)dict.getPcode())) {
            return RetUtils.failMsg("\u7236\u8282\u70b9code\u4e3a\u7a7a");
        }
        if (this.existDictOfCode(dict.getCode()) != null) {
            return RetUtils.failMsg("\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (this.existDictOfName(dict.getCode()) != null) {
            return RetUtils.failMsg("\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (Objects.equals(dict.getPcode(), "-1")) {
            dict.setDepth(1);
        } else {
            Dict pdict = this.existDictOfCode(dict.getPcode());
            if (pdict == null) {
                return RetUtils.failMsg("\u7236\u8282\u70b9\u4e0d\u5b58\u5728");
            }
            dict.setDepth(pdict.getDepth() + 1);
        }
        dict.setCharindex(PyUtils.getAllChat(dict.getName()));
        boolean save = dict.save();
        if (!save) {
            return RetUtils.failOper();
        }
        if (StrUtil.isNotBlank((CharSequence)dict.getPcode())) {
            MgDictService.clearChildDictByParent(dict.getPcode());
        }
        return RetUtils.okOper();
    }

    public Ret insert(final Dict dict) {
        if (dict.getBid() == null) {
            return RetUtils.failMsg("\u63d2\u5165\u8282\u70b9\u4e3a\u7a7a");
        }
        final Dict brother = (Dict)dictDao.findById(dict.getBid());
        if (brother == null) {
            return RetUtils.failMsg("\u63d2\u5165\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)dict.getName())) {
            return RetUtils.failMsg("\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)dict.getCode())) {
            return RetUtils.failMsg("\u7f16\u7801\u4e3a\u7a7a");
        }
        if (Objects.equals(dict.getCode(), "-1")) {
            return RetUtils.failMsg("\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)dict.getPcode())) {
            return RetUtils.failMsg("\u7236\u8282\u70b9code\u4e3a\u7a7a");
        }
        if (this.existDictOfCode(dict.getCode()) != null) {
            return RetUtils.failMsg("\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (this.existDictOfName(dict.getCode()) != null) {
            return RetUtils.failMsg("\u540d\u79f0\u5df2\u5b58\u5728");
        }
        dict.setDepth(brother.getDepth());
        dict.setCharindex(PyUtils.getAllChat(dict.getName()));
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                int index = brother.getOrderby() + 1;
                dict.setOrderby(index);
                boolean save = dict.save();
                if (!save) {
                    return this.failRet("\u4fdd\u5b58\u5931\u8d25");
                }
                List<Dict> childs = MgDictService.getChildDictByParentCode(dict.getPcode());
                if (CollectionUtil.isEmpty(childs)) {
                    return this.failRet("\u7cfb\u7edf\u9519\u8bef");
                }
                boolean start = false;
                for (Dict query : childs) {
                    if (Objects.equals(query.getId(), brother.getId())) {
                        start = true;
                        continue;
                    }
                    if (!start || Objects.equals(query.getId(), dict.getId())) continue;
                    Dict rep = new Dict();
                    rep.setId(query.getId());
                    rep.setOrderby(++index);
                    boolean update = rep.update();
                    if (update) continue;
                    return this.failRet("\u8c03\u6574\u5931\u8d25");
                }
                return true;
            }
        };
        boolean commit = Db.use((String)"tio_site_conf").tx((IAtom)atom);
        if (!commit) {
            return atom.getRetObj();
        }
        if (StrUtil.isNotBlank((CharSequence)dict.getPcode())) {
            MgDictService.clearChildDictByParent(dict.getPcode());
        }
        return RetUtils.okOper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ret update(Dict dict) {
        if (dict.getId() == null) {
            log.error("\u4fee\u6539\u5b57\u5178\u6570\u636eid\u4e3a\u7a7a");
            return RetUtils.failMsg("id\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)dict.getName())) {
            return RetUtils.failMsg("\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StrUtil.isNotBlank((CharSequence)dict.getCode())) {
            return RetUtils.failMsg("\u7f16\u7801\u4e0d\u53ef\u4fee\u6539");
        }
        if (StrUtil.isNotBlank((CharSequence)dict.getPcode())) {
            return RetUtils.failMsg("\u7236\u8282\u70b9\u4e0d\u53ef\u4fee\u6539");
        }
        Dict old = (Dict)dictDao.findById(dict.getId());
        if (old == null) {
            return RetUtils.failMsg("\u5b57\u5178\u4e0d\u5b58\u5728");
        }
        dict.setCharindex(PyUtils.getAllChat(dict.getName()));
        boolean update = dict.update();
        if (!update) {
            return RetUtils.failOper();
        }
        if (StrUtil.isNotBlank((CharSequence)old.getPcode())) {
            MgDictService.clearChildDictByParent(old.getPcode());
        }
        Class<Dict> clazz = Dict.class;
        synchronized (Dict.class) {
            cacheData.remove(old.getCode());
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return RetUtils.okOper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ret del(final Integer id) {
        final Dict old = (Dict)dictDao.findById(id);
        if (old == null) {
            return RetUtils.noExistParam();
        }
        if (Objects.equals("-1", old.getPcode())) {
            boolean commit = dictDao.deleteById(id);
            if (!commit) {
                return RetUtils.failOper();
            }
        } else {
            AbsTxAtom atom = new AbsTxAtom(){

                @Override
                public boolean noTxRun() {
                    Db.use((String)"tio_site_conf").delete("delete from dict where pcode = ?", new Object[]{old.getCode()});
                    boolean commit = dictDao.deleteById(id);
                    if (!commit) {
                        return this.failRet("\u5220\u9664\u5931\u8d25");
                    }
                    return true;
                }
            };
            boolean commit = Db.use((String)"tio_site_conf").tx((IAtom)atom);
            if (!commit) {
                return RetUtils.failOper();
            }
        }
        if (StrUtil.isNotBlank((CharSequence)old.getPcode())) {
            MgDictService.clearChildDictByParent(old.getPcode());
        }
        Class<Dict> clazz = Dict.class;
        synchronized (Dict.class) {
            MgDictService.clearDictByCode(old.getCode(), old.getCode());
            // ** MonitorExit[var3_5] (shouldn't be in output)
            return RetUtils.okOper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ret disable(Integer id, Byte status) {
        Dict old = (Dict)dictDao.findById(id);
        if (old == null) {
            return RetUtils.noExistParam();
        }
        Dict update = new Dict();
        update.setId(old.getId());
        update.setStatus(status);
        boolean commit = update.update();
        if (!commit) {
            return RetUtils.failOper();
        }
        if (StrUtil.isNotBlank((CharSequence)old.getPcode())) {
            MgDictService.clearChildDictByParent(old.getPcode());
        }
        Class<Dict> clazz = Dict.class;
        synchronized (Dict.class) {
            cacheData.remove(old.getCode());
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return RetUtils.okOper();
        }
    }
}

