/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.idiom;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RandomUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.service.idiom.IdiomVo;
import org.tio.utils.lock.LockUtils;

public class IdiomService {
    private static Logger log = LoggerFactory.getLogger(IdiomService.class);
    private static Map<String, Map<String, IdiomVo>> firstMap;
    private static final String key_pinyin = "\u62fc\u97f3\uff1a";
    private static final String key_paraphrase = "\u91ca\u4e49\uff1a";
    public static final IdiomService me;
    private static boolean inited;

    public IdiomVo get(String idiom) {
        if (StringUtils.isBlank((CharSequence)idiom)) {
            return null;
        }
        String first = idiom.substring(0, 1);
        Map<String, IdiomVo> idiomMap = firstMap.get(first);
        if (idiomMap == null) {
            return null;
        }
        IdiomVo idiomVo = idiomMap.get(idiom);
        return idiomVo;
    }

    public Map<String, IdiomVo> getByFirst(String first) {
        if (StringUtils.isBlank((CharSequence)first)) {
            return null;
        }
        Map<String, IdiomVo> idiomMap = firstMap.get(first);
        return idiomMap;
    }

    private void init() {
        if (!inited) {
            try {
                LockUtils.runWriteOrWaitRead((String)this.getClass().getName(), (Object)this, () -> {
                    if (!inited) {
                        firstMap = new HashMap<String, Map<String, IdiomVo>>();
                        String rootDirStr = FileUtil.getAbsolutePath((String)"classpath:config/idiom/");
                        File rootDir = new File(rootDirStr);
                        File[] files = rootDir.listFiles();
                        int count = 0;
                        if (files != null) {
                            for (File file : files) {
                                List lines = FileUtil.readLines((File)file, (String)"utf-8");
                                for (String line : lines) {
                                    try {
                                        IdiomVo idiomVo = this.parseLine(line);
                                        if (idiomVo == null) continue;
                                        Map<String, IdiomVo> idiomMap = firstMap.get(idiomVo.getFirst());
                                        if (idiomMap == null) {
                                            idiomMap = new HashMap<String, IdiomVo>();
                                            firstMap.put(idiomVo.getFirst(), idiomMap);
                                        }
                                        idiomMap.put(idiomVo.getIdiom(), idiomVo);
                                        ++count;
                                    }
                                    catch (Exception e) {
                                        log.error(line, (Throwable)e);
                                    }
                                }
                            }
                        }
                        log.error("\u4e00\u5171{}\u4e2a\u6210\u8bed", (Object)count);
                        inited = true;
                    }
                });
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
    }

    public IdiomVo next(String firstIdiom) {
        if (StringUtils.isBlank((CharSequence)firstIdiom)) {
            return null;
        }
        String end = StringUtils.substring((String)firstIdiom, (int)(firstIdiom.length() - 1));
        Map<String, IdiomVo> idiomMap = this.getByFirst(end);
        if (idiomMap == null) {
            return null;
        }
        int index = 0;
        if (idiomMap.size() > 1) {
            index = RandomUtil.randomInt((int)0, (int)(idiomMap.size() - 1));
        }
        Set<Map.Entry<String, IdiomVo>> set = idiomMap.entrySet();
        int i = 0;
        for (Map.Entry<String, IdiomVo> entry : set) {
            if (index != i++) continue;
            return entry.getValue();
        }
        return null;
    }

    private IdiomVo parseLine(String line) {
        if (StringUtils.isBlank((CharSequence)(line = StringUtils.trim((String)line)))) {
            return null;
        }
        int pinyinIndex = line.indexOf(key_pinyin);
        if (pinyinIndex <= 0) {
            return null;
        }
        int paraphraseIndex = line.indexOf(key_paraphrase);
        if (paraphraseIndex <= 0) {
            return null;
        }
        if (paraphraseIndex < pinyinIndex) {
            return null;
        }
        String idiom = StringUtils.substring((String)line, (int)0, (int)pinyinIndex).trim();
        if (idiom.length() < 4) {
            return null;
        }
        String first = idiom.substring(0, 1);
        String pinyin = StringUtils.substring((String)line, (int)(pinyinIndex + key_pinyin.length()), (int)paraphraseIndex).trim();
        String paraphrase = StringUtils.substring((String)line, (int)(paraphraseIndex + key_paraphrase.length())).trim();
        IdiomVo idiomVo = new IdiomVo(idiom, first, pinyin, paraphrase);
        return idiomVo;
    }

    public IdiomVo random() {
        int index = RandomUtil.randomInt((int)0, (int)Math.min(1000, firstMap.size() - 1));
        Set<Map.Entry<String, Map<String, IdiomVo>>> set = firstMap.entrySet();
        int i = 0;
        for (Map.Entry<String, Map<String, IdiomVo>> entry : set) {
            if (index != i++) continue;
            return this.random(entry.getKey());
        }
        return null;
    }

    public IdiomVo random(String firstWord) {
        if (StringUtils.isBlank((CharSequence)firstWord)) {
            return null;
        }
        Map<String, IdiomVo> idiomMap = this.getByFirst(firstWord.substring(0, 1));
        if (idiomMap == null) {
            return null;
        }
        int index = 0;
        if (idiomMap.size() > 1) {
            index = RandomUtil.randomInt((int)0, (int)(idiomMap.size() - 1));
        }
        Set<Map.Entry<String, IdiomVo>> set = idiomMap.entrySet();
        int i = 0;
        for (Map.Entry<String, IdiomVo> entry : set) {
            if (index != i++) continue;
            return entry.getValue();
        }
        return null;
    }

    private IdiomService() {
        this.init();
    }

    static {
        me = new IdiomService();
        inited = false;
    }
}

