/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.mg;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.mg.MgAuth;
import org.tio.mg.service.model.mg.MgRecentPath;
import org.tio.mg.service.service.atom.AbsTxAtom;
import org.tio.mg.service.service.mg.MgUserService;
import org.tio.mg.service.utils.RetUtils;
import org.tio.mg.service.vo.MgAuthVo;
import org.tio.mg.service.vo.MgUserAuthInfoVo;
import org.tio.utils.Threads;

public class MgAuthService {
    private static Logger log = LoggerFactory.getLogger(MgAuthService.class);
    public static final MgAuthService ME = new MgAuthService();

    public Ret authlist(String name, Byte status, Byte type) {
        SqlPara sqlPara;
        List authlist;
        Kv params = Kv.create();
        if (type != null) {
            params.set((Object)"type", (Object)type);
        } else {
            params.set((Object)"defaulttype", (Object)3);
        }
        if (StrUtil.isNotBlank((CharSequence)name)) {
            params.set((Object)"name", (Object)("%" + name.trim() + "%"));
        }
        if (status != null) {
            params.set((Object)"status", (Object)status);
        }
        if (CollectionUtil.isEmpty((Collection)(authlist = MgAuth.dao.find(sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.authlist", (Map)params))))) {
            return RetUtils.okData(new ArrayList());
        }
        short deep = ((MgAuth)((Object)authlist.get(0))).getDeep();
        ArrayList<MgAuth> treeList = new ArrayList<MgAuth>();
        HashMap<String, MgAuth> treeMap = new HashMap<String, MgAuth>();
        for (MgAuth auth : authlist) {
            if (Objects.equals(deep, auth.getDeep())) {
                treeList.add(auth);
                if (!Objects.equals(auth.getType(), (byte)1)) continue;
                treeMap.put(auth.getId() + "", auth);
                continue;
            }
            MgAuth pAuth = (MgAuth)((Object)treeMap.get(auth.getPid() + ""));
            if (pAuth == null) {
                log.error("\u83b7\u53d6\u83dc\u5355\u5217\u8868\u65f6\uff0c\u53d1\u73b0\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff0cpid:{},aid:{}", (Object)auth.getPid(), (Object)auth.getId());
                continue;
            }
            List<MgAuth> childs = pAuth.getChilds();
            if (childs == null) {
                childs = new ArrayList<MgAuth>();
                pAuth.setChilds(childs);
            }
            childs.add(auth);
            if (!Objects.equals(auth.getType(), (byte)1)) continue;
            treeMap.put(auth.getId() + "", auth);
        }
        return RetUtils.okData(treeList);
    }

    public Ret menulist() {
        Kv params = Kv.by((Object)"type", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.authlist", (Map)params);
        List authlist = MgAuth.dao.find(sqlPara);
        if (CollectionUtil.isEmpty((Collection)authlist)) {
            return RetUtils.okData(new ArrayList());
        }
        short deep = 1;
        ArrayList<MgAuth> treeList = new ArrayList<MgAuth>();
        HashMap<String, MgAuth> treeMap = new HashMap<String, MgAuth>();
        for (MgAuth auth : authlist) {
            if (Objects.equals(deep, auth.getDeep())) {
                treeList.add(auth);
                treeMap.put(auth.getId() + "", auth);
                continue;
            }
            MgAuth pAuth = (MgAuth)((Object)treeMap.get(auth.getPid() + ""));
            if (pAuth == null) {
                log.error("\u83b7\u53d6\u7eaf\u83dc\u5355\u5217\u8868\u65f6\uff0c\u53d1\u73b0\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff0cpid:{},aid:{}", (Object)auth.getPid(), (Object)auth.getId());
                continue;
            }
            List<MgAuth> childs = pAuth.getChilds();
            if (childs == null) {
                childs = new ArrayList<MgAuth>();
                pAuth.setChilds(childs);
            }
            childs.add(auth);
            treeMap.put(auth.getId() + "", auth);
        }
        return RetUtils.okData(treeList);
    }

    public List<MgAuth> childList(Integer pid) {
        return MgAuth.dao.find("select * from mg_auth where pid = ? order by aindex", new Object[]{pid});
    }

    public void delRidGrantList(Integer rid) {
        Db.use((String)"tio_mg").update("delete from mg_role_auth where rid = ?", new Object[]{rid});
    }

    public void insertTopOtherUpdate(Integer pid) {
        Db.use((String)"tio_mg").update("update mg_auth set aindex = aindex + 1 where pid = ?", new Object[]{pid});
    }

    public void initRidGrant(Integer rid, String aids, Byte status) {
        Kv params = Kv.by((Object)"rid", (Object)rid).set((Object)"aids", (Object)aids).set((Object)"status", (Object)status);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.roleAuthInit", (Map)params);
        int count = Db.use((String)"tio_mg").update(sqlPara);
        if (count <= 0) {
            log.warn("\u5206\u914d\u6743\u9650\u4fee\u6539\u65e0\u53d8\u5316");
        }
    }

    public Ret add(MgAuth auth) {
        if (StrUtil.isBlank((CharSequence)auth.getName())) {
            return RetUtils.failMsg("\u540d\u79f0\u4e3a\u7a7a");
        }
        if (auth.getPid() == null) {
            log.error("\u65b0\u589e\u83dc\u5355\u9519\u8bef\uff1a\u4e0a\u7ea7\u8282\u70b9\u4e3a\u7a7a");
            return RetUtils.failMsg("\u7236\u8282\u70b9\u4e3a\u7a7a");
        }
        if (auth.getType() == null) {
            return RetUtils.failMsg("\u83dc\u5355\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!Objects.equals(auth.getType(), (byte)1)) {
            if (StrUtil.isBlank((CharSequence)auth.getAuthurl()) || StrUtil.isBlank((CharSequence)auth.getRoutekey())) {
                return RetUtils.failMsg("\u975e\u83dc\u5355\u7c7b\u578b\u7684\u8def\u7531\u548c\u9875\u9762\u8def\u5f84\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (this.existRoutekeyForPage(auth.getRoutekey(), null)) {
                return RetUtils.failMsg("\u8def\u7531\u5df2\u5b58\u5728");
            }
        }
        if (Objects.equals(auth.getPid(), -1)) {
            auth.setDeep((short)1);
        } else {
            MgAuth pAuth = (MgAuth)MgAuth.dao.findById(auth.getPid());
            if (pAuth == null) {
                return RetUtils.failMsg("\u7236\u8282\u70b9\u4e0d\u5b58\u5728");
            }
            if (!Objects.equals(pAuth.getType(), (byte)1)) {
                return RetUtils.failMsg("\u7236\u8282\u70b9\u4e0d\u662f\u83dc\u5355");
            }
            auth.setDeep((short)(pAuth.getDeep() + 1));
        }
        boolean save = auth.save();
        if (!save) {
            return RetUtils.failMsg("\u65b0\u589e\u5931\u8d25");
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).clear();
        return RetUtils.okOper();
    }

    public Ret update(final MgAuth auth) {
        MgAuth old;
        if (auth.getId() == null) {
            return RetUtils.failMsg("id\u4e3a\u7a7a");
        }
        if (auth.getPid() == null) {
            log.error("\u4fee\u6539\u83dc\u5355\u9519\u8bef\uff1a\u4e0a\u7ea7\u8282\u70b9\u4e3a\u7a7a");
            return RetUtils.failMsg("\u7236\u8282\u70b9\u4e3a\u7a7a");
        }
        if (auth.getType() == null) {
            return RetUtils.failMsg("\u83dc\u5355\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!Objects.equals(auth.getType(), (byte)1)) {
            if (StrUtil.isBlank((CharSequence)auth.getAuthurl()) || StrUtil.isBlank((CharSequence)auth.getRoutekey())) {
                return RetUtils.failMsg("\u975e\u83dc\u5355\u7c7b\u578b\u7684\u8def\u7531\u548c\u9875\u9762\u8def\u5f84\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (this.existRoutekeyForPage(auth.getRoutekey(), auth.getId())) {
                return RetUtils.failMsg("\u8def\u7531\u5df2\u5b58\u5728");
            }
        }
        if ((old = (MgAuth)MgAuth.dao.findById(auth.getId())) == null) {
            return RetUtils.failMsg("\u83dc\u5355\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(old.getPid(), auth.getPid())) {
            auth.setDeep(old.getDeep());
            boolean update = auth.update();
            if (!update) {
                return RetUtils.failMsg("\u4fee\u6539\u5931\u8d25");
            }
        } else if (Objects.equals(auth.getPid(), -1)) {
            auth.setDeep((short)1);
        } else {
            MgAuth pAuth = (MgAuth)MgAuth.dao.findById(auth.getPid());
            if (pAuth == null) {
                return RetUtils.failMsg("\u7236\u8282\u70b9\u4e0d\u5b58\u5728");
            }
            if (!Objects.equals(pAuth.getType(), (byte)1)) {
                return RetUtils.failMsg("\u7236\u8282\u70b9\u4e0d\u662f\u83dc\u5355");
            }
            auth.setDeep((short)(pAuth.getDeep() + 1));
            if (Objects.equals(old.getDeep(), auth.getDeep()) || !Objects.equals(old.getType(), (byte)1)) {
                boolean update = auth.update();
                if (!update) {
                    return RetUtils.failMsg("\u4fee\u6539\u5931\u8d25");
                }
            } else {
                AbsTxAtom tx = new AbsTxAtom(){

                    @Override
                    public boolean noTxRun() {
                        return MgAuthService.this.updateChildDeep((short)(auth.getDeep() + 1), auth.getId());
                    }
                };
                boolean update = Db.use((String)"tio_mg").tx((IAtom)tx);
                if (!update) {
                    return RetUtils.failMsg("\u4fee\u6539\u5931\u8d25");
                }
            }
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).clear();
        return RetUtils.okOper();
    }

    public Ret del(final Integer aid) {
        if (aid == null) {
            return RetUtils.invalidParam();
        }
        MgAuth auth = (MgAuth)MgAuth.dao.findById(aid);
        if (auth == null) {
            return RetUtils.noExistParam();
        }
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                List<MgAuth> childs = MgAuthService.this.authChildTree(aid);
                if (CollectionUtil.isEmpty(childs)) {
                    return this.failRet("\u7a7a\u6743\u9650\u6811");
                }
                String ids = aid + "";
                for (MgAuth mgAuth : childs) {
                    MgAuth.dao.deleteById(mgAuth.getId());
                    ids = ids + "," + mgAuth.getId();
                }
                MgAuthService.this.delRoleAuths("(" + ids + ")");
                return true;
            }
        };
        boolean commit = Db.use((String)"tio_mg").tx((IAtom)atom);
        if (!commit) {
            return RetUtils.failOper();
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).clear();
        return RetUtils.okOper();
    }

    public void delRoleAuths(String aids) {
        Db.use((String)"tio_mg").delete("delete from mg_role_auth where aid in " + aids);
    }

    public boolean existRoutekeyForPage(String routekey, Integer id) {
        if (id == null) {
            return CollectionUtil.isNotEmpty((Collection)MgAuth.dao.find("select * from mg_auth where routekey = ? and type = ?", new Object[]{routekey, (byte)2}));
        }
        return CollectionUtil.isNotEmpty((Collection)MgAuth.dao.find("select * from mg_auth where routekey = ? and type = ? and id != ?", new Object[]{routekey, (byte)2, id}));
    }

    public MgAuth getAuthByRoutekey(String routekey) {
        return (MgAuth)MgAuth.dao.findFirst("select * from mg_auth where routekey = ? and type = ?", new Object[]{routekey, (byte)2});
    }

    public MgAuth getAuthByAuthurl(String authurl) {
        return (MgAuth)MgAuth.dao.findFirst("select * from mg_auth where authurl = ? and type = ? and `status` = ?", new Object[]{authurl, (byte)3, (byte)1});
    }

    public List<MgAuth> authChildTree(Integer aid) {
        Kv params = Kv.by((Object)"id", (Object)aid);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.authChildTree", (Map)params);
        List authlist = MgAuth.dao.find(sqlPara);
        return authlist;
    }

    public Ret pageoperlist(final Integer mguid, final String path) {
        List<MgAuth> operList;
        if (mguid == null || StrUtil.isBlank((CharSequence)path)) {
            return RetUtils.failMsg("\u65e0\u6548\u53c2\u6570", 2002);
        }
        final MgAuth auth = this.getAuthByRoutekey(path);
        if (auth == null) {
            return RetUtils.failMsg("\u8bb0\u5f55\u4e0d\u5b58\u5728:" + path, 2002);
        }
        MgUserAuthInfoVo authInfoVo = MgUserService.ME.getMgUserAuth(mguid);
        if (authInfoVo == null) {
            return RetUtils.failMsg("\u6743\u9650\u4e0d\u8db3", 1004);
        }
        HashMap<String, MgAuthVo> page = authInfoVo.getPageAuth();
        if (CollectionUtil.isEmpty(page) || page.get(auth.getAuthurl()) == null) {
            return RetUtils.failMsg("\u6743\u9650\u4e0d\u8db3", 1004);
        }
        Kv params = Kv.by((Object)"type", (Object)3).set((Object)"mguid", (Object)mguid).set((Object)"routekey", (Object)path).set((Object)"status", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.pageoperlist", (Map)params);
        List authlist = MgAuth.dao.find(sqlPara);
        HashMap<String, Byte> retMap = new HashMap<String, Byte>();
        if (CollectionUtil.isNotEmpty((Collection)authlist)) {
            for (MgAuth mgAuth : authlist) {
                retMap.put(mgAuth.getRoutekey(), mgAuth.getStatus());
            }
        }
        if (CollectionUtil.isNotEmpty(operList = ME.operlist(path))) {
            for (MgAuth oper : operList) {
                if (retMap.get(oper.getRoutekey()) != null) continue;
                retMap.put(oper.getRoutekey(), (byte)2);
            }
        }
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MgRecentPath recentPath = (MgRecentPath)MgRecentPath.dao.findFirst("select * from mg_recent_path where aid = ? and mguid = ?", new Object[]{auth.getId(), mguid});
                    if (recentPath == null) {
                        recentPath = new MgRecentPath();
                        recentPath.setMguid(mguid);
                        recentPath.setAid(auth.getId());
                        recentPath.setOpercount(1);
                        recentPath.setRoutkey(path);
                        boolean save = recentPath.save();
                        if (save) {
                            return;
                        }
                    }
                    Db.use((String)"tio_mg").update("update mg_recent_path set opercount = opercount + 1 where aid = ? and mguid = ?", new Object[]{auth.getId(), mguid});
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        });
        return RetUtils.okData(retMap);
    }

    public Ret index(Integer aid, final Integer toaid, Byte topflag) {
        if (Objects.equals(aid, toaid)) {
            return RetUtils.invalidParam();
        }
        final MgAuth old = (MgAuth)MgAuth.dao.findById(aid);
        if (old == null) {
            return RetUtils.failMsg("\u83dc\u5355\u5b58\u5728");
        }
        Integer pid = toaid;
        MgAuth brother = null;
        if (!Objects.equals(topflag, (byte)1)) {
            brother = (MgAuth)MgAuth.dao.findById(toaid);
            if (brother == null) {
                return RetUtils.failMsg("\u5144\u5f1f\u8282\u70b9\u4e0d\u5b58\u5728");
            }
            pid = brother.getPid();
        }
        MgAuth parent = null;
        if (!(Objects.equals(pid, -1) || (parent = (MgAuth)MgAuth.dao.findById(pid)) != null && Objects.equals(parent.getType(), (byte)1))) {
            return RetUtils.failMsg("\u65e0\u6548\u7236\u8282\u70b9");
        }
        final List<MgAuth> all = this.childList(pid);
        final List<MgAuth> oldChild = this.childList(aid);
        if (CollectionUtil.isEmpty(all)) {
            final MgAuth finalparent = parent;
            final Integer fPid = pid;
            AbsTxAtom atom = new AbsTxAtom(){

                @Override
                public boolean noTxRun() {
                    MgAuth newAuth = new MgAuth();
                    newAuth.setId(old.getId());
                    newAuth.setPid(fPid);
                    newAuth.setAindex((short)1);
                    if (Objects.equals(toaid, -1)) {
                        newAuth.setDeep((short)1);
                    } else {
                        newAuth.setDeep((short)(finalparent.getDeep() + 1));
                    }
                    boolean update = newAuth.update();
                    if (!update) {
                        return this.failRet("\u8c03\u6574\u5931\u8d25");
                    }
                    if (CollectionUtil.isNotEmpty((Collection)oldChild)) {
                        Db.use((String)"tio_mg").update("update mg_auth set deep = ? where pid = ?", new Object[]{(short)(newAuth.getDeep() + 1), old.getId()});
                    }
                    return true;
                }
            };
            boolean tx = Db.use((String)"tio_mg").tx((IAtom)atom);
            if (!tx) {
                return atom.getRetObj();
            }
        } else {
            final MgAuth finalBrother = brother;
            final MgAuth finalParent = parent;
            AbsTxAtom atom = new AbsTxAtom(){

                @Override
                public boolean noTxRun() {
                    short index = 1;
                    short newDeep = 1;
                    if (finalBrother != null) {
                        index = finalBrother.getAindex();
                        index = (short)(index + 1);
                        MgAuth newAuth = new MgAuth();
                        newAuth.setId(old.getId());
                        newAuth.setPid(finalBrother.getPid());
                        newAuth.setDeep(finalBrother.getDeep());
                        newAuth.setAindex(index);
                        boolean newUpdate = newAuth.update();
                        if (!newUpdate) {
                            return this.failRet("\u8c03\u6574\u5931\u8d25");
                        }
                        newDeep = newAuth.getDeep();
                        boolean insert = false;
                        for (MgAuth auth : all) {
                            if (!insert) {
                                if (!Objects.equals(auth.getId(), finalBrother.getId())) continue;
                                insert = true;
                                continue;
                            }
                            if (Objects.equals(old.getId(), auth.getId())) continue;
                            index = (short)(index + 1);
                            MgAuth inAuth = new MgAuth();
                            inAuth.setId(auth.getId());
                            inAuth.setAindex(index);
                            boolean update = inAuth.update();
                            if (update) continue;
                            return this.failRet("\u8c03\u6574\u5931\u8d25");
                        }
                    } else {
                        MgAuth newAuth = new MgAuth();
                        newAuth.setId(old.getId());
                        newAuth.setPid(toaid);
                        newAuth.setAindex(index);
                        if (Objects.equals(toaid, -1)) {
                            newAuth.setDeep((short)1);
                        } else {
                            newAuth.setDeep((short)(finalParent.getDeep() + 1));
                        }
                        boolean newUpdate = newAuth.update();
                        if (!newUpdate) {
                            return this.failRet("\u8c03\u6574\u5931\u8d25");
                        }
                        newDeep = newAuth.getDeep();
                        MgAuthService.this.insertTopOtherUpdate(toaid);
                    }
                    if (CollectionUtil.isNotEmpty((Collection)oldChild)) {
                        newDeep = (short)(newDeep + 1);
                        Db.use((String)"tio_mg").update("update mg_auth set deep = ? where pid = ?", new Object[]{newDeep, old.getId()});
                    }
                    return true;
                }
            };
            boolean tx = Db.use((String)"tio_mg").tx((IAtom)atom);
            if (!tx) {
                return atom.getRetObj();
            }
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).clear();
        return RetUtils.okOper();
    }

    public Ret disable(Integer aid, Byte status) {
        if (aid == null || status == null) {
            return RetUtils.invalidParam();
        }
        MgAuth auth = (MgAuth)MgAuth.dao.findById(aid);
        if (auth == null) {
            return RetUtils.noExistParam();
        }
        if (Objects.equals(auth.getStatus(), status)) {
            return RetUtils.okOper();
        }
        MgAuth update = new MgAuth();
        update.setId(aid);
        update.setStatus(status);
        boolean commit = update.update();
        if (!commit) {
            return RetUtils.failOper();
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).clear();
        return RetUtils.okOper();
    }

    public boolean updateChildDeep(Short deep, Integer id) {
        List mgAuths = MgAuth.dao.find("select id from mg_auth where pid = ?", new Object[]{id});
        if (CollectionUtil.isEmpty((Collection)mgAuths)) {
            return true;
        }
        short nextDeep = (short)(deep + 1);
        for (MgAuth auth : mgAuths) {
            boolean loopUpdate;
            MgAuth updateAuth = new MgAuth();
            updateAuth.setDeep(deep);
            updateAuth.setId(auth.getId());
            if (!updateAuth.update()) {
                return false;
            }
            if (!Objects.equals(auth.getType(), (byte)1) || (loopUpdate = this.updateChildDeep(nextDeep, auth.getId()))) continue;
            return false;
        }
        return true;
    }

    public Ret pageoperlist(Integer aid) {
        if (aid == null) {
            return RetUtils.invalidParam();
        }
        MgAuth pAuth = (MgAuth)MgAuth.dao.findById(aid);
        if (pAuth == null) {
            return RetUtils.noExistParam();
        }
        if (!Objects.equals(pAuth.getType(), (byte)2)) {
            return RetUtils.failMsg("\u7236\u8282\u70b9\u4e0d\u662f\u9875\u9762");
        }
        List mgAuths = MgAuth.dao.find("select *  from mg_auth where pid = ?", new Object[]{aid});
        return RetUtils.okList(mgAuths);
    }

    public List<MgAuth> operlist(String key) {
        Kv params = Kv.by((Object)"type", (Object)3).set((Object)"status", (Object)1);
        if (StrUtil.isNotBlank((CharSequence)key)) {
            params.set((Object)"key", (Object)key);
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.authOperList", (Map)params);
        List authlist = MgAuth.dao.find(sqlPara);
        return authlist;
    }

    public Ret operdel(final Integer aid) {
        if (aid == null) {
            return RetUtils.invalidParam();
        }
        MgAuth auth = (MgAuth)MgAuth.dao.findById(aid);
        if (auth == null) {
            return RetUtils.noExistParam();
        }
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                MgAuth.dao.deleteById(aid);
                MgAuthService.this.delRoleAuths("(" + aid + ")");
                return true;
            }
        };
        boolean commit = Db.use((String)"tio_mg").tx((IAtom)atom);
        if (!commit) {
            return RetUtils.failOper();
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).clear();
        return RetUtils.okOper();
    }

    public Ret operdisable(Integer aid, Byte status) {
        if (aid == null) {
            return RetUtils.failMsg("id\u4e3a\u7a7a");
        }
        MgAuth old = (MgAuth)MgAuth.dao.findById(aid);
        if (old == null) {
            return RetUtils.failMsg("\u64cd\u4f5c\u4e0d\u5b58\u5728");
        }
        MgAuth auth = new MgAuth();
        auth.setId(aid);
        auth.setStatus(status);
        boolean update = auth.update();
        if (!update) {
            return RetUtils.failMsg("\u4fee\u6539\u5931\u8d25");
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).clear();
        return RetUtils.okOper();
    }

    public Ret operadd(MgAuth auth) {
        if (StrUtil.isBlank((CharSequence)auth.getName())) {
            return RetUtils.failMsg("\u540d\u79f0\u4e3a\u7a7a");
        }
        if (auth.getPid() == null) {
            log.error("\u65b0\u589e\u64cd\u4f5c\u9519\u8bef\uff1a\u4e0a\u7ea7\u8282\u70b9\u4e3a\u7a7a");
            return RetUtils.failMsg("\u7236\u8282\u70b9\u4e3a\u7a7a");
        }
        MgAuth pAuth = (MgAuth)MgAuth.dao.findById(auth.getPid());
        if (pAuth == null) {
            return RetUtils.noExistParam();
        }
        if (!Objects.equals(pAuth.getType(), (byte)2)) {
            return RetUtils.failMsg("\u7236\u8282\u70b9\u4e0d\u662f\u9875\u9762");
        }
        auth.setType((byte)3);
        auth.setDeep((short)(pAuth.getDeep() + 1));
        boolean save = auth.save();
        if (!save) {
            return RetUtils.failMsg("\u65b0\u589e\u5931\u8d25");
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).clear();
        return RetUtils.okOper();
    }

    public Ret operupdate(MgAuth auth) {
        if (auth.getId() == null) {
            return RetUtils.failMsg("id\u4e3a\u7a7a");
        }
        MgAuth old = (MgAuth)MgAuth.dao.findById(auth.getId());
        if (old == null) {
            return RetUtils.failMsg("\u64cd\u4f5c\u4e0d\u5b58\u5728");
        }
        if (auth.getPid() != null && !Objects.equals(auth.getPid(), old.getPid())) {
            return RetUtils.failMsg("\u4e0d\u80fd\u4fee\u6539\u7236\u8282\u70b9");
        }
        boolean update = auth.update();
        if (!update) {
            return RetUtils.failMsg("\u4fee\u6539\u5931\u8d25");
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).clear();
        return RetUtils.okOper();
    }
}

