/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.mg;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.model.mg.MgFavoritePath;
import org.tio.mg.service.service.atom.AbsTxAtom;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.service.utils.RetUtils;

public class MgTopMenuService {
    private static Logger log = LoggerFactory.getLogger(MgTopMenuService.class);
    public static final MgTopMenuService ME = new MgTopMenuService();

    public Ret recentPage(Integer pageSize, Integer mguid) {
        Integer pageNumber = 1;
        if (pageSize == null || pageNumber <= 0) {
            pageSize = MgConfService.getInt("recent.page.size", 15);
        }
        Kv params = Kv.by((Object)"mguid", (Object)mguid).set((Object)"status", (Object)1).set((Object)"type", (Object)2);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.recentPageList", (Map)params);
        Page recentPage = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okList(recentPage.getList());
    }

    public Ret favoritePage(Integer pageSize, Integer mguid) {
        Integer pageNumber = 1;
        if (pageSize == null || pageNumber <= 0) {
            pageSize = MgConfService.getInt("favorite.page.size", 15);
        }
        Kv params = Kv.by((Object)"mguid", (Object)mguid).set((Object)"status", (Object)1).set((Object)"type", (Object)2);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.favoritePageList", (Map)params);
        Page faPage = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okList(faPage.getList());
    }

    public Ret addfavorite(MgFavoritePath path) {
        if (path == null) {
            log.error("\u6536\u85cf\u9875\u9762\u7a7a\u53c2\u6570");
            return RetUtils.invalidParam();
        }
        if (StrUtil.isBlank((CharSequence)path.getRoutkey()) || path.getAid() == null) {
            return RetUtils.invalidParam();
        }
        path.ignoreSave();
        return RetUtils.okOper();
    }

    public Ret delfavorite(Integer id) {
        if (id == null) {
            log.error("\u6536\u85cf\u9875\u9762\u7a7a\u53c2\u6570");
            return RetUtils.invalidParam();
        }
        MgFavoritePath.dao.deleteById(id);
        return RetUtils.okOper();
    }

    public Ret index(Integer id, Integer topid, Integer mguid) {
        final MgFavoritePath path = (MgFavoritePath)MgFavoritePath.dao.findById(id);
        if (path == null) {
            return RetUtils.noExistParam();
        }
        MgFavoritePath brother = null;
        if (topid != null && (brother = (MgFavoritePath)MgFavoritePath.dao.findById(topid)) == null) {
            return RetUtils.failMsg("\u5144\u5f1f\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        final List<Record> records = RetUtils.getOkTList(this.favoritePage(null, mguid));
        if (CollectionUtil.isEmpty(records)) {
            return RetUtils.okOper();
        }
        String ids = "";
        boolean isexist = false;
        boolean isbrother = brother == null;
        for (Record record : records) {
            Integer pathid = record.getInt("id");
            if (!isexist && Objects.equals(pathid, path.getId())) {
                isexist = true;
            }
            if (!isbrother && Objects.equals(pathid, brother.getId())) {
                isbrother = true;
            }
            ids = ids + "," + pathid;
        }
        if (!isexist) {
            return RetUtils.noExistParam();
        }
        if (!isbrother) {
            return RetUtils.failMsg("\u5144\u5f1f\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        ids = "(" + ids.substring(1) + ")";
        Db.use((String)"tio_mg").update("delete from mg_favorite_path where id not in " + ids);
        if (topid == null) {
            if (Objects.equals(path.getFindex(), (short)1)) {
                return RetUtils.failMsg("\u5df2\u5728\u6700\u9876\u7aef,\u4e0d\u9700\u8981\u8fdb\u884c\u8c03\u6574");
            }
            AbsTxAtom atom = new AbsTxAtom(){

                @Override
                public boolean noTxRun() {
                    short index = MgConfService.getInt("favorite.page.size", 15).shortValue();
                    MgFavoritePath newpath = new MgFavoritePath();
                    newpath.setId(path.getId());
                    newpath.setFindex(index);
                    boolean comit = newpath.update();
                    if (!comit) {
                        return this.failRet("\u4fee\u6539\u5931\u8d25");
                    }
                    for (Record query : records) {
                        Integer queryid = query.getInt("id");
                        if (Objects.equals(queryid, path.getId())) continue;
                        index = (short)(index - 1);
                        MgFavoritePath rep = new MgFavoritePath();
                        rep.setId(queryid);
                        rep.setFindex(index);
                        boolean update = rep.update();
                        if (update) continue;
                        return this.failRet("\u8c03\u6574\u5931\u8d25");
                    }
                    return true;
                }
            };
            boolean commit = Db.use((String)"tio_site_conf").tx((IAtom)atom);
            if (!commit) {
                return atom.getRetObj();
            }
        } else {
            final MgFavoritePath finalbrother = new MgFavoritePath();
            AbsTxAtom atom = new AbsTxAtom(){

                @Override
                public boolean noTxRun() {
                    short index = (short)(finalbrother.getFindex() - 1);
                    MgFavoritePath newpath = new MgFavoritePath();
                    newpath.setId(path.getId());
                    newpath.setFindex(index);
                    boolean comit = newpath.update();
                    if (!comit) {
                        return this.failRet("\u4fee\u6539\u5931\u8d25");
                    }
                    boolean start = false;
                    for (Record query : records) {
                        Integer queryid = query.getInt("id");
                        if (Objects.equals(queryid, finalbrother.getId())) {
                            start = true;
                            continue;
                        }
                        if (!start || Objects.equals(queryid, path.getId())) continue;
                        index = (short)(index - 1);
                        MgFavoritePath rep = new MgFavoritePath();
                        rep.setId(queryid);
                        rep.setFindex(index);
                        boolean update = rep.update();
                        if (update) continue;
                        return this.failRet("\u8c03\u6574\u5931\u8d25");
                    }
                    return true;
                }
            };
            boolean commit = Db.use((String)"tio_site_conf").tx((IAtom)atom);
            if (!commit) {
                return atom.getRetObj();
            }
        }
        return RetUtils.okOper();
    }
}

