/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.stat;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.model.stat.TioIpPathAccessStat;
import org.tio.mg.service.utils.QueryUtils;

public class StatService {
    private static Logger log = LoggerFactory.getLogger(StatService.class);
    public static final StatService me = new StatService();
    final TioIpPathAccessStat dao = (TioIpPathAccessStat)new TioIpPathAccessStat().dao();
    private static final int MAX_STAT_DAY = 60;

    public List<Record> requestCountByDay(Integer days) {
        if (days == null) {
            days = 7;
        } else {
            if (days > 60) {
                days = 60;
            }
            if (days < 0) {
                days = 7;
            }
        }
        String cacheKey = "stat.requestCountByDay_" + days;
        return QueryUtils.findWithCache(CacheConfig.MG_TIME_TO_LIVE_MINUTE_5, cacheKey, "tio_site_stat", "stat.requestCountByDay", true, days);
    }

    public List<Record> ipCountByDay(Integer days) {
        if (days == null) {
            days = 7;
        } else {
            if (days > 60) {
                days = 60;
            }
            if (days < 0) {
                days = 7;
            }
        }
        String cacheKey = "stat.ipCountByDay_" + days;
        return QueryUtils.findWithCache(CacheConfig.MG_TIME_TO_LIVE_MINUTE_5, cacheKey, "tio_site_stat", "stat.ipCountByDay", true, days);
    }

    public static void main(String[] args) {
    }

    public List<Record> statIpAndHitsByProvince(Integer days) {
        if (days == null) {
            days = 7;
        } else {
            if (days > 60) {
                days = 60;
            }
            if (days < 0) {
                days = 7;
            }
        }
        String cacheKey = "stat.statIpAndHitsByProvince_" + days;
        return QueryUtils.findWithCache(CacheConfig.MG_TIME_TO_LIVE_MINUTE_5, cacheKey, "tio_site_stat", "stat.statIpAndHitsByProvince", true, days);
    }

    public Page<Record> ip(Boolean mergeRequest, String starttime, String endtime, Integer pageNumber, Integer pageSize) {
        Kv kv = Kv.by((Object)"starttime", (Object)starttime).set((Object)"endtime", (Object)endtime).set((Object)"mergeRequest", (Object)mergeRequest);
        Page page = Db.use((String)"tio_site_stat").template("stat.ip", (Map)kv).paginate(pageNumber.intValue(), pageSize.intValue());
        return page;
    }
}

