/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.tioim;

import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.model.main.WxChatItems;
import org.tio.mg.service.utils.RetUtils;

public class TioChatService {
    private static Logger log = LoggerFactory.getLogger(TioChatService.class);
    public static final TioChatService me = new TioChatService();

    public Ret chatItemList(Integer uid, Integer pageNumber, Integer pageSize) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        if (uid == null) {
            log.error("\u83b7\u53d6\u804a\u5929\u5217\u8868\uff1a\u65e0\u6548\u7528\u6237");
            return Ret.fail((Object)"msg", (Object)"\u65e0\u6548\u53c2\u6570");
        }
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"viewflag", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.list", (Map)params);
        Page pages = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(pages);
    }

    public Ret chatMsgList(Long chatlinkid, Integer pageNumber, Integer pageSize) {
        WxChatItems chatItems;
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        if ((chatItems = (WxChatItems)WxChatItems.dao.findById(chatlinkid)) == null) {
            log.error("\u83b7\u53d6\u804a\u5929\u5217\u8868\uff1a\u65e0\u6548\u4f1a\u8bdd");
            return RetUtils.noExistParam();
        }
        Kv params = Kv.create();
        String sqlParaName = "";
        if (Objects.equals(chatItems.getChatmode(), (byte)1)) {
            sqlParaName = "p2pMsg";
            params.set((Object)"key", (Object)chatItems.getFidkey());
        } else {
            sqlParaName = "groupMsg";
            params.set((Object)"key", (Object)chatItems.getBizid());
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat." + sqlParaName, (Map)params);
        Page pages = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(pages);
    }

    public Ret groupList(Integer pageNumber, Integer pageSize, Integer uid) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.groupList", (Map)params);
        Page pages = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(pages);
    }

    public Ret groupMsgList(Integer pageNumber, Integer pageSize, Long groupid) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.by((Object)"key", (Object)groupid);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.groupMsg", (Map)params);
        Page pages = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(pages);
    }

    public Ret groupInfo(Long groupid) {
        Record group = Db.use((String)"tio_site_main").findFirst("select g.*,m.joinnum,u.avatar,u.loginname,u.nick from wx_group g INNER JOIN wx_group_meta m on m.groupid = g.id INNER JOIN `user` u on u.id = g.uid where g.id = ?", new Object[]{groupid});
        return RetUtils.okData(group);
    }

    public Ret groupUserList(Long groupid, Integer pageNumber, Integer pageSize) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.groupUserlist", (Map)params);
        Page records = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret friendList(Integer pageNumber, Integer pageSize, Integer uid) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.friendList", (Map)params);
        Page pages = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(pages);
    }

    public Ret applyList(Integer pageNumber, Integer pageSize, Integer uid) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.applylist", (Map)params);
        Page pages = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(pages);
    }

    public Ret friendMsgList(Integer pageNumber, Integer pageSize, Integer uid, Integer touid) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        String fidkey = "";
        fidkey = uid > touid ? uid + "_" + touid : touid + "_" + uid;
        Kv params = Kv.by((Object)"key", (Object)fidkey);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.p2pMsg", (Map)params);
        Page pages = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(pages);
    }
}

