/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.tioim;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.model.main.User;
import org.tio.mg.service.utils.PeriodUtils;
import org.tio.mg.service.utils.RetUtils;
import org.tio.mg.service.vo.MgConst;
import org.tio.utils.jfinal.P;

public class TioUserService {
    private static Logger log = LoggerFactory.getLogger(TioUserService.class);
    public static final TioUserService me = new TioUserService();

    public Ret list(Integer pageNumber, Integer pageSize, String searchkey, Byte status) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.create();
        if (StrUtil.isNotBlank((CharSequence)searchkey)) {
            params.set((Object)"searchkey", (Object)("%" + searchkey + "%"));
            params.set((Object)"searchid", (Object)searchkey);
        }
        if (status != null) {
            params.set((Object)"status", (Object)status);
        } else {
            params.set((Object)"defaultstatus", (Object)3);
        }
        boolean allowOper = P.getBoolean((String)"oper.open.flag", (Boolean)true);
        if (!allowOper) {
            params.set((Object)"noemail", (Object)1);
        } else {
            params.set((Object)"email", (Object)1);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("tiouser.list", (Map)params);
        Page records = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret info(Integer uid) {
        Kv params = Kv.by((Object)"uid", (Object)uid);
        boolean allowOper = P.getBoolean((String)"oper.open.flag", (Boolean)true);
        if (!allowOper) {
            params.set((Object)"noemail", (Object)1);
        } else {
            params.set((Object)"email", (Object)1);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("tiouser.info", (Map)params);
        Record record = Db.use((String)"tio_site_main").findFirst(sqlPara);
        return RetUtils.okData(record);
    }

    public Ret statlist(Integer pageNumber, Integer pageSize, String searchkey, Integer ipid) {
        boolean allowOper;
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.create();
        DateTime dateTime = PeriodUtils.getDateByPeriod(searchkey);
        params.set((Object)"starttime", (Object)DateUtil.beginOfDay((Date)dateTime));
        params.set((Object)"endtime", (Object)DateUtil.endOfDay((Date)dateTime));
        if (ipid != null) {
            params.set((Object)"ipid", (Object)ipid);
        }
        if (!(allowOper = P.getBoolean((String)"oper.open.flag", (Boolean)true).booleanValue())) {
            params.set((Object)"noemail", (Object)1);
        } else {
            params.set((Object)"email", (Object)1);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("tiouser.statlist", (Map)params);
        Page records = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret resetPwd(Integer uid) {
        if (uid == null) {
            log.error("\u7528\u6237id\u4e3a\u7a7a");
            return RetUtils.invalidParam();
        }
        User user = (User)User.dao.findById(uid);
        if (user == null) {
            return RetUtils.failMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String resetPwd = TioUserService.getMd5Pwd(user.getLoginname(), MgConst.MG_USER_DEFAULT_PWD);
        User update = new User();
        update.setId(user.getId());
        update.setPwd(resetPwd);
        boolean ret = update.update();
        if (!ret) {
            return RetUtils.failOper();
        }
        return RetUtils.okOper();
    }

    public Ret disable(Integer uid, Byte status) {
        if (uid == null) {
            return RetUtils.invalidParam();
        }
        User user = (User)User.dao.findById(uid);
        if (user == null) {
            return RetUtils.failMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(user.getStatus(), status)) {
            return RetUtils.okOper();
        }
        User update = new User();
        update.setId(user.getId());
        update.setStatus(status);
        boolean ret = update.update();
        if (!ret) {
            return RetUtils.failOper();
        }
        return RetUtils.okOper();
    }

    public static String getMd5Pwd(String loginname, String plainpwd) {
        String pwd = SecureUtil.md5((String)("${" + StrUtil.trim((CharSequence)loginname) + "}" + StrUtil.trim((CharSequence)plainpwd)));
        return pwd;
    }
}

