/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.tool;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.Enumeration;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.json.Json;

public class MakePomFromJars {
    private static Logger log = LoggerFactory.getLogger(MakePomFromJars.class);
    static File rootFile = new File("d:/maked");
    static File errorFile = new File(rootFile, "error_pom.xml");
    static StringBuffer errorsb = new StringBuffer(2048);
    static File pomFile = new File(rootFile, "pom.xml");
    static StringBuffer pomsb = new StringBuffer(2048);
    static File allFile = new File(rootFile, "all_pom.xml");
    static StringBuffer allsb = new StringBuffer(2048);
    static File notMatchingFile = new File(rootFile, "not_matching_pom.xml");
    static StringBuffer notmatchingsb = new StringBuffer(2048);
    static File allMsgFile = new File(rootFile, "all_msg.json");
    static StringBuffer allmsgsb = new StringBuffer(2048);
    static File timeInvalidFile = new File(rootFile, "time_invalid.json");
    static StringBuffer timeInvalidSb = new StringBuffer(2048);
    static ExecutorService executors = Executors.newFixedThreadPool(4);

    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (!rootFile.exists()) {
            FileUtil.mkdir((File)rootFile);
        }
        DOMElement dependencys = new DOMElement("dependencys");
        File dir = new File("G:\\svn_qianyi\\SourceCodes\\Backend\\Java\\1080-fencang-agent\\trunk\\src\\main\\webapp\\WEB-INF\\lib");
        final File errorLib = new File("G:\\svn_qianyi\\SourceCodes\\Backend\\Java\\1080-fencang-agent\\trunk\\src\\main\\webapp\\WEB-INF\\lib-error2");
        File timeInvalidDir = new File("G:\\svn_qianyi\\SourceCodes\\Backend\\Java\\1080-fencang-agent\\trunk\\src\\main\\webapp\\WEB-INF\\lib-timeInvalid");
        FileUtil.del((File)timeInvalidDir);
        File[] files = dir.listFiles();
        CountDownLatch cdl = new CountDownLatch(files.length);
        for (final File jar : files) {
            Runnable r = new Runnable((Element)dependencys, timeInvalidDir, cdl){
                final /* synthetic */ Element val$dependencys;
                final /* synthetic */ File val$timeInvalidDir;
                final /* synthetic */ CountDownLatch val$cdl;
                {
                    this.val$dependencys = element;
                    this.val$timeInvalidDir = file3;
                    this.val$cdl = countDownLatch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        JarInputStream jis = new JarInputStream(new FileInputStream(jar));
                        Manifest mainmanifest = jis.getManifest();
                        jis.close();
                        if (mainmanifest == null) {
                            return;
                        }
                        String bundleName = mainmanifest.getMainAttributes().getValue("Bundle-Name");
                        String bundleVersion = mainmanifest.getMainAttributes().getValue("Bundle-Version");
                        Element dependency = null;
                        if (bundleName != null) {
                            bundleName = bundleName.toLowerCase().replace(" ", "-");
                            dependency = MakePomFromJars.getDependency(bundleName, bundleVersion, jar);
                        }
                        if (dependency == null || dependency.elements().size() == 0) {
                            bundleName = "";
                            bundleVersion = "";
                            String[] ns = jar.getName().replace(".jar", "").split("-");
                            boolean startVersion = false;
                            for (String s : ns) {
                                if (startVersion || Character.isDigit(s.charAt(0))) {
                                    bundleVersion = bundleVersion + s + "-";
                                    startVersion = true;
                                    continue;
                                }
                                bundleName = bundleName + s + "-";
                            }
                            if (bundleVersion.endsWith("-")) {
                                bundleVersion = bundleVersion.substring(0, bundleVersion.length() - 1);
                            }
                            if (bundleName.endsWith("-")) {
                                bundleName = bundleName.substring(0, bundleName.length() - 1);
                            }
                            dependency = MakePomFromJars.getDependency(bundleName, bundleVersion, jar);
                        }
                        if (dependency.elements().size() == 0) {
                            dependency.add(new DOMElement("groupId").addText("not find"));
                            dependency.add(new DOMElement("artifactId").addText(bundleName));
                            dependency.add(new DOMElement("version").addText(bundleVersion));
                            errorsb.append(jar.getPath()).append("\r\n");
                            FileUtil.copy((File)jar, (File)new File(errorLib, jar.getName()), (boolean)true);
                        } else {
                            pomsb.append(dependency.asXML()).append("\r\n");
                            this.val$dependencys.add(dependency);
                        }
                        allsb.append(dependency.asXML()).append("\r\n").append(jar.getPath()).append("\r\n\r\n");
                        try {
                            JarFile jarFile = new JarFile(jar);
                            Enumeration<JarEntry> entrys = jarFile.entries();
                            Long stdTime = null;
                            boolean copied = false;
                            while (entrys.hasMoreElements()) {
                                JarEntry jarEntry = entrys.nextElement();
                                String name = jarEntry.getName();
                                if (!name.endsWith(".class")) continue;
                                try {
                                    FileTime fileTime = jarEntry.getLastModifiedTime();
                                    Date date = new Date(fileTime.toMillis());
                                    int year = DateUtil.year((Date)date);
                                    int month = DateUtil.month((Date)date);
                                    if (stdTime == null) {
                                        stdTime = fileTime.toMillis();
                                        continue;
                                    }
                                    if (copied || year <= 2016) continue;
                                    DateUtil.formatDate((Date)new Date(fileTime.toMillis()));
                                    timeInvalidSb.append(jar.getPath()).append("\r\n");
                                    FileUtil.copy((File)jar, (File)new File(this.val$timeInvalidDir, year + "-" + month + jar.getName()), (boolean)true);
                                    copied = true;
                                }
                                catch (Exception e) {
                                    log.error(e.toString(), (Throwable)e);
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error(e.toString(), (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                    finally {
                        this.val$cdl.countDown();
                    }
                }
            };
            executors.execute(r);
        }
        try {
            cdl.await();
        }
        catch (InterruptedException e) {
            log.error(e.toString(), (Throwable)e);
        }
        FileUtil.writeString((String)pomsb.toString(), (File)pomFile, (String)"utf-8");
        FileUtil.writeString((String)errorsb.toString(), (File)errorFile, (String)"utf-8");
        FileUtil.writeString((String)allsb.toString(), (File)allFile, (String)"utf-8");
        FileUtil.writeString((String)notmatchingsb.toString(), (File)notMatchingFile, (String)"utf-8");
        FileUtil.writeString((String)allmsgsb.toString(), (File)allMsgFile, (String)"utf-8");
        System.exit(0);
    }

    public static Element getDependency(String key, String ver, File jar) {
        DOMElement dependency = new DOMElement("dependency");
        try {
            String url = "http://search.maven.org/solrsearch/select?q=a%3A%22" + key + "%22%20AND%20v%3A%22" + ver + "%22&rows=3&wt=json";
            Document doc = Jsoup.connect((String)url).ignoreContentType(true).timeout(30000).get();
            String elem = doc.body().text();
            JSONObject response = JSONObject.parseObject((String)elem).getJSONObject("response");
            if (response.containsKey((Object)"docs") && response.getJSONArray("docs").size() > 0) {
                JSONObject docJson = response.getJSONArray("docs").getJSONObject(0);
                docJson.put("jarFile", (Object)jar.getPath());
                String josnStr = Json.toFormatedJson((Object)docJson);
                allmsgsb.append(josnStr).append("\r\n");
                String groupId = docJson.getString("g");
                String artifactId = docJson.getString("a");
                String version = docJson.getString("v");
                DOMElement groupIdEle = new DOMElement("groupId");
                DOMElement artifactIdEle = new DOMElement("artifactId");
                DOMElement versionEle = new DOMElement("version");
                groupIdEle.addText(groupId);
                artifactIdEle.addText(artifactId);
                versionEle.addText(version);
                dependency.add((Element)groupIdEle);
                dependency.add((Element)artifactIdEle);
                dependency.add((Element)versionEle);
                if (!Objects.equals(artifactId + "-" + version, FileUtil.mainName((File)jar))) {
                    notmatchingsb.append(josnStr).append("\r\n");
                }
            }
        }
        catch (Exception e) {
            log.error(jar.getPath(), (Throwable)e);
        }
        return dependency;
    }
}

