/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import java.util.Date;
import java.util.Objects;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.tio.sitexxx.service.utils.ChineseYuanUtil;

public class PeriodUtils {
    public static String dateToPeriodByType(Date date, byte periodType) {
        if (periodType == 9) {
            return "total";
        }
        String periodFormat = "yyyyMMdd";
        if (Objects.equals(periodType, (byte)4)) {
            periodFormat = periodFormat.substring(0, 4);
        } else if (Objects.equals(periodType, (byte)3)) {
            periodFormat = periodFormat.substring(0, 6);
        } else if (Objects.equals(periodType, (byte)2)) {
            date = DateUtil.beginOfWeek((Date)date);
        } else if (Objects.equals(periodType, (byte)5)) {
            date = DateUtil.beginOfQuarter((Date)date);
        } else if (Objects.equals(periodType, (byte)6)) {
            periodFormat = "HH";
        } else if (Objects.equals(periodType, (byte)7)) {
            periodFormat = "HH:mm";
        }
        String period = DateUtil.format((Date)date, (String)periodFormat);
        if (Objects.equals(periodType, (byte)2)) {
            period = period + "W";
        } else if (Objects.equals(periodType, (byte)5)) {
            period = period + "Q";
        }
        return period;
    }

    public static DateTime getDateByPeriod(String period) {
        int length = period.length();
        if (length == 5) {
            return new DateTime();
        }
        if (period.indexOf("W") >= 0) {
            period = period.substring(0, period.length() - 1);
        }
        if (period.indexOf("Q") >= 0) {
            period = period.substring(0, period.length() - 1);
        }
        if (period.length() == 4) {
            period = period + "0101";
        }
        if (period.length() == 6) {
            period = period + "01";
        }
        if (period.length() == 10) {
            period = period + "0000";
        }
        return DateUtil.parse((CharSequence)period);
    }

    public static int getDayByPeriodNum(Byte periodType, Integer num) {
        int result = num;
        switch (periodType) {
            case 1: {
                break;
            }
            case 2: {
                result = num * 7;
                break;
            }
            case 3: {
                result = num * 30;
                break;
            }
            case 5: {
                result = num * 90;
                break;
            }
            case 4: {
                result = num * 365;
                break;
            }
        }
        return result;
    }

    public static Date getCouponPeriod(Byte periodType, Integer num, Date date) {
        if (num <= 0) {
            num = 1;
        }
        if (date == null) {
            date = new DateTime();
        }
        DateTime result = null;
        switch (periodType) {
            case 1: {
                result = DateUtil.offsetDay((Date)date, (int)num);
                break;
            }
            case 2: {
                result = DateUtil.offsetWeek((Date)date, (int)num);
                break;
            }
            case 3: {
                result = DateUtil.offsetMonth((Date)date, (int)num);
                break;
            }
            case 5: {
                result = DateUtil.offsetMonth((Date)date, (int)(num * 3));
                break;
            }
            case 4: {
                result = DateUtil.offsetMonth((Date)date, (int)(num * 12));
                break;
            }
            default: {
                result = DateUtil.offsetDay((Date)date, (int)num);
            }
        }
        return result;
    }

    private static void setcell(XSSFRow creRow, XSSFRow row, int index, String value) {
        XSSFCell cell = row.getCell(index);
        CellType type = cell.getCellType();
        XSSFCell cell1 = creRow.createCell(index, type);
        cell1.setCellStyle((CellStyle)row.getCell(index).getCellStyle());
        cell1.setCellValue(value);
    }

    public static void main(String[] args) {
        System.out.println(ChineseYuanUtil.convert((String)"33.05"));
    }

    public static class InnerVo {
        private String period;
        private String name;
        private Double accout;
        private Integer num;
        private String remark;
        private String nick;

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Double getAccout() {
            return this.accout;
        }

        public void setAccout(Double accout) {
            this.accout = accout;
        }

        public Integer getNum() {
            return this.num;
        }

        public void setNum(Integer num) {
            this.num = num;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public String getNick() {
            return this.nick;
        }

        public void setNick(String nick) {
            this.nick = nick;
        }
    }
}

